/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.items;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.wrappers.FluidHandlerWrapper;
import worldcontrolteam.worldcontrol.api.card.CardState;
import worldcontrolteam.worldcontrol.api.card.StringWrapper;
import worldcontrolteam.worldcontrol.items.ItemBaseCard;
import worldcontrolteam.worldcontrol.utils.NBTUtils;
import worldcontrolteam.worldcontrol.utils.WCUtility;

public class ItemFluidCard
extends ItemBaseCard {
    public ItemFluidCard() {
        super("fluid_card");
    }

    @Override
    public CardState update(World world, ItemStack card) {
        if (card.func_77942_o()) {
            IFluidTankProperties[] properties;
            BlockPos pos = NBTUtils.getBlockPos(card.func_77978_p());
            if (world.func_175625_s(pos) instanceof IFluidHandler) {
                properties = ((IFluidHandler)world.func_175625_s(pos)).getTankProperties();
            } else if (world.func_175625_s(pos) instanceof net.minecraftforge.fluids.IFluidHandler) {
                properties = new FluidHandlerWrapper((net.minecraftforge.fluids.IFluidHandler)world.func_175625_s(pos), EnumFacing.DOWN).getTankProperties();
            } else {
                return CardState.NO_TARGET;
            }
            if (properties != null) {
                card.func_77978_p().func_74768_a("capacity", properties[0].getCapacity());
                if (properties[0].getContents() != null) {
                    card.func_77978_p().func_74768_a("amount", properties[0].getContents().amount);
                    card.func_77978_p().func_74778_a("fluid", properties[0].getContents().getFluid().getName());
                } else {
                    card.func_77978_p().func_82580_o("amount");
                    card.func_77978_p().func_82580_o("fluid");
                }
                return CardState.OK;
            }
        }
        return CardState.NO_TARGET;
    }

    @Override
    public List<StringWrapper> getStringData(List<StringWrapper> list, int displaySettings, ItemStack card, boolean showLabels) {
        if (card.func_77942_o()) {
            int amount;
            String fluid = null;
            if (card.func_77978_p().func_74764_b("fluid")) {
                fluid = card.func_77978_p().func_74779_i("fluid");
            }
            int capacity = card.func_77978_p().func_74762_e("capacity");
            int n = amount = card.func_77978_p().func_74764_b("amount") ? card.func_77978_p().func_74762_e("amount") : 0;
            if (fluid != null) {
                list.add(new StringWrapper(WCUtility.translateFormatted("liquid_name", fluid)));
            } else {
                list.add(new StringWrapper(WCUtility.translateFormatted("liquid_name", WCUtility.translate("none"))));
            }
            list.add(new StringWrapper(WCUtility.translateFormatted("liquid_amount", amount)));
            list.add(new StringWrapper(WCUtility.translateFormatted("liquid_free", capacity - amount)));
            list.add(new StringWrapper(WCUtility.translateFormatted("liquid_capacity", capacity)));
            list.add(new StringWrapper(WCUtility.translateFormatted("liquid_percentage", capacity == 0 ? 100 : amount / capacity * 100)));
        }
        return list;
    }

    @Override
    public List<String> getGuiData() {
        return null;
    }

    @Override
    public int getCardColor() {
        return WCUtility.LIGHT_BLUE;
    }
}

