/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.items;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import worldcontrolteam.worldcontrol.api.card.CardState;
import worldcontrolteam.worldcontrol.api.card.StringWrapper;
import worldcontrolteam.worldcontrol.items.ItemBaseCard;
import worldcontrolteam.worldcontrol.utils.WCUtility;

public class ItemCardTime
extends ItemBaseCard {
    public ItemCardTime() {
        super("time_card");
    }

    @Override
    public CardState update(World world, ItemStack card) {
        int time = (int)((world.func_72820_D() + 6000L) % 24000L);
        int hours = time / 1000;
        int minutes = time % 1000 * 6 / 100;
        String suffix = "";
        String string = suffix = hours < 12 ? "AM" : "PM";
        if ((hours %= 12) == 0) {
            hours += 12;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("time", String.format("%02d:%02d %s", hours, minutes, suffix));
        card.func_77982_d(tag);
        return CardState.OK;
    }

    @Override
    public List<StringWrapper> getStringData(List<StringWrapper> list, int displaySettings, ItemStack card, boolean showLabels) {
        StringWrapper text = new StringWrapper();
        text.textLeft = WCUtility.translateFormatted("time_card.time", card.func_77978_p().func_74779_i("time"));
        list.add(text);
        return list;
    }

    @Override
    public List<String> getGuiData() {
        return null;
    }

    @Override
    public int getCardColor() {
        return WCUtility.YELLOW;
    }
}

