/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.items;

import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import worldcontrolteam.worldcontrol.api.thermometer.IHeatSeeker;
import worldcontrolteam.worldcontrol.items.WCBaseItem;
import worldcontrolteam.worldcontrol.utils.WCUtility;

public class ItemThermometer
extends WCBaseItem {
    private static List<IHeatSeeker> heatTypes;

    public ItemThermometer() {
        super("thermometer");
        this.func_77625_d(1);
        this.func_77656_e(102);
    }

    public static void addInHeatTypes(List<IHeatSeeker> types) {
        heatTypes = types;
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!heatTypes.isEmpty()) {
            int toUse;
            IHeatSeeker user;
            if (!stack.func_77942_o()) {
                NBTTagCompound tagCompound = new NBTTagCompound();
                tagCompound.func_74768_a("type", 0);
                stack.func_77982_d(tagCompound);
            }
            if (stack.func_77978_p() != null && (user = heatTypes.get(toUse = stack.func_77978_p().func_74762_e("type"))).canUse(world, pos, world.func_175625_s(pos))) {
                if (!world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentString(WCUtility.translateFormatted("thermometer.chat_info", user.getHeat(world, pos, world.func_175625_s(pos)))));
                }
                stack.func_77972_a(10, (EntityLivingBase)player);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        if (!heatTypes.isEmpty()) {
            if (itemStack.func_77942_o()) {
                NBTTagCompound tag = itemStack.func_77978_p();
                int currentType = tag.func_74762_e("type");
                if (currentType + 1 < heatTypes.size()) {
                    tag.func_74768_a("type", currentType++);
                } else {
                    tag.func_74768_a("type", 0);
                }
            } else {
                NBTTagCompound tagCompound = new NBTTagCompound();
                tagCompound.func_74768_a("type", 0);
                itemStack.func_77982_d(tagCompound);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        try {
            tooltip.add(WCUtility.translateFormatted("thermometer.mode", WCUtility.translate("thermometer.mode." + heatTypes.get(stack.func_77978_p().func_74762_e("type")).getUnloalizedName())));
        }
        catch (NullPointerException e) {
            tooltip.add(WCUtility.translateFormatted("thermometer.mode", WCUtility.translate("thermometer.unset")));
        }
    }
}

