/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.utils;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.GameRegistry;
import worldcontrolteam.worldcontrol.utils.WCUtility;

public class NBTUtils {
    public static final String BLOCK_POS = "blockPos";
    public static final String ITEM_NAME = "registryName";
    public static final String METADATA = "meta";
    public static final String STACKSIZE = "stacksize";
    public static final String NBTTAG = "tag";
    public static final String TITLE = "title";

    public static NBTTagCompound writeBlockPos(NBTTagCompound tagCompound, BlockPos pos) {
        tagCompound.func_74772_a(BLOCK_POS, pos.func_177986_g());
        return tagCompound;
    }

    public static BlockPos getBlockPos(NBTTagCompound tagCompound) {
        return BlockPos.func_177969_a((long)tagCompound.func_74763_f(BLOCK_POS));
    }

    public static NBTTagCompound writeItemStack(NBTTagCompound tagCompound, ItemStack stack) {
        tagCompound.func_74778_a(ITEM_NAME, stack.func_77973_b().getRegistryName().toString());
        tagCompound.func_74768_a(METADATA, stack.func_77960_j());
        tagCompound.func_74768_a(STACKSIZE, stack.field_77994_a);
        tagCompound.func_74778_a(NBTTAG, stack.func_77978_p().toString());
        return tagCompound;
    }

    public static ItemStack getItemStack(NBTTagCompound tagCompound) {
        try {
            return GameRegistry.makeItemStack((String)tagCompound.func_74779_i(ITEM_NAME), (int)tagCompound.func_74762_e(METADATA), (int)tagCompound.func_74762_e(STACKSIZE), (String)tagCompound.func_74779_i(NBTTAG));
        }
        catch (Exception e) {
            WCUtility.error(String.format("Itemstack failed to transfer via NBT. Args are: Item: %s, Meta: %s, Stacksize: %s, Tag: %s", tagCompound.func_74779_i(ITEM_NAME), tagCompound.func_74762_e(METADATA), tagCompound.func_74762_e(STACKSIZE), tagCompound.func_74779_i(NBTTAG)));
            return null;
        }
    }

    public static NBTTagCompound writeTitle(NBTTagCompound tagCompound, String title) {
        tagCompound.func_74778_a(TITLE, title);
        return tagCompound;
    }

    public static String getTitle(NBTTagCompound tagCompound) {
        return tagCompound.func_74779_i(TITLE);
    }
}

