/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.chemistry;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.recipe.IRecipeInput;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableFuel;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotOutput;
import ihl.processing.chemistry.ApparatusProcessableInvSlot;
import ihl.processing.chemistry.LeadOvenContainer;
import ihl.processing.chemistry.LeadOvenGui;
import ihl.processing.invslots.IHLInvSlotOutput;
import ihl.processing.invslots.InvSlotConsumableLiquidIHL;
import ihl.recipes.RecipeOutputItemStack;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import ihl.utils.IHLFluidTank;
import ihl.utils.IHLUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class LeadOvenTileEntity
extends TileEntityInventory
implements IHasGui,
IFluidHandler {
    public final InvSlotConsumableFuel fuelSlot;
    public final ApparatusProcessableInvSlot inputSlot;
    public final IHLInvSlotOutput outputSlot;
    public final IHLFluidTank inputTank = new IHLFluidTank(1000);
    public final IHLFluidTank outputTank = new IHLFluidTank(1000);
    public final InvSlotConsumableLiquidIHL drainInputSlot;
    public final InvSlotConsumableLiquidIHL fillInputSlot;
    public final InvSlotOutput emptyFluidItemsSlot;
    public final InvSlotConsumableLiquidIHL drainInputSlot2;
    public final InvSlotConsumableLiquidIHL fillInputSlot2;
    public short progress = 0;
    public final short maxProgress = (short)160;
    public int fuel = 0;
    public int maxFuel = 0;
    protected static final UniversalRecipeManager recipeManager = new UniversalRecipeManager("chemicaloven");

    public LeadOvenTileEntity() {
        this.fuelSlot = new InvSlotConsumableFuel((TileEntityInventory)this, "fuel", 1, 1, true);
        this.inputSlot = new ApparatusProcessableInvSlot(this, "input", 2, InvSlot.Access.IO, 2, 64);
        this.outputSlot = new IHLInvSlotOutput(this, "output", 0, 1);
        this.drainInputSlot = new InvSlotConsumableLiquidIHL(this, "drainInput", -1, InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Drain);
        this.fillInputSlot = new InvSlotConsumableLiquidIHL(this, "fillInput", -1, InvSlot.Access.I, 1, InvSlot.InvSide.BOTTOM, InvSlotConsumableLiquid.OpType.Fill);
        this.drainInputSlot2 = new InvSlotConsumableLiquidIHL(this, "drainInput", -1, InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Drain);
        this.fillInputSlot2 = new InvSlotConsumableLiquidIHL(this, "fillInput", -1, InvSlot.Access.I, 1, InvSlot.InvSide.BOTTOM, InvSlotConsumableLiquid.OpType.Fill);
        this.emptyFluidItemsSlot = new InvSlotOutput((TileEntityInventory)this, "fluidCellsOutput", 2, 2);
    }

    public static void addRecipe(UniversalRecipeInput input, UniversalRecipeOutput output) {
        recipeManager.addRecipe(input, output);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.fuel = nbttagcompound.func_74762_e("fuel");
        this.maxFuel = nbttagcompound.func_74762_e("maxFuel");
        this.progress = nbttagcompound.func_74765_d("progress");
        this.inputTank.readFromNBT(nbttagcompound.func_74775_l("inputTank"));
        this.outputTank.readFromNBT(nbttagcompound.func_74775_l("outputTank"));
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("fuel", this.fuel);
        nbttagcompound.func_74768_a("maxFuel", this.maxFuel);
        nbttagcompound.func_74777_a("progress", this.progress);
        NBTTagCompound inputTankTag = new NBTTagCompound();
        this.inputTank.writeToNBT(inputTankTag);
        nbttagcompound.func_74782_a("inputTank", (NBTBase)inputTankTag);
        NBTTagCompound outputTankTag = new NBTTagCompound();
        this.outputTank.writeToNBT(outputTankTag);
        nbttagcompound.func_74782_a("outputTank", (NBTBase)outputTankTag);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != (short)side && side != 0 && side != 1;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return IHLUtils.getThisModItemStack("leadOven");
    }

    public int gaugeProgressScaled(int i) {
        return this.progress * i / 160;
    }

    public int gaugeFuelScaled(int i) {
        if (this.maxFuel == 0) {
            this.maxFuel = this.fuel;
            if (this.maxFuel == 0) {
                this.maxFuel = 160;
            }
        }
        return this.fuel * i / this.maxFuel;
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void updateEntityServer() {
        super.updateEntityServer();
        IHLUtils.handleFluidSlotsBehaviour(this.fillInputSlot, this.drainInputSlot, this.emptyFluidItemsSlot, this.inputTank);
        IHLUtils.handleFluidSlotsBehaviour(this.fillInputSlot2, this.drainInputSlot2, this.emptyFluidItemsSlot, this.outputTank);
        if (this.fuel <= 0 && this.canOperate()) {
            this.fuel = this.maxFuel = this.fuelSlot.consumeFuel();
        }
        if (this.isBurning() && this.canOperate()) {
            this.progress = (short)(this.progress + 1);
            if (this.progress >= 160) {
                this.progress = 0;
                this.operate();
            }
        } else {
            this.progress = 0;
        }
        if (this.fuel > 0) {
            --this.fuel;
        }
        if (this.getActive() != this.isBurning()) {
            this.setActive(this.isBurning());
        }
    }

    public boolean isBurning() {
        return this.fuel > 0;
    }

    public boolean canOperate() {
        return this.getOutput() != null;
    }

    public String func_145825_b() {
        return "goldOven";
    }

    public ContainerBase<LeadOvenTileEntity> getGuiContainer(EntityPlayer entityPlayer) {
        return new LeadOvenContainer(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new LeadOvenGui(new LeadOvenContainer(entityPlayer, this));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public UniversalRecipeOutput getOutput() {
        return recipeManager.getOutputFor(this.getInput());
    }

    public List[] getInput() {
        if (this.inputSlot.get(1) != null) {
            return new List[]{this.inputTank.getFluidList(), Arrays.asList(this.inputSlot.get(0), this.inputSlot.get(1))};
        }
        return new List[]{this.inputTank.getFluidList(), Arrays.asList(this.inputSlot.get())};
    }

    public void operate() {
        UniversalRecipeInput rinput = recipeManager.getRecipeInput(this.getInput());
        List<IRecipeInput> rinputItems = rinput.getItemInputs();
        UniversalRecipeOutput routput = recipeManager.getOutputFor(this.getInput());
        List<FluidStack> output2 = routput.getFluidOutputs();
        if (!output2.isEmpty()) {
            this.outputTank.fill(output2.get(0), true);
        }
        this.inputTank.drain(rinput.getFluidInputs(), true);
        List<RecipeOutputItemStack> itemOutputs = routput.getItemOutputs();
        if (itemOutputs != null && !itemOutputs.isEmpty()) {
            this.outputSlot.add(itemOutputs);
        }
        for (int i = 0; i < rinputItems.size(); ++i) {
            this.inputSlot.consume(rinputItems.get(i));
        }
    }

    public FluidStack drain(ForgeDirection from, int amount, boolean doDrain) {
        switch (from) {
            case UP: {
                return this.outputTank.drainLightest(amount, doDrain);
            }
            case NORTH: {
                return this.outputTank.drainLightest(amount, doDrain);
            }
            case SOUTH: {
                return this.outputTank.drainLightest(amount, doDrain);
            }
            case WEST: {
                return this.outputTank.drainLightest(amount, doDrain);
            }
            case EAST: {
                return this.outputTank.drainLightest(amount, doDrain);
            }
            case DOWN: {
                return this.outputTank.drain(amount, doDrain);
            }
        }
        return this.outputTank.drain(amount, doDrain);
    }

    public boolean canDrain(ForgeDirection arg0, Fluid arg1) {
        return true;
    }

    public boolean canFill(ForgeDirection direction, Fluid arg1) {
        return direction.equals((Object)ForgeDirection.getOrientation((int)this.getFacing()).getOpposite());
    }

    public static void addRecipe(UniversalRecipeInput input, FluidStack fluidStackWithSize) {
        recipeManager.addRecipe(input, new UniversalRecipeOutput(new FluidStack[]{fluidStackWithSize}, null, 20));
    }

    public static Map<UniversalRecipeInput, UniversalRecipeOutput> getRecipes() {
        return recipeManager.getRecipes();
    }

    public static void addRecipe(IRecipeInput recipeInputOreDict, FluidStack fluidStackOutput, ItemStack output) {
        recipeManager.addRecipe(new UniversalRecipeInput(null, new IRecipeInput[]{recipeInputOreDict}), new UniversalRecipeOutput(new FluidStack[]{fluidStackOutput}, new ItemStack[]{output}, 20));
    }

    public static void addRecipe(IRecipeInput input, ItemStack output) {
        recipeManager.addRecipe(new UniversalRecipeInput(null, new IRecipeInput[]{input}), new UniversalRecipeOutput(null, new ItemStack[]{output}, 20));
    }

    public FluidStack drain(ForgeDirection arg0, FluidStack fluidStack, boolean doDrain) {
        if (this.outputTank.getFluid() != null && this.outputTank.getFluid().containsFluid(fluidStack)) {
            return this.outputTank.drain(fluidStack, doDrain);
        }
        return null;
    }

    public int fill(ForgeDirection arg0, FluidStack arg1, boolean arg2) {
        return this.inputTank.fill(arg1, arg2);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection arg0) {
        return new FluidTankInfo[]{this.inputTank.getInfo()};
    }
}

