/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.invslots;

import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.util.StackUtil;
import ihl.utils.IHLUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.apache.commons.lang3.mutable.MutableObject;

public class InvSlotConsumableLiquidIHL
extends InvSlotConsumableLiquid {
    private InvSlotConsumableLiquid.OpType opType;
    private String additionalInputs;

    public InvSlotConsumableLiquidIHL(TileEntityInventory base1, String name1, int oldStartIndex1, InvSlot.Access access1, int count, InvSlot.InvSide preferredSide1, InvSlotConsumableLiquid.OpType opType1) {
        super(base1, name1, oldStartIndex1, access1, count, preferredSide1, opType1);
        this.opType = opType1;
    }

    public InvSlotConsumableLiquidIHL(TileEntityInventory base1, String name1, int oldStartIndex1, InvSlot.Access access1, int count, InvSlot.InvSide preferredSide1, InvSlotConsumableLiquid.OpType opType1, String additionalInputs1) {
        super(base1, name1, oldStartIndex1, access1, count, preferredSide1, opType1);
        this.opType = opType1;
        this.additionalInputs = additionalInputs1;
    }

    public FluidStack drain(Fluid fluid, int maxAmount, MutableObject<ItemStack> output, boolean simulate) {
        if (output != null) {
            output.setValue((Object)null);
        }
        if (this.opType != InvSlotConsumableLiquid.OpType.Drain && this.opType != InvSlotConsumableLiquid.OpType.Both) {
            return null;
        }
        ItemStack stack = this.get();
        if (stack == null) {
            return null;
        }
        if (!FluidContainerRegistry.isFilledContainer((ItemStack)stack)) {
            if (stack.func_77973_b() instanceof IFluidContainerItem) {
                IFluidContainerItem var9 = (IFluidContainerItem)stack.func_77973_b();
                if (var9.getFluid(stack) == null) {
                    return null;
                }
                if (fluid != null && var9.getFluid(stack).getFluid() != fluid) {
                    return null;
                }
                if (!this.acceptsLiquid(var9.getFluid(stack).getFluid())) {
                    return null;
                }
                ItemStack singleStack = StackUtil.copyWithSize((ItemStack)stack, (int)1);
                FluidStack fluidStack = var9.drain(singleStack, maxAmount, true);
                if (fluidStack != null && fluidStack.amount > 0) {
                    if (singleStack.field_77994_a <= 0) {
                        if (!simulate) {
                            --stack.field_77994_a;
                        }
                    } else if (var9.getFluid(singleStack) == null) {
                        if (output != null) {
                            output.setValue((Object)singleStack);
                        }
                        if (!simulate) {
                            --stack.field_77994_a;
                        }
                    } else {
                        if (stack.field_77994_a > 1) {
                            return null;
                        }
                        if (!simulate) {
                            this.put(singleStack);
                        }
                    }
                    if (stack.field_77994_a <= 0) {
                        this.put(null);
                    }
                    return fluidStack;
                }
                return null;
            }
            return null;
        }
        FluidStack container = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        if (container != null && (fluid == null || fluid == container.getFluid())) {
            if (!this.acceptsLiquid(container.getFluid())) {
                return null;
            }
            if (container.amount > 0 && container.amount <= maxAmount) {
                if (stack.func_77973_b().hasContainerItem(stack) && output != null) {
                    output.setValue((Object)stack.func_77973_b().getContainerItem(stack));
                } else {
                    ItemStack emptystack = FluidContainerRegistry.drainFluidContainer((ItemStack)stack);
                    if (emptystack != null && output != null) {
                        output.setValue((Object)emptystack);
                    }
                }
                if (!simulate) {
                    --stack.field_77994_a;
                    if (stack.field_77994_a <= 0) {
                        this.put(null);
                    }
                }
                return container;
            }
            return null;
        }
        return null;
    }

    public boolean accepts(ItemStack stack) {
        block12: {
            IFluidContainerItem containerItem2;
            FluidStack prevFluid1;
            Item item;
            block13: {
                String fon;
                if (stack == null) {
                    return true;
                }
                item = stack.func_77973_b();
                if (item == null) {
                    return false;
                }
                if (this.additionalInputs != null && (fon = IHLUtils.getFirstOreDictName(stack)) != null && fon.contains(this.additionalInputs)) {
                    return true;
                }
                if (this.opType == InvSlotConsumableLiquid.OpType.Drain || this.opType == InvSlotConsumableLiquid.OpType.Both) {
                    FluidStack containerItem = null;
                    if (FluidContainerRegistry.isFilledContainer((ItemStack)stack)) {
                        containerItem = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
                    } else if (item instanceof IFluidContainerItem) {
                        containerItem = ((IFluidContainerItem)item).getFluid(stack);
                    }
                    if (containerItem != null && containerItem.amount > 0) {
                        return true;
                    }
                }
                if (this.opType != InvSlotConsumableLiquid.OpType.Fill && this.opType != InvSlotConsumableLiquid.OpType.Both) break block12;
                if (!FluidContainerRegistry.isEmptyContainer((ItemStack)stack)) break block13;
                if (this.getPossibleFluids() == null) {
                    return true;
                }
                for (Fluid prevFluid : this.getPossibleFluids()) {
                    if (FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(prevFluid, Integer.MAX_VALUE), (ItemStack)stack) == null) continue;
                    return true;
                }
                break block12;
            }
            if (!(item instanceof IFluidContainerItem) || (prevFluid1 = (containerItem2 = (IFluidContainerItem)item).getFluid(stack)) != null && containerItem2.getCapacity(stack) <= prevFluid1.amount) break block12;
            if (this.getPossibleFluids() == null) {
                return true;
            }
            ItemStack singleStack = StackUtil.copyWithSize((ItemStack)stack, (int)1);
            for (Fluid fluid : this.getPossibleFluids()) {
                if (containerItem2.fill(singleStack, new FluidStack(fluid, Integer.MAX_VALUE), false) <= 0) continue;
                return true;
            }
        }
        return false;
    }
}

