/*
 * Decompiled with CFR 0.152.
 */
package ihl.model;

import ihl.model.RenderInfo;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class FluidRenderer {
    private static RenderBlocks renderBlocks = new RenderBlocks();
    private static final ResourceLocation BLOCK_TEXTURE = TextureMap.field_110575_b;
    private static final Map<Fluid, int[]> flowingRenderCache = new HashMap<Fluid, int[]>();
    private static final Map<Fluid, int[]> stillRenderCache = new HashMap<Fluid, int[]>();
    public static final int DISPLAY_STAGES = 100;
    private static final RenderInfo liquidBlock = new RenderInfo();

    public static IIcon getFluidTexture(FluidStack fluidStack, boolean flowing) {
        IIcon icon;
        if (fluidStack == null) {
            return ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
        }
        IIcon iIcon = icon = flowing ? fluid.getFlowingIcon() : fluid.getStillIcon();
        if (icon == null) {
            icon = ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
        }
        return icon;
    }

    public static ResourceLocation getFluidSheet(FluidStack liquid) {
        return BLOCK_TEXTURE;
    }

    public static ResourceLocation setupFlowingLiquidTexture(FluidStack liquid, IIcon[] texArray) {
        if (liquid == null || liquid.amount <= 0) {
            return null;
        }
        Fluid fluid = liquid.getFluid();
        if (fluid == null) {
            return null;
        }
        IIcon top = fluid.getStillIcon();
        IIcon side = fluid.getFlowingIcon();
        texArray[0] = top;
        texArray[1] = top;
        texArray[2] = side;
        texArray[3] = side;
        texArray[4] = side;
        texArray[5] = side;
        return FluidRenderer.getFluidSheet(liquid);
    }

    public static int[] getLiquidDisplayLists(FluidStack fluidStack) {
        return FluidRenderer.getLiquidDisplayLists(fluidStack, false);
    }

    public static int[] getLiquidDisplayLists(FluidStack fluidStack, boolean flowing) {
        if (fluidStack == null) {
            return null;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return null;
        }
        Map<Fluid, int[]> cache = flowing ? flowingRenderCache : stillRenderCache;
        int[] diplayLists = cache.get(fluid);
        if (diplayLists != null) {
            return diplayLists;
        }
        diplayLists = new int[100];
        FluidRenderer.liquidBlock.texture[0] = null;
        if (fluid.getBlock() != null) {
            FluidRenderer.liquidBlock.template = fluid.getBlock();
            FluidRenderer.liquidBlock.texture[0] = FluidRenderer.getFluidTexture(fluidStack, flowing);
        } else {
            FluidRenderer.liquidBlock.template = Blocks.field_150355_j;
            FluidRenderer.liquidBlock.texture[0] = FluidRenderer.getFluidTexture(fluidStack, flowing);
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2884);
        for (int s = 0; s < 100; ++s) {
            diplayLists[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)diplayLists[s], (int)4864);
            FluidRenderer.liquidBlock.minX = 0.01f;
            FluidRenderer.liquidBlock.minY = 0.0f;
            FluidRenderer.liquidBlock.minZ = 0.01f;
            FluidRenderer.liquidBlock.maxX = 0.99f;
            FluidRenderer.liquidBlock.maxY = (float)s / 100.0f;
            FluidRenderer.liquidBlock.maxZ = 0.99f;
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            RenderInfo info = liquidBlock;
            renderBlocks.func_147782_a((double)info.minX, (double)info.minY, (double)info.minZ, (double)info.maxX, (double)info.maxY, (double)info.maxZ);
            if (info.renderSide[0]) {
                renderBlocks.func_147768_a(info.template, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(0));
            }
            if (info.renderSide[1]) {
                renderBlocks.func_147806_b(info.template, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(1));
            }
            if (info.renderSide[2]) {
                renderBlocks.func_147761_c(info.template, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(2));
            }
            if (info.renderSide[3]) {
                renderBlocks.func_147734_d(info.template, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(3));
            }
            if (info.renderSide[4]) {
                renderBlocks.func_147798_e(info.template, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(4));
            }
            if (info.renderSide[5]) {
                renderBlocks.func_147764_f(info.template, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(5));
            }
            tessellator.func_78381_a();
            GL11.glEndList();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        cache.put(fluid, diplayLists);
        return diplayLists;
    }

    static {
        FluidRenderer.liquidBlock.texture = new IIcon[1];
    }
}

