/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.chemistry;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotOutput;
import ihl.processing.chemistry.DosingPumpContainer;
import ihl.processing.chemistry.DosingPumpGui;
import ihl.processing.invslots.InvSlotConsumableLiquidIHL;
import ihl.processing.metallurgy.BasicElectricMotorTileEntity;
import ihl.utils.IHLFluidTank;
import ihl.utils.IHLUtils;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class DosingPumpTileEntity
extends BasicElectricMotorTileEntity
implements IFluidHandler {
    public final InvSlotConsumableLiquidIHL drainInputSlot;
    public final InvSlotConsumableLiquidIHL fillInputSlot;
    public final InvSlotOutput emptyFluidItemsSlot;
    private final IHLFluidTank fluidTank = new IHLFluidTank(8000);
    public int fluidAmountSetpoint = 8000;
    private boolean prevIsPowered = false;
    private boolean tickFree = false;

    public DosingPumpTileEntity() {
        this.drainInputSlot = new InvSlotConsumableLiquidIHL(this, "drainInput", -1, InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Drain);
        this.fillInputSlot = new InvSlotConsumableLiquidIHL(this, "fillInput", -1, InvSlot.Access.I, 1, InvSlot.InvSide.BOTTOM, InvSlotConsumableLiquid.OpType.Fill);
        this.emptyFluidItemsSlot = new InvSlotOutput((TileEntityInventory)this, "fluidCellsOutput", 2, 1);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.fluidTank.readFromNBT(nbttagcompound.func_74775_l("fluidTank"));
        this.fluidAmountSetpoint = nbttagcompound.func_74762_e("fluidAmountSetpoint");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagCompound fluidTankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(fluidTankTag);
        nbttagcompound.func_74782_a("fluidTank", (NBTBase)fluidTankTag);
        nbttagcompound.func_74768_a("fluidAmountSetpoint", this.fluidAmountSetpoint);
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return IHLUtils.getThisModItemStack("dosingPump");
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.tickFree = true;
        IHLUtils.handleFluidSlotsBehaviour(this.fillInputSlot, this.drainInputSlot, this.emptyFluidItemsSlot, this.fluidTank);
    }

    public FluidStack drain(ForgeDirection from, int amount, boolean doDrain) {
        switch (from) {
            case UP: {
                return this.fluidTank.drainLightest(amount, doDrain);
            }
            case NORTH: {
                return this.fluidTank.drainLightest(amount, doDrain);
            }
            case SOUTH: {
                return this.fluidTank.drainLightest(amount, doDrain);
            }
            case WEST: {
                return this.fluidTank.drainLightest(amount, doDrain);
            }
            case EAST: {
                return this.fluidTank.drainLightest(amount, doDrain);
            }
            case DOWN: {
                return this.fluidTank.drain(amount, doDrain);
            }
        }
        return this.fluidTank.drain(amount, doDrain);
    }

    public boolean canDrain(ForgeDirection arg0, Fluid arg1) {
        return true;
    }

    public boolean canFill(ForgeDirection direction, Fluid arg1) {
        return !direction.equals((Object)ForgeDirection.getOrientation((int)this.getFacing()));
    }

    @Override
    public String func_145825_b() {
        return "dosingPump";
    }

    public float getRenderLiquidLevel() {
        return (float)this.fluidTank.getFluidAmount() / (float)this.fluidTank.getCapacity();
    }

    @Override
    public int gaugeProgressScaled(int i) {
        return this.progress * i / this.operationLength;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean arg1) {
        return new DosingPumpGui(new DosingPumpContainer(player, this));
    }

    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        this.fluidTank.sortFluidsByDensity();
        return new DosingPumpContainer(player, this);
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canOperate() {
        return false;
    }

    @Override
    public void operate() {
        int fluidAmountToDrain = this.fluidAmountSetpoint;
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.getFacing());
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
        if (te instanceof IFluidHandler) {
            IFluidHandler fhte = (IFluidHandler)te;
            for (int i = 0; i < this.fluidTank.getNumberOfFluids(); ++i) {
                FluidStack drained = this.fluidTank.drain(fluidAmountToDrain, true);
                fluidAmountToDrain -= drained.amount;
                if (fhte.canFill(dir, drained.getFluid())) {
                    fhte.fill(dir, drained, true);
                }
                if (fluidAmountToDrain <= 0) break;
            }
        }
        this.energy -= this.energyConsume / 10.0;
    }

    public FluidStack drain(ForgeDirection arg0, FluidStack fluidStack, boolean doDrain) {
        if (this.fluidTank.getFluid() != null && this.fluidTank.getFluid().containsFluid(fluidStack)) {
            return this.fluidTank.drain(fluidStack, doDrain);
        }
        return null;
    }

    public int fill(ForgeDirection arg0, FluidStack arg1, boolean arg2) {
        return this.fluidTank.fill(arg1, arg2);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection arg0) {
        return new FluidTankInfo[]{this.fluidTank.getInfo()};
    }

    public boolean needsFluid() {
        return this.fluidTank.getFluidAmount() <= this.fluidTank.getCapacity();
    }

    public FluidStack getFluidStackfromTank() {
        return this.fluidTank.getFluid();
    }

    public int getTankAmount() {
        return this.fluidTank.getFluidAmount();
    }

    public int gaugeLiquidScaled(int i, int index) {
        return this.fluidTank.getFluidAmount() <= 0 ? 0 : this.fluidTank.getFluidAmount(index) * i / this.fluidTank.getCapacity();
    }

    public int getNumberOfFluidsInTank() {
        return this.fluidTank.getNumberOfFluids();
    }

    public IHLFluidTank getFluidTank() {
        return this.fluidTank;
    }

    @Override
    public List<?>[] getInput() {
        return null;
    }

    public void setPowered(boolean isPowered) {
        if (isPowered && !this.prevIsPowered && this.energy > 0.0 && this.tickFree) {
            this.operate();
        }
        this.prevIsPowered = isPowered;
        this.tickFree = false;
    }
}

