/*
 * Decompiled with CFR 0.152.
 */
package ihl.recipes;

import ic2.api.recipe.IRecipeInput;
import ihl.interfaces.IWire;
import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;

public class RecipeInputDie
implements IRecipeInput {
    public final ItemStack input;
    public final int transverseSection;

    public RecipeInputDie(String string, int transverseSection) {
        this(IHLUtils.getItemStackWithTag(string, "transverseSection", transverseSection));
    }

    public RecipeInputDie(ItemStack itemStack) {
        this.input = itemStack;
        this.transverseSection = itemStack.field_77990_d.func_74762_e("transverseSection");
    }

    public boolean matches(ItemStack subject) {
        return subject.func_77973_b() == this.input.func_77973_b() && (subject.func_77960_j() == this.input.func_77960_j() || this.input.func_77960_j() == Short.MAX_VALUE);
    }

    public int getAmount() {
        return 1;
    }

    public List<ItemStack> getInputs() {
        return Arrays.asList(this.input);
    }

    public String toString() {
        ItemStack stack = this.input.func_77946_l();
        return "RInputDice<" + stack + ">";
    }

    public List<ItemStack> transformOutput(ItemStack matchedItemStack, List<ItemStack> outputs) {
        ArrayList<ItemStack> newOutputs = new ArrayList<ItemStack>();
        int misTS = matchedItemStack.field_77990_d.func_74762_e("transverseSection");
        for (ItemStack material1 : outputs) {
            if (material1.func_77973_b() instanceof IWire) {
                ItemStack material = material1.func_77946_l();
                int length = material.field_77990_d.func_74762_e("length");
                length = length * this.transverseSection / misTS;
                material.field_77990_d.func_74768_a("length", length);
                material.field_77990_d.func_74768_a("fullLength", length);
                material.field_77990_d.func_74768_a("transverseSection", misTS);
                newOutputs.add(material);
                continue;
            }
            newOutputs.add(material1);
        }
        return newOutputs;
    }

    public int transformOutput(ItemStack matchedItemStack, ItemStack material) {
        int consumeAmountMultiplier = 1;
        int misTS = matchedItemStack.field_77990_d.func_74762_e("transverseSection");
        if (misTS <= this.transverseSection) {
            int length = material.field_77990_d.func_74762_e("length");
            length = length * this.transverseSection / misTS;
            material.field_77990_d.func_74768_a("length", length);
            material.field_77990_d.func_74768_a("fullLength", length);
        } else {
            consumeAmountMultiplier = misTS / this.transverseSection + 1;
        }
        material.field_77990_d.func_74768_a("transverseSection", misTS);
        return consumeAmountMultiplier;
    }
}

