/*
 * Decompiled with CFR 0.152.
 */
package ihl.flexible_cable;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ExplosionIC2;
import ic2.core.IC2;
import ihl.flexible_cable.FlexibleCableHolderBaseTileEntity;
import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class BatterySwitchUnitTileEntity
extends FlexibleCableHolderBaseTileEntity
implements INetworkClientTileEntityEventListener,
IEnergySource {
    public short progress;
    protected short operationLength = (short)200;
    public boolean isGuiScreenOpened = false;
    protected final double energyConsume = 128.0;
    public double energy;
    public int maxStorage = 65536;
    private boolean addedToEnergyNet = false;
    public byte mode = 0;
    private Set<BatterySwitchUnitTileEntity> batteryChain = new HashSet<BatterySwitchUnitTileEntity>();
    private BatterySwitchUnitTileEntity batteryChainMaster;
    private boolean chargingMode = true;

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public ItemStack getWrenchDrop(EntityPlayer player) {
        return IHLUtils.getThisModItemStack("batterySwitchUnit");
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != (short)side;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("progress", this.progress);
        nbt.func_74780_a("energy", this.energy);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74765_d("progress");
        this.energy = nbt.func_74769_h("energy");
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        switch (event) {
            case 0: {
                this.isGuiScreenOpened = false;
            }
        }
    }

    public void updateEntityServer() {
        if (this.chargingMode && this.gridID != -1 && this.energy < (double)this.maxStorage && !this.batteryChain.isEmpty() && this.getGrid().energy > 0.0 && this.getGrid().getSinkVoltage(this) / (double)this.batteryChain.size() > 410.0) {
            this.energy += 128.0;
            this.getGrid().drawEnergy(128.0, this);
            if (this.getGrid().getSinkVoltage(this) / (double)this.batteryChain.size() > 500.0) {
                this.createChainOfExplosions();
            }
        }
        if (this.chargingMode && this.batteryChainMaster != null && this.gridID == -1 && this.batteryChainMaster.gridID != -1 && this.batteryChainMaster.energy > 0.0 && this.energy < (double)this.maxStorage && !this.batteryChainMaster.batteryChain.isEmpty() && this.batteryChainMaster.getGrid().getSinkVoltage(this.batteryChainMaster) / (double)this.batteryChainMaster.batteryChain.size() > 410.0) {
            this.energy += 128.0;
            this.batteryChainMaster.drawEnergy(128.0);
        }
        if (this.chargingMode && this.gridID != -1 && MinecraftServer.func_71276_C().func_71259_af() % 40 == 0) {
            this.checkBatteryChain();
        }
        if (this.energy >= (double)this.maxStorage) {
            this.chargingMode = false;
        }
        if (!this.chargingMode) {
            this.energy -= 0.01;
            if (this.energy < 128.0) {
                this.chargingMode = true;
            }
        }
    }

    private void createChainOfExplosions() {
        for (BatterySwitchUnitTileEntity bsu : this.batteryChain) {
            ExplosionIC2 explosion = new ExplosionIC2(bsu.field_145850_b, null, (double)bsu.field_145851_c + 0.5, (double)bsu.field_145848_d + 0.5, (double)bsu.field_145849_e + 0.5, 2.0f, 0.3f, ExplosionIC2.Type.Normal, null, 0);
            explosion.doExplosion();
        }
    }

    private boolean checkBatteryChain() {
        boolean allright = true;
        if (!this.batteryChain.isEmpty()) {
            for (BatterySwitchUnitTileEntity section : this.batteryChain) {
                if (section != null && !section.func_145837_r()) continue;
                allright = false;
            }
        } else {
            allright = false;
        }
        if (allright) {
            return true;
        }
        this.batteryChain.clear();
        boolean checking = true;
        int x = this.field_145851_c;
        int z = this.field_145849_e;
        ArrayList<Integer> xs = new ArrayList<Integer>();
        ArrayList<Integer> zs = new ArrayList<Integer>();
        xs.add(this.field_145851_c);
        zs.add(this.field_145849_e);
        this.batteryChain.add(this);
        while (checking) {
            if (xs.isEmpty() || zs.isEmpty()) {
                checking = false;
                break;
            }
            x = (Integer)xs.remove(0);
            z = (Integer)zs.remove(0);
            int[] xz = new int[]{0, 1, 0, -1, 0};
            for (int i = 0; i < xz.length - 1; ++i) {
                BatterySwitchUnitTileEntity section;
                TileEntity te = this.field_145850_b.func_147438_o(x + xz[i], this.field_145848_d, z + xz[i + 1]);
                if (!(te instanceof BatterySwitchUnitTileEntity) || !this.batteryChain.add(section = (BatterySwitchUnitTileEntity)te)) continue;
                xs.add(section.field_145851_c);
                zs.add(section.field_145849_e);
                section.batteryChain.add(this);
                section.batteryChainMaster = this;
            }
        }
        return true;
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    public double getOfferedEnergy() {
        return this.chargingMode ? 0.0 : this.energy;
    }

    public void drawEnergy(double amount) {
        this.energy -= amount;
    }

    @Override
    public double getEnergyAmountThisNodeWant() {
        return this.energy - (double)this.maxStorage;
    }

    public double drawEnergyToGrid(double amount) {
        return 0.0;
    }

    public double injectEnergy(double amount) {
        this.energy += amount;
        return 0.0;
    }

    public int getSourceTier() {
        return 4;
    }

    @Override
    public double getMaxAllowableVoltage() {
        return 64000.0;
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }

    public String func_145825_b() {
        return null;
    }

    @Override
    public void injectEnergyInThisNode(double amount, double voltage) {
        this.energy += amount;
        if (voltage / (double)this.batteryChain.size() > 500.0) {
            this.createChainOfExplosions();
        }
    }
}

