/*
 * Decompiled with CFR 0.152.
 */
package ihl.worldgen;

import ihl.utils.IHLMathUtils;
import ihl.worldgen.WorldGeneratorBase;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class WorldGeneratorSurfaceLake
extends WorldGeneratorBase {
    public WorldGeneratorSurfaceLake(Block oreIn, Block[] replaceableBlocksIn) {
        super(oreIn, replaceableBlocksIn);
    }

    @Override
    protected void replaceBlocks(World world, int[] centralPOI, int[] surroundPOI, int startX, int startZ) {
        BiomeGenBase biome = world.func_72807_a(startX, startZ);
        if (biome.field_76750_F < 1.9f || biome.field_76751_G != 0.0f) {
            return;
        }
        int x = centralPOI[0];
        int y = centralPOI[1];
        int z = centralPOI[2];
        for (int ix = x; ix < 16 && ix >= 0; ix += IHLMathUtils.sign(surroundPOI[0] - x)) {
            y += IHLMathUtils.sign(surroundPOI[1] - world.func_72940_L() / 4 - y);
            int y2 = y;
            for (int iz = z; iz < 16 && iz >= 0; iz += IHLMathUtils.sign(surroundPOI[2] - z)) {
                y2 += IHLMathUtils.sign(surroundPOI[1] - world.func_72940_L() / 4 - y2);
                int dx = ix - x;
                int dz = iz - z;
                int d = dx * dx + dz * dz;
                if (d < 64 && y2 > world.func_72940_L() * 3 / 8 && world.func_147439_a(ix + startX, 63, iz + startZ) == Blocks.field_150350_a) {
                    this.replace(world, ix + startX, 62, iz + startZ, this.ore);
                }
                if (surroundPOI[2] == z) break;
            }
            if (surroundPOI[0] == x) break;
        }
    }
}

