/*
 * Decompiled with CFR 0.152.
 */
package ihl;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputFluidContainer;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ihl.IHLMod;
import ihl.flexible_cable.IronWorkbenchTileEntity;
import ihl.recipes.IronWorkbenchRecipe;
import ihl.recipes.RecipeInputDie;
import ihl.recipes.RecipeInputWire;
import ihl.recipes.RecipeOutputItemStack;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import ihl.utils.IHLUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class IHLModConfig {
    public int explosionVectorSizeBits = 7;
    public int explosionPowerBase = 100;
    public int handpumpTier = 1;
    public int handpumpMaxCharge = 30000;
    public int handpumpOperationEUCost = 180;
    public int advancedHandpumpTier = 3;
    public int advancedHandpumpMaxCharge = 1000000;
    public int advancedHandpumpOperationEUCost = 10000;
    public int tditTier = 4;
    public int tditMaxEnergyStorage = 12000;
    public int tditEnergyConsumePerStack = 12000;
    public boolean enableHandpump = true;
    public boolean enableRubberTreeSack = true;
    public boolean enableWailers = true;
    public boolean enableTDIT = true;
    public boolean enableFlexibleCablesCrafting = true;
    public boolean enableFlexibleCablesGridPowerLossCalculations = true;
    public boolean generateApatiteOre = true;
    public boolean generateSaltpeterOre = true;
    public boolean generateLimestone = true;
    public boolean generateGypsum = true;
    public boolean generatePotassiumFeldspar = true;
    public boolean generateTrona = true;
    public boolean generateRocksalt = true;
    public boolean generateCinnabar = true;
    public boolean generateGyubnera = true;
    public boolean generateBauxite = true;
    public boolean generateChromite = true;
    public boolean generateMuscovite = true;
    public boolean generateOil = true;
    public boolean generateDatolite = true;
    public boolean generateSaltwater = true;
    public boolean generateBischofite = true;
    public int chanceOreWillNotBeGenerated = 100;
    public int mirrorReflectionRange = 14;
    public int mirrorReflectionUpdateSpeed = 128;
    public String preventMachineBlockRegistrationName = "null";
    public boolean skipRecipeLoad = false;
    public int machineryEnergyConsume = 100;

    public IHLModConfig(FMLPreInitializationEvent evt) throws IOException {
        Configuration config = new Configuration(evt.getSuggestedConfigurationFile());
        config.load();
        this.skipRecipeLoad = config.get("general", "skipRecipeLoad", this.skipRecipeLoad).getBoolean(this.skipRecipeLoad);
        this.preventMachineBlockRegistrationName = config.get("general", "preventMachineBlockRegistrationName", this.preventMachineBlockRegistrationName).getString();
        this.enableHandpump = config.get("general", "enableHandpump", this.enableHandpump).getBoolean(this.enableHandpump);
        this.enableRubberTreeSack = config.get("general", "enableRubberTreeSack", this.enableRubberTreeSack).getBoolean(this.enableRubberTreeSack);
        this.enableWailers = config.get("general", "enableWailers", this.enableWailers).getBoolean(this.enableWailers);
        this.enableTDIT = config.get("general", "enableTDIT", this.enableTDIT).getBoolean(this.enableTDIT);
        this.generateApatiteOre = config.get("general", "generateApatiteOre", this.generateApatiteOre).getBoolean(this.generateApatiteOre);
        this.generateSaltpeterOre = config.get("general", "generateSaltpeterOre", this.generateSaltpeterOre).getBoolean(this.generateSaltpeterOre);
        this.generateLimestone = config.get("general", "generateLimestone", this.generateLimestone).getBoolean(this.generateLimestone);
        this.generateGypsum = config.get("general", "generateGypsum", this.generateGypsum).getBoolean(this.generateGypsum);
        this.generatePotassiumFeldspar = config.get("general", "generatePotassiumFeldspar", this.generatePotassiumFeldspar).getBoolean(this.generatePotassiumFeldspar);
        this.generateTrona = config.get("general", "generateTrona", this.generateTrona).getBoolean(this.generateTrona);
        this.generateRocksalt = config.get("general", "generateRocksalt", this.generateRocksalt).getBoolean(this.generateRocksalt);
        this.generateCinnabar = config.get("general", "generateCinnabar", this.generateCinnabar).getBoolean(this.generateCinnabar);
        this.generateGyubnera = config.get("general", "generateGyubnera", this.generateGyubnera).getBoolean(this.generateGyubnera);
        this.generateBauxite = config.get("general", "generateBauxite", this.generateBauxite).getBoolean(this.generateBauxite);
        this.generateChromite = config.get("general", "generateChromite", this.generateChromite).getBoolean(this.generateChromite);
        this.generateMuscovite = config.get("general", "generateMuscovite", this.generateMuscovite).getBoolean(this.generateMuscovite);
        this.generateOil = config.get("general", "generateOil", this.generateOil).getBoolean(this.generateOil);
        this.generateDatolite = config.get("general", "generateDatolite", this.generateDatolite).getBoolean(this.generateDatolite);
        this.generateSaltwater = config.get("general", "generateSaltwater", this.generateSaltwater).getBoolean(this.generateSaltwater);
        this.generateBischofite = config.get("general", "generateBischofite", this.generateBischofite).getBoolean(this.generateBischofite);
        this.handpumpTier = config.get("general", "handpumpTier", this.handpumpTier).getInt();
        this.handpumpMaxCharge = config.get("general", "handpumpMaxCharge", this.handpumpMaxCharge).getInt();
        this.handpumpOperationEUCost = config.get("general", "handpumpOperationEUCost", this.handpumpOperationEUCost).getInt();
        this.advancedHandpumpTier = config.get("general", "advancedHandpumpTier", this.advancedHandpumpTier).getInt();
        this.advancedHandpumpMaxCharge = config.get("general", "advancedHandpumpMaxCharge", this.advancedHandpumpMaxCharge).getInt();
        this.advancedHandpumpOperationEUCost = config.get("general", "advancedHandpumpOperationEUCost", this.advancedHandpumpOperationEUCost).getInt();
        this.tditTier = config.get("general", "tditTier", this.tditTier).getInt();
        this.tditMaxEnergyStorage = config.get("general", "tditMaxEnergyStorage", this.tditMaxEnergyStorage).getInt();
        this.tditEnergyConsumePerStack = config.get("general", "tditEnergyConsumePerStack", this.tditEnergyConsumePerStack).getInt();
        this.enableFlexibleCablesGridPowerLossCalculations = config.get("general", "enableFlexibleCablesGridPowerLossCalculations", this.enableFlexibleCablesGridPowerLossCalculations).getBoolean(this.enableFlexibleCablesGridPowerLossCalculations);
        this.enableFlexibleCablesCrafting = config.get("general", "enableFlexibleCablesCrafting", this.enableFlexibleCablesCrafting).getBoolean(this.enableFlexibleCablesCrafting);
        this.mirrorReflectionRange = config.get("general", "mirrorReflectionRange", this.mirrorReflectionRange).getInt();
        this.mirrorReflectionUpdateSpeed = config.get("general", "mirrorReflectionUpdateSpeed", this.mirrorReflectionUpdateSpeed).getInt();
        this.explosionVectorSizeBits = config.get("general", "explosionVectorSizeBits", this.explosionVectorSizeBits).getInt();
        this.explosionPowerBase = config.get("general", "explosionPowerBase", this.explosionPowerBase).getInt();
        this.chanceOreWillNotBeGenerated = config.get("general", "chanceOreWillNotBeGenerated", this.chanceOreWillNotBeGenerated).getInt();
        this.machineryEnergyConsume = config.get("general", "machineryEnergyConsume", this.machineryEnergyConsume).getInt();
        config.save();
    }

    private void loadRecipeConfig(InputStream resourceAsStream, boolean rewriteConfig) throws IOException {
        String line;
        OutputStreamWriter osWriter = null;
        BufferedWriter writer = null;
        if (rewriteConfig) {
            osWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(IHLModConfig.getFile()), "UTF-8");
            writer = new BufferedWriter(osWriter);
        }
        InputStreamReader isReader = new InputStreamReader(resourceAsStream, "UTF-8");
        LineNumberReader reader = new LineNumberReader(isReader);
        StringBuffer currentModificator = new StringBuffer("");
        int bracketCounter = 0;
        boolean modificatorStart = false;
        while ((line = reader.readLine()) != null) {
            if (osWriter != null) {
                writer.newLine();
                writer.append(line);
            }
            if ((line = IHLUtils.trim(line)).isEmpty() || line.startsWith("//") || line.startsWith(";")) continue;
            currentModificator.append(line);
            for (int i = 0; i < line.length(); ++i) {
                char c = line.charAt(i);
                if (c == '(') {
                    ++bracketCounter;
                    modificatorStart = true;
                } else if (c == ')') {
                    --bracketCounter;
                }
                if (bracketCounter != 0 || !modificatorStart) continue;
                this.processModificator(currentModificator.toString());
                modificatorStart = false;
                currentModificator.delete(0, currentModificator.length());
            }
        }
        isReader.close();
        if (osWriter != null) {
            writer.newLine();
            writer.newLine();
            writer.append("//Available machines:");
            writer.newLine();
            writer.append("//ironworkbench");
            Iterator<Map.Entry<String, UniversalRecipeManager>> urmi = UniversalRecipeManager.machineRecipeManagers.entrySet().iterator();
            while (urmi.hasNext()) {
                writer.newLine();
                writer.append("//" + urmi.next().getKey());
            }
            writer.close();
            osWriter.close();
        }
    }

    private void processModificator(String string) {
        String sDamage;
        String action = null;
        String machineName = null;
        String recipeInput = null;
        String recipeOutput = null;
        UniversalRecipeInput uRecipeInput = null;
        UniversalRecipeOutput uRecipeOutput = null;
        String[] functionAndParameters = this.extractFunctionAndParameters(string);
        action = functionAndParameters[0].toLowerCase();
        List<String> parameters = this.splitParameters(functionAndParameters[1]);
        for (String parameter : parameters) {
            if (parameter.equalsIgnoreCase("ironworkbench")) {
                machineName = parameter;
                continue;
            }
            if (UniversalRecipeManager.machineRecipeManagers.containsKey(parameter)) {
                machineName = parameter;
                continue;
            }
            if (parameter.startsWith("recipeinput")) {
                recipeInput = parameter;
                continue;
            }
            if (!parameter.startsWith("recipeoutput")) continue;
            recipeOutput = parameter;
        }
        ArrayList<IRecipeInput> recipeInputsItems = new ArrayList<IRecipeInput>();
        ArrayList<IRecipeInput> recipeInputsTools = new ArrayList<IRecipeInput>();
        ArrayList<ItemStack> recipeInputsMachines = new ArrayList<ItemStack>();
        if (recipeInput != null) {
            ArrayList<FluidStack> recipeInputsFluids = new ArrayList<FluidStack>();
            String[] rifunctionAndParameters = this.extractFunctionAndParameters(recipeInput);
            List<String> riparameters = this.splitParameters(rifunctionAndParameters[1]);
            for (String parameter : riparameters) {
                String[] modAndItemName;
                List<String> riItemStackparameters;
                String[] riItemFunctionAndParameters = this.extractFunctionAndParameters(parameter);
                if (riItemFunctionAndParameters[0].startsWith("itemstack")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    modAndItemName = riItemStackparameters.get(0).split(":");
                    int iDamage = 0;
                    int iQuantity = Integer.parseInt(riItemStackparameters.get(1));
                    sDamage = riItemStackparameters.get(2);
                    iDamage = sDamage.startsWith("hash") ? this.extractFunctionAndParameters(sDamage)[1].hashCode() & Integer.MAX_VALUE : Integer.parseInt(sDamage);
                    recipeInputsItems.add((IRecipeInput)new RecipeInputItemStack(IHLUtils.getOtherModItemStackWithDamage(modAndItemName[0], modAndItemName[1], iDamage, iQuantity), iQuantity));
                    continue;
                }
                if (riItemFunctionAndParameters[0].startsWith("die")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    recipeInputsItems.add(new RecipeInputDie("setOfDies1_5sqmm", Integer.parseInt(riItemStackparameters.get(0))));
                    continue;
                }
                if (riItemFunctionAndParameters[0].startsWith("fiber")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    ItemStack stack = IHLUtils.getThisModWireItemStackWithLength(riItemStackparameters.get(0), Integer.parseInt(riItemStackparameters.get(1)));
                    recipeInputsItems.add(new RecipeInputWire(stack, Integer.parseInt(riItemStackparameters.get(1))));
                    continue;
                }
                if (riItemFunctionAndParameters[0].startsWith("wire")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    recipeInputsItems.add(new RecipeInputWire(riItemStackparameters.get(0), Integer.parseInt(riItemStackparameters.get(1)), Integer.parseInt(riItemStackparameters.get(2))));
                    continue;
                }
                if (riItemFunctionAndParameters[0].startsWith("cable")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    recipeInputsItems.add(new RecipeInputWire(riItemStackparameters.get(0), Integer.parseInt(riItemStackparameters.get(1)), Integer.parseInt(riItemStackparameters.get(2)), riItemStackparameters.get(3), Integer.parseInt(riItemStackparameters.get(4)), Integer.parseInt(riItemStackparameters.get(5))));
                    continue;
                }
                if (riItemFunctionAndParameters[0].startsWith("oredict")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    recipeInputsItems.add((IRecipeInput)new RecipeInputOreDict(riItemStackparameters.get(0), Integer.parseInt(riItemStackparameters.get(1))));
                    continue;
                }
                if (riItemFunctionAndParameters[0].startsWith("fluidcontainer")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    recipeInputsItems.add((IRecipeInput)new RecipeInputFluidContainer(FluidRegistry.getFluid((String)riItemStackparameters.get(0)), Integer.parseInt(riItemStackparameters.get(1))));
                    continue;
                }
                if (riItemFunctionAndParameters[0].startsWith("toolitemstack")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    modAndItemName = riItemStackparameters.get(0).split(":");
                    ItemStack stack = IHLUtils.getOtherModItemStackWithDamage(modAndItemName[0], modAndItemName[1], Integer.parseInt(riItemStackparameters.get(2)), Integer.parseInt(riItemStackparameters.get(1)));
                    stack.field_77990_d = new NBTTagCompound();
                    NBTTagCompound gtTagCompound = new NBTTagCompound();
                    gtTagCompound.func_74768_a("Damage", 0);
                    gtTagCompound.func_74768_a("MaxDamage", 2000);
                    stack.field_77990_d.func_74782_a("GT.ToolStats", (NBTBase)gtTagCompound);
                    recipeInputsTools.add((IRecipeInput)new RecipeInputItemStack(stack, stack.field_77994_a));
                    continue;
                }
                if (riItemFunctionAndParameters[0].startsWith("tooloredict")) {
                    recipeInputsTools.add((IRecipeInput)new RecipeInputOreDict(this.splitParameters(riItemFunctionAndParameters[1]).get(0)));
                    continue;
                }
                if (riItemFunctionAndParameters[0].startsWith("machine")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    modAndItemName = riItemStackparameters.get(0).split(":");
                    recipeInputsMachines.add(IHLUtils.getThisModItemStack(modAndItemName[1]));
                    continue;
                }
                if (!riItemFunctionAndParameters[0].startsWith("fluidstack")) continue;
                List<String> riFluidStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                recipeInputsFluids.add(IHLUtils.getFluidStackWithSize(riFluidStackparameters.get(0), Integer.parseInt(riFluidStackparameters.get(1))));
            }
            uRecipeInput = new UniversalRecipeInput(recipeInputsFluids.toArray(), recipeInputsItems.toArray());
        }
        ArrayList<ItemStack> recipeOutputsItems = new ArrayList<ItemStack>();
        ArrayList<RecipeOutputItemStack> recipeOutputsRecipeOut = new ArrayList<RecipeOutputItemStack>();
        if (recipeOutput != null) {
            ArrayList<FluidStack> recipeOutputsFluids = new ArrayList<FluidStack>();
            String[] rifunctionAndParameters = this.extractFunctionAndParameters(recipeOutput);
            List<String> riparameters = this.splitParameters(rifunctionAndParameters[1]);
            for (String parameter : riparameters) {
                List<String> riItemStackparameters;
                String[] riItemFunctionAndParameters = this.extractFunctionAndParameters(parameter);
                if (riItemFunctionAndParameters[0].startsWith("itemstack")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    String[] modAndItemName = riItemStackparameters.get(0).split(":");
                    sDamage = riItemStackparameters.get(2);
                    int iDamage = 0;
                    iDamage = sDamage.startsWith("hash") ? this.extractFunctionAndParameters(sDamage)[1].hashCode() & Integer.MAX_VALUE : Integer.parseInt(sDamage);
                    ItemStack stack = IHLUtils.getOtherModItemStackWithDamage(modAndItemName[0], modAndItemName[1], iDamage, Integer.parseInt(riItemStackparameters.get(1)));
                    if (stack == null) {
                        throw new IllegalArgumentException("Item not found: " + parameter);
                    }
                    if (riItemStackparameters.size() > 3) {
                        stack.field_77990_d = new NBTTagCompound();
                        String[] fp = this.extractFunctionAndParameters(riItemStackparameters.get(3));
                        Iterator<String> iparams2 = this.splitParameters(fp[1]).iterator();
                        while (iparams2.hasNext()) {
                            this.decodeNBT(iparams2.next(), stack.field_77990_d);
                        }
                    }
                    recipeOutputsItems.add(stack);
                    recipeOutputsRecipeOut.add(new RecipeOutputItemStack(stack.func_77946_l(), Float.parseFloat(riItemStackparameters.get(1))));
                    continue;
                }
                if (riItemFunctionAndParameters[0].startsWith("fiber")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    recipeOutputsItems.add(IHLUtils.getThisModWireItemStackWithLength(riItemStackparameters.get(0), Integer.parseInt(riItemStackparameters.get(1))));
                    recipeOutputsRecipeOut.add(new RecipeOutputItemStack(IHLUtils.getThisModWireItemStackWithLength(riItemStackparameters.get(0), Integer.parseInt(riItemStackparameters.get(1))), 1.0f));
                    continue;
                }
                if (riItemFunctionAndParameters[0].startsWith("wire")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    recipeOutputsItems.add(IHLUtils.getUninsulatedWire(riItemStackparameters.get(0), Integer.parseInt(riItemStackparameters.get(1)), Integer.parseInt(riItemStackparameters.get(2))));
                    recipeOutputsRecipeOut.add(new RecipeOutputItemStack(IHLUtils.getUninsulatedWire(riItemStackparameters.get(0), Integer.parseInt(riItemStackparameters.get(1)), Integer.parseInt(riItemStackparameters.get(2))), 1.0f));
                    continue;
                }
                if (riItemFunctionAndParameters[0].startsWith("cable")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    recipeOutputsItems.add(IHLUtils.getInsulatedWire(riItemStackparameters.get(0), Integer.parseInt(riItemStackparameters.get(1)), Integer.parseInt(riItemStackparameters.get(2)), riItemStackparameters.get(3), Integer.parseInt(riItemStackparameters.get(4))));
                    recipeOutputsRecipeOut.add(new RecipeOutputItemStack(IHLUtils.getInsulatedWire(riItemStackparameters.get(0), Integer.parseInt(riItemStackparameters.get(1)), Integer.parseInt(riItemStackparameters.get(2)), riItemStackparameters.get(3), Integer.parseInt(riItemStackparameters.get(4))), 1.0f));
                    continue;
                }
                if (!riItemFunctionAndParameters[0].startsWith("fluidstack")) continue;
                List<String> riFluidStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                recipeOutputsFluids.add(IHLUtils.getFluidStackWithSize(riFluidStackparameters.get(0), Integer.parseInt(riFluidStackparameters.get(1))));
            }
            uRecipeOutput = new UniversalRecipeOutput(recipeOutputsFluids, recipeOutputsRecipeOut, 200);
        }
        if (action.equalsIgnoreCase("addrecipe")) {
            if (machineName.equalsIgnoreCase("ironworkbench")) {
                IronWorkbenchTileEntity.addRecipe(new IronWorkbenchRecipe(recipeInputsTools, recipeInputsItems, recipeOutputsItems, recipeInputsMachines));
            } else {
                UniversalRecipeManager.machineRecipeManagers.get(machineName).addRecipe(uRecipeInput, uRecipeOutput);
            }
        } else if (action.equalsIgnoreCase("addcasting")) {
            IHLMod.moltenAmounts.put(parameters.get(0), Integer.parseInt(parameters.get(1)));
        } else if (action.equalsIgnoreCase("removerecipe")) {
            if (machineName.equalsIgnoreCase("ironworkbench")) {
                if (recipeInputsTools.isEmpty() && recipeInputsItems.isEmpty() && recipeInputsMachines.isEmpty()) {
                    IronWorkbenchTileEntity.removeRecipeByOutput(recipeOutputsItems);
                } else {
                    IronWorkbenchTileEntity.removeRecipeByInput(recipeInputsTools, recipeInputsItems, recipeInputsMachines);
                }
            } else if (uRecipeInput == null) {
                UniversalRecipeManager.machineRecipeManagers.get(machineName).removeRecipeByOutput(uRecipeOutput);
            } else {
                UniversalRecipeManager.machineRecipeManagers.get(machineName).removeRecipeByInput(uRecipeInput);
            }
        }
    }

    private void decodeNBT(String string, NBTTagCompound out) {
        String[] fp = this.extractFunctionAndParameters(string);
        List<String> params = this.splitParameters(fp[1]);
        if (fp[0].equalsIgnoreCase("string")) {
            out.func_74778_a(params.get(0), params.get(1));
        } else if (fp[0].equalsIgnoreCase("boolean")) {
            out.func_74757_a(params.get(0), Boolean.getBoolean(params.get(1)));
        } else if (fp[0].equalsIgnoreCase("float")) {
            out.func_74776_a(params.get(0), Float.parseFloat(params.get(1)));
        } else if (fp[0].equalsIgnoreCase("double")) {
            out.func_74780_a(params.get(0), Double.parseDouble(params.get(1)));
        } else if (fp[0].equalsIgnoreCase("integer")) {
            out.func_74768_a(params.get(0), Integer.parseInt(params.get(1)));
        } else if (fp[0].equalsIgnoreCase("long")) {
            out.func_74772_a(params.get(0), Long.parseLong(params.get(1)));
        } else if (fp[0].equalsIgnoreCase("nbt")) {
            NBTTagCompound out2 = new NBTTagCompound();
            for (int i = 1; i < params.size(); ++i) {
                this.decodeNBT(params.get(i), out2);
            }
            out.func_74782_a(params.get(0), (NBTBase)out2);
        }
    }

    private List<String> splitParameters(String string) {
        ArrayList<String> result = new ArrayList<String>();
        int bracketCounter = 0;
        boolean modificatorStart = false;
        StringBuffer currentModificator = new StringBuffer("");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ',') {
                if (!modificatorStart) {
                    result.add(currentModificator.toString());
                    currentModificator.delete(0, currentModificator.length());
                }
            } else if (c == '(') {
                ++bracketCounter;
                modificatorStart = true;
            } else if (c == ')') {
                --bracketCounter;
            }
            if (bracketCounter == 0 && modificatorStart) {
                modificatorStart = false;
            }
            if (c == ',' && !modificatorStart) continue;
            currentModificator.append(c);
        }
        result.add(currentModificator.toString());
        return result;
    }

    private String[] extractFunctionAndParameters(String string) {
        int bracketCounter = 0;
        boolean modificatorStart = false;
        String function = null;
        String parameters = null;
        StringBuffer currentModificator = new StringBuffer("");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '(') {
                ++bracketCounter;
                if (!modificatorStart) {
                    function = currentModificator.toString();
                    currentModificator.delete(0, currentModificator.length());
                    modificatorStart = true;
                }
            } else if (c == ')') {
                --bracketCounter;
            }
            if (bracketCounter == 0 && modificatorStart) {
                parameters = currentModificator.substring(1, currentModificator.length());
                break;
            }
            currentModificator.append(c);
        }
        return new String[]{function, parameters};
    }

    private void loadRecipeConfig(File configFile) throws IOException {
        FileInputStream is = new FileInputStream(configFile);
        this.loadRecipeConfig(is, false);
    }

    private static File getFile() {
        File folder = new File(IHLMod.proxy.getMinecraftDir(), "config");
        folder.mkdirs();
        return new File(folder, "ihl-recipe.cfg");
    }

    public void loadRecipeModificators() throws IOException {
        File configFile = IHLModConfig.getFile();
        if (configFile.exists()) {
            this.loadRecipeConfig(configFile);
        } else {
            InputStream inputStream = IHLMod.class.getResourceAsStream("/assets/ihl/config/ihl-recipe.cfg");
            this.loadRecipeConfig(inputStream, true);
        }
    }
}

