/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.chemistry;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IItemHudInfo;
import ihl.IHLCreativeTab;
import ihl.utils.IHLUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class BatteryItem
extends Item
implements IElectricItem,
IItemHudInfo {
    public int maxCharge = 65536;
    public int transferLimit = 4096;
    public int tier = 4;
    private static Map<Integer, IIcon> iconMap = new HashMap<Integer, IIcon>();
    private static Map<Integer, String> nameMap = new HashMap<Integer, String>();
    private static Map<Integer, String> descriptionMap = new HashMap<Integer, String>();

    public BatteryItem() {
        this.func_77656_e(27);
        this.func_77637_a(IHLCreativeTab.tab);
        this.field_77777_bU = 1;
        this.canRepair = false;
        this.func_77655_b("battery");
    }

    public static void init() {
        BatteryItem item = new BatteryItem();
        GameRegistry.registerItem((Item)item, (String)item.func_77658_a());
        Type[] var1 = Type.values();
        for (int i = 0; i < var1.length; ++i) {
            nameMap.put(var1[i].damage, var1[i].unLocalizedName);
            IHLUtils.registerLocally(var1[i].unLocalizedName, new ItemStack((Item)item, 1, var1[i].damage));
            if (var1[i].description == null) continue;
            descriptionMap.put(var1[i].damage, var1[i].description);
        }
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public List<String> getHudInfo(ItemStack itemStack) {
        LinkedList<String> info = new LinkedList<String>();
        info.add(ElectricItem.manager.getToolTip(itemStack));
        return info;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        Type[] var1 = Type.values();
        for (int i = 0; i < var1.length; ++i) {
            iconMap.put(var1[i].damage, register.func_94245_a("ihl:" + var1[i].textureName));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int i) {
        return iconMap.get(0);
    }

    public String func_77667_c(ItemStack stack) {
        return nameMap.get(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        ItemStack charged;
        ItemStack itemStack = new ItemStack((Item)this, 1);
        if (this.getChargedItem(itemStack) == this) {
            charged = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(charged, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, false);
            itemList.add(charged);
        }
        if (this.getEmptyItem(itemStack) == this) {
            charged = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(charged, 0.0, Integer.MAX_VALUE, true, false);
            itemList.add(charged);
        }
    }

    public static ItemStack getFullyChargedItemStack(String name) {
        ItemStack stack = IHLUtils.getThisModItemStack(name);
        ElectricItem.manager.charge(stack, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, false);
        return stack;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean flag) {
        if (descriptionMap.containsKey(0)) {
            info.add(descriptionMap.get(0));
        }
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return ((double)this.maxCharge - ElectricItem.manager.getCharge(stack)) / (double)this.maxCharge;
    }

    public static ItemStack getFullyChargedItemStackWithSize(String name, int stackSize1) {
        ItemStack stack = BatteryItem.getFullyChargedItemStack(name);
        stack.field_77994_a = stackSize1;
        return stack;
    }

    public static enum Type {
        LeadAcidBattery(0, "leadAcidBattery", "Pb/Pb2PbO4 + H2SO4");

        public int damage;
        public String unLocalizedName;
        public String oreRegistryName;
        public String description;
        public String textureName;

        private Type(int damage1, String unlocalizedName1, String description1) {
            this.damage = damage1;
            this.oreRegistryName = this.unLocalizedName = unlocalizedName1;
            this.textureName = this.unLocalizedName;
            this.description = description1;
        }
    }
}

