/*
 * Decompiled with CFR 0.152.
 */
package ihl.enviroment;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ihl.ClientProxy;
import ihl.IHLMod;
import java.util.BitSet;

@SideOnly(value=Side.CLIENT)
public class LightSource {
    private final int centerX;
    private final int centerY;
    private final int centerZ;
    public int fromX;
    public int fromY;
    public int fromZ;
    public int toX;
    public int toY;
    public int toZ;
    private final int red;
    private final int green;
    private final int blue;
    private final int power;
    public final BitSet illuminatedBlocks = new BitSet();

    public LightSource(int centerX1, int centerY1, int centerZ1, int red1, int green1, int blue1, int power1) {
        this.centerX = centerX1;
        this.centerY = centerY1;
        this.centerZ = centerZ1;
        this.red = red1;
        this.green = green1;
        this.blue = blue1;
        this.power = power1;
    }

    public void setBorders(int fromX1, int fromY1, int fromZ1, int toX1, int toY1, int toZ1) {
        this.fromX = fromX1;
        this.fromY = fromY1;
        this.fromZ = fromZ1;
        this.toX = toX1;
        this.toY = toY1;
        this.toZ = toZ1;
    }

    public boolean isBlockIlluminated(int x, int y, int z) {
        if (x < this.fromX || x > this.toX || y < this.fromY || y > this.toY || z < this.fromZ || z > this.toZ) {
            return false;
        }
        int rx = x - this.centerX;
        int ry = y - this.centerY;
        int rz = z - this.centerZ;
        int l = ((ClientProxy)IHLMod.proxy).getLightHandler().encodeXYZ(rx, ry, rz);
        return this.illuminatedBlocks.get(l);
    }

    public int[] getLightValue(int x, int y, int z, int[] normal) {
        int dx = this.centerX - x;
        int dy = this.centerY - y;
        int dz = this.centerZ - z;
        int d = dx * dx + dy * dy + dz * dz;
        dx = normal[0] * dx;
        dy = normal[1] * dy;
        dz = normal[2] * dz;
        dx = dx > 0 ? (dx << 16) / d : 0;
        dy = dy > 0 ? (dy << 16) / d : 0;
        dz = dz > 0 ? (dz << 16) / d : 0;
        int brightness = Math.min(this.power * (dx + dy + dz) >> 16, 16);
        return new int[]{brightness, this.red, this.blue, this.green};
    }
}

