/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.chemistry;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ihl.IHLCreativeTab;
import ihl.processing.chemistry.ElectricEvaporatorTileEntity;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ElectricEvaporatorBlock
extends Block
implements ITileEntityProvider {
    IIcon textureFrontActive;
    IIcon textureSide;
    IIcon textureBottom;
    IIcon textureTop;

    public ElectricEvaporatorBlock(Material material) {
        super(material);
        this.func_149647_a(IHLCreativeTab.tab);
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return new ItemStack(Blocks.field_150460_al, 1).func_77973_b();
    }

    public void func_149690_a(World world, int x, int y, int z, int meta, float chance, int flag) {
        ItemStack result = new ItemStack(Blocks.field_150460_al, 1);
        this.func_149642_a(world, x, y, z, result);
    }

    public TileEntity func_149915_a(World world, int var2) {
        return new ElectricEvaporatorTileEntity();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("ihl:electricEvaporatorFront");
        this.textureFrontActive = par1IconRegister.func_94245_a("ihl:electricEvaporatorFrontActive");
        this.textureSide = par1IconRegister.func_94245_a("ihl:electricEvaporatorSide");
        this.textureTop = par1IconRegister.func_94245_a("ihl:electricEvaporatorTop");
        this.textureBottom = par1IconRegister.func_94245_a("ihl:electricEvaporatorBottom");
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int i, float pos_x, float pos_y, float pos_z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ElectricEvaporatorTileEntity) {
            ElectricEvaporatorTileEntity bte = (ElectricEvaporatorTileEntity)te;
            if (bte == null || entityPlayer.func_70093_af()) {
                return false;
            }
            return bte.getGui(entityPlayer);
        }
        return false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        int var7 = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        TileEntity t = world.func_147438_o(x, y, z);
        if (t != null && t instanceof ElectricEvaporatorTileEntity) {
            ElectricEvaporatorTileEntity te = (ElectricEvaporatorTileEntity)t;
            if (player.func_70093_af()) {
                switch (var7) {
                    case 0: {
                        te.setFacing((short)3);
                        break;
                    }
                    case 1: {
                        te.setFacing((short)4);
                        break;
                    }
                    case 2: {
                        te.setFacing((short)2);
                        break;
                    }
                    case 3: {
                        te.setFacing((short)5);
                        break;
                    }
                }
            } else {
                switch (var7) {
                    case 0: {
                        te.setFacing((short)2);
                        break;
                    }
                    case 1: {
                        te.setFacing((short)5);
                        break;
                    }
                    case 2: {
                        te.setFacing((short)3);
                        break;
                    }
                    case 3: {
                        te.setFacing((short)4);
                        break;
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        IIcon faceIcon = this.field_149761_L;
        int facing = 3;
        int[] mask = new int[]{0, 1, 2, 3, 4, 5, 1, 0, 3, 2, 4, 5, 2, 3, 0, 1, 4, 5, 2, 3, 1, 0, 4, 5, 2, 3, 5, 4, 0, 1, 2, 3, 4, 5, 1, 0};
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null) {
            ElectricEvaporatorTileEntity tebh = (ElectricEvaporatorTileEntity)te;
            facing = tebh.getFacing();
            if (tebh.getActive()) {
                faceIcon = this.textureFrontActive;
            }
        }
        switch (mask[facing * 6 + side]) {
            case 0: {
                return faceIcon;
            }
            case 1: {
                return this.textureSide;
            }
            case 2: {
                return this.textureBottom;
            }
            case 3: {
                return this.textureTop;
            }
            case 4: {
                return this.textureSide;
            }
            case 5: {
                return this.textureSide;
            }
        }
        return this.textureSide;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        switch (side) {
            case 0: {
                return this.textureBottom;
            }
            case 1: {
                return this.textureTop;
            }
            case 2: {
                return this.textureSide;
            }
            case 3: {
                return this.field_149761_L;
            }
            case 4: {
                return this.textureSide;
            }
            case 5: {
                return this.textureSide;
            }
        }
        return this.textureSide;
    }

    public void func_149734_b(World world, int x, int y, int z, Random random) {
        ElectricEvaporatorTileEntity ete;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ElectricEvaporatorTileEntity && (ete = (ElectricEvaporatorTileEntity)te).getActive()) {
            world.func_72869_a("snowshovel", (double)x + 0.2, (double)y + 1.2, (double)z + 0.2, 0.0, 0.05, 0.0);
        }
    }
}

