/*
 * Decompiled with CFR 0.152.
 */
package ihl.recipes;

import ihl.recipes.RecipeOutputItemStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class UniversalRecipeOutput {
    private final List<FluidStack> fluidOutputs = new ArrayList<FluidStack>();
    private final List<RecipeOutputItemStack> itemOutputs = new ArrayList<RecipeOutputItemStack>();
    private final int time;
    public final boolean specialConditions;

    public UniversalRecipeOutput(FluidStack[] fluidOutputs1, Object[] itemOutputs1, int time1) {
        this(fluidOutputs1, itemOutputs1, time1, false);
    }

    public UniversalRecipeOutput(FluidStack[] fluidStacks, Object[] recipeOutputItemStacks, int time1, boolean specialConditions1) {
        if (fluidStacks != null) {
            for (FluidStack fluidStack : fluidStacks) {
                if (fluidStack == null) {
                    throw new NullPointerException("Recipe cannot contain null elements!");
                }
                this.fluidOutputs.add(fluidStack);
            }
        }
        if (recipeOutputItemStacks != null) {
            for (Object object : recipeOutputItemStacks) {
                if (object == null) {
                    throw new NullPointerException("Recipe output cannot be null!");
                }
                if (object instanceof ItemStack) {
                    this.itemOutputs.add(new RecipeOutputItemStack((ItemStack)object));
                    continue;
                }
                this.itemOutputs.add((RecipeOutputItemStack)object);
            }
        }
        this.specialConditions = specialConditions1;
        this.time = time1;
    }

    public UniversalRecipeOutput(List<FluidStack> recipeOutputsFluids, List<RecipeOutputItemStack> recipeOutputsRecipeOut, int time1) {
        this.fluidOutputs.addAll(recipeOutputsFluids);
        this.itemOutputs.addAll(recipeOutputsRecipeOut);
        this.time = time1;
        this.specialConditions = false;
    }

    public boolean matches(List<FluidStack> fluidOutputs1, List<ItemStack> itemOutputs1) {
        if (this.fluidOutputs.size() != fluidOutputs1.size() || this.itemOutputs.size() != this.itemOutputs.size()) {
            return false;
        }
        Iterator<FluidStack> fi1 = fluidOutputs1.iterator();
        Iterator<ItemStack> ii1 = itemOutputs1.iterator();
        Iterator<FluidStack> fi = this.fluidOutputs.iterator();
        Iterator<RecipeOutputItemStack> ii = this.itemOutputs.iterator();
        while (fi.hasNext()) {
            FluidStack fs = fi.next();
            FluidStack fs1 = fi1.next();
            if (fs.getFluid() == fs1.getFluid()) continue;
            return false;
        }
        while (ii.hasNext()) {
            ItemStack is1;
            RecipeOutputItemStack is = ii.next();
            if (is.matches(is1 = ii1.next())) continue;
            return false;
        }
        return true;
    }

    public List<FluidStack> getFluidOutputs() {
        return this.fluidOutputs;
    }

    public List<RecipeOutputItemStack> getItemOutputs() {
        return this.itemOutputs;
    }

    public UniversalRecipeOutput copyWithMultiplier(int mulipier) {
        int i;
        FluidStack[] fluidStacks = null;
        RecipeOutputItemStack[] itemStacks = null;
        if (this.fluidOutputs != null && !this.fluidOutputs.isEmpty()) {
            fluidStacks = new FluidStack[this.fluidOutputs.size()];
            for (i = 0; i < this.fluidOutputs.size(); ++i) {
                FluidStack fs = this.fluidOutputs.get(i);
                FluidStack newFs = fs.copy();
                newFs.amount *= mulipier;
                fluidStacks[i] = fs;
            }
        }
        if (this.itemOutputs != null && !this.itemOutputs.isEmpty()) {
            itemStacks = new RecipeOutputItemStack[this.itemOutputs.size()];
            for (i = 0; i < this.itemOutputs.size(); ++i) {
                RecipeOutputItemStack newIs;
                RecipeOutputItemStack is = this.itemOutputs.get(i);
                itemStacks[i] = newIs = is.copy(mulipier);
            }
        }
        return new UniversalRecipeOutput(fluidStacks, itemStacks, this.getTime(), false);
    }

    public int getTime() {
        return this.time;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        for (FluidStack fluid : this.fluidOutputs) {
            out.append(fluid.getLocalizedName() + ": " + fluid.amount + "/n");
        }
        for (RecipeOutputItemStack stack : this.itemOutputs) {
            out.append(stack.itemStack.func_82833_r() + ": " + stack.quantity + "/n");
        }
        return out.toString();
    }
}

