/*
 * Decompiled with CFR 0.152.
 */
package ihl.handpump;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IBoxable;
import ic2.api.item.IC2Items;
import ic2.api.item.IElectricItem;
import ic2.api.item.IItemHudInfo;
import ic2.core.item.resources.ItemCell;
import ic2.core.util.LiquidUtil;
import ihl.IHLCreativeTab;
import ihl.IHLMod;
import ihl.handpump.BlockWithCoordinates;
import ihl.utils.IHLUtils;
import ihl.worldgen.ores.IHLFluid;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class IHLHandPump
extends Item
implements IElectricItem,
IBoxable,
IItemHudInfo {
    protected int tier = 1;
    protected int maxCharge = 30000;
    protected int operationEUCost = 600;
    protected int transferLimit = 2000;

    public IHLHandPump() {
        this.func_77656_e(27);
        this.maxCharge = IHLMod.config.handpumpMaxCharge;
        this.operationEUCost = IHLMod.config.handpumpOperationEUCost;
        this.tier = IHLMod.config.handpumpTier;
        this.func_77637_a(IHLCreativeTab.tab);
        this.field_77777_bU = 1;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        MovingObjectPosition movingobjectposition = IHLUtils.returnMOPFromPlayer(entityPlayer, world);
        if (movingobjectposition != null) {
            int x = movingobjectposition.field_72311_b;
            int y = movingobjectposition.field_72312_c;
            int z = movingobjectposition.field_72309_d;
            Block block = world.func_147439_a(x, y, z);
            if (!block.func_149688_o().func_76224_d() && !(block = world.func_147439_a(x, ++y, z)).func_149688_o().func_76224_d()) {
                return itemStack;
            }
            if (world.field_72995_K && ElectricItem.manager.use(itemStack, (double)this.operationEUCost, (EntityLivingBase)entityPlayer)) {
                entityPlayer.func_85030_a("ihl:handpumpOne", (float)(Math.random() * 0.2 + 0.6), (float)(Math.random() * 0.1 + 0.9));
                return itemStack;
            }
            BlockWithCoordinates blockXYZ = this.searchSource(world, x, y, z);
            if (blockXYZ == null) {
                return itemStack;
            }
            block = blockXYZ.block;
            FluidStack fluid1 = null;
            if (block instanceof BlockFluidBase) {
                fluid1 = ((BlockFluidBase)block).drain(world, blockXYZ.x, blockXYZ.y, blockXYZ.z, false);
            } else if (blockXYZ.isWaterBlock()) {
                fluid1 = new FluidStack(FluidRegistry.WATER, 1000);
            } else if (blockXYZ.isLavaBlock()) {
                fluid1 = new FluidStack(FluidRegistry.LAVA, 1000);
            }
            int amount2 = 0;
            ItemStack stack = this.getItemStackContains(fluid1, entityPlayer);
            if (stack != null && fluid1 != null) {
                amount2 = LiquidUtil.fillContainerStack((ItemStack)stack, (EntityPlayer)entityPlayer, (FluidStack)fluid1, (boolean)true);
            }
            if (amount2 > 0) {
                if (ElectricItem.manager.use(itemStack, (double)this.operationEUCost, (EntityLivingBase)entityPlayer) && blockXYZ.setMetadataOrDestroyBlock(world, blockXYZ.meta + 1, 7)) {
                    ElectricItem.manager.discharge(itemStack, (double)this.operationEUCost, 1, false, false, false);
                    LiquidUtil.fillContainerStack((ItemStack)stack, (EntityPlayer)entityPlayer, (FluidStack)fluid1, (boolean)false);
                    entityPlayer.field_71069_bz.func_75142_b();
                }
                return itemStack;
            }
            if (entityPlayer.field_71071_by.func_70431_c(IC2Items.getItem((String)"cell")) && ElectricItem.manager.use(itemStack, (double)this.operationEUCost, (EntityLivingBase)entityPlayer) && blockXYZ.setMetadataOrDestroyBlock(world, blockXYZ.meta + 1, 7)) {
                ElectricItem.manager.discharge(itemStack, (double)this.operationEUCost, 1, false, false, false);
                this.fillFluidCell(fluid1, entityPlayer);
                entityPlayer.field_71069_bz.func_75142_b();
                return itemStack;
            }
        }
        return itemStack;
    }

    protected ItemStack getItemStackContains(FluidStack fluidStack, EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (player.field_71071_by.func_70301_a(i) == null || !(player.field_71071_by.func_70301_a(i).func_77973_b() instanceof IFluidContainerItem) || LiquidUtil.fillContainerStack((ItemStack)player.field_71071_by.func_70301_a(i), (EntityPlayer)player, (FluidStack)fluidStack, (boolean)true) <= 0) continue;
            return player.field_71071_by.func_70301_a(i);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("ihl:itemElectricHandpump");
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public List<String> getHudInfo(ItemStack itemStack) {
        LinkedList<String> info = new LinkedList<String>();
        info.add(ElectricItem.manager.getToolTip(itemStack));
        info.add("Power Tier: " + this.tier);
        return info;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean b) {
        info.add("PowerTier: " + this.tier);
    }

    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List itemList) {
        itemList.add(this.getItemStack(this.maxCharge));
        itemList.add(this.getItemStack(0));
    }

    public ItemStack getItemStack(int charge) {
        ItemStack ret = new ItemStack((Item)this);
        ElectricItem.manager.charge(ret, (double)charge, this.maxCharge, true, false);
        return ret;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return ((double)this.maxCharge - ElectricItem.manager.getCharge(stack)) / (double)this.maxCharge;
    }

    protected void fillFluidCell(FluidStack fluid1, EntityPlayer player) {
        ItemStack cell = IHLFluid.getCell(fluid1.getFluid().getName());
        if (cell == null) {
            return;
        }
        ItemStack[] inv = player.field_71071_by.field_70462_a;
        for (int i = 0; i <= 35; ++i) {
            if (inv[i] == null || !(inv[i].func_77973_b() instanceof ItemCell) || inv[i].func_77960_j() != 0 || !IHLUtils.addItemStackToInventory(player, cell)) continue;
            if (inv[i].field_77994_a <= 1) {
                ItemStack sourceItemStack = inv[i].func_77946_l();
                sourceItemStack.field_77994_a = player.field_71071_by.func_146027_a(sourceItemStack.func_77973_b(), 0) - 1;
                if (sourceItemStack.field_77994_a > 0) {
                    player.field_71071_by.func_70441_a(sourceItemStack);
                }
            } else {
                --inv[i].field_77994_a;
            }
            return;
        }
    }

    protected BlockWithCoordinates searchSource(World world, int startx, int starty, int startz) {
        int currentFlowDecay = this.getFlowDecay(world, startx, starty, startz);
        for (int i = 0; i < 256; ++i) {
            if (this.getFlowDecay(world, startx, starty + 1, startz) >= 0) {
                currentFlowDecay = this.getFlowDecay(world, startx, ++starty, startz);
                continue;
            }
            if (this.getFlowDecay(world, startx + 1, starty + 1, startz) >= 0) {
                currentFlowDecay = this.getFlowDecay(world, ++startx, ++starty, startz);
                continue;
            }
            if (this.getFlowDecay(world, startx - 1, starty + 1, startz) >= 0) {
                currentFlowDecay = this.getFlowDecay(world, --startx, ++starty, startz);
                continue;
            }
            if (this.getFlowDecay(world, startx, starty + 1, startz + 1) >= 0) {
                currentFlowDecay = this.getFlowDecay(world, startx, ++starty, ++startz);
                continue;
            }
            if (this.getFlowDecay(world, startx, starty + 1, startz - 1) >= 0) {
                currentFlowDecay = this.getFlowDecay(world, startx, ++starty, --startz);
                continue;
            }
            if (this.getFlowDecay(world, startx - 1, starty, startz) < currentFlowDecay && this.getFlowDecay(world, startx - 1, starty, startz) != -1) {
                currentFlowDecay = this.getFlowDecay(world, --startx, starty, startz);
                continue;
            }
            if (this.getFlowDecay(world, startx, starty, startz + 1) < currentFlowDecay && this.getFlowDecay(world, startx, starty, startz + 1) != -1) {
                currentFlowDecay = this.getFlowDecay(world, startx, starty, ++startz);
                continue;
            }
            if (this.getFlowDecay(world, startx, starty, startz - 1) < currentFlowDecay && this.getFlowDecay(world, startx, starty, startz - 1) != -1) {
                currentFlowDecay = this.getFlowDecay(world, startx, starty, --startz);
                continue;
            }
            if (this.getFlowDecay(world, startx + 1, starty, startz) >= currentFlowDecay || this.getFlowDecay(world, startx + 1, starty, startz) == -1) break;
            currentFlowDecay = this.getFlowDecay(world, ++startx, starty, startz);
        }
        if (currentFlowDecay == 0) {
            Block block = world.func_147439_a(startx, starty, startz);
            return new BlockWithCoordinates(block, startx, starty, startz, 0);
        }
        if (currentFlowDecay < 7) {
            world.func_72921_c(startx, starty, startz, currentFlowDecay + 1, 3);
            return null;
        }
        return null;
    }

    protected int getFlowDecay(World par1World, int par2, int par3, int par4) {
        return par1World.func_147439_a(par2, par3, par4).func_149688_o().func_76224_d() ? par1World.func_72805_g(par2, par3, par4) : -1;
    }
}

