/*
 * Decompiled with CFR 0.152.
 */
package ihl.explosion;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import ihl.explosion.PileTileEntity;
import ihl.explosion.PileTileEntityRender;
import ihl.utils.IHLMathUtils;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class PileBlockRender
implements ISimpleBlockRenderingHandler {
    public static int renderId;
    public final PileTileEntityRender pileTileEntityRender;

    public PileBlockRender() {
        renderId = RenderingRegistry.getNextAvailableRenderId();
        this.pileTileEntityRender = new PileTileEntityRender(this);
    }

    public int getRenderId() {
        return renderId;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderblocks) {
        Tessellator tessellator = Tessellator.field_78398_a;
        block.func_149683_g();
        renderblocks.func_147775_a(block);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderblocks.func_147768_a(block, 0.0, 0.0, 0.0, renderblocks.func_147787_a(block, 0, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderblocks.func_147806_b(block, 0.0, 0.0, 0.0, renderblocks.func_147787_a(block, 1, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderblocks.func_147761_c(block, 0.0, 0.0, 0.0, renderblocks.func_147787_a(block, 2, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderblocks.func_147734_d(block, 0.0, 0.0, 0.0, renderblocks.func_147787_a(block, 3, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderblocks.func_147798_e(block, 0.0, 0.0, 0.0, renderblocks.func_147787_a(block, 4, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderblocks.func_147764_f(block, 0.0, 0.0, 0.0, renderblocks.func_147787_a(block, 5, metadata));
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(IBlockAccess blockAccess, int x, int y, int z, Block block, int meta, RenderBlocks blockRenderer) {
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te instanceof PileTileEntity) {
            PileTileEntity pte = (PileTileEntity)te;
            long itemHash = this.getItemStackHash(pte.content);
            if (this.pileTileEntityRender.subIconIdMap.containsKey(itemHash)) {
                Tessellator tessellator = Tessellator.field_78398_a;
                int subIconId = this.pileTileEntityRender.subIconIdMap.get(itemHash);
                int[][][] brightness = new int[3][3][3];
                this.generateBrightnessMatrix(blockAccess, x, y, z, brightness);
                tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                boolean[] blocksViewAround = this.getBlocksViewAround(blockAccess, x, y, z);
                if (blocksViewAround[0] && blocksViewAround[1] && blocksViewAround[2] && blocksViewAround[3]) {
                    this.addFlatTop(tessellator, x, y, z, brightness, subIconId);
                } else if (!blocksViewAround[0] && blocksViewAround[1] && blocksViewAround[2] && blocksViewAround[3]) {
                    this.addSlope(tessellator, x, y, z, 0, brightness, subIconId);
                } else if (blocksViewAround[0] && !blocksViewAround[1] && blocksViewAround[2] && blocksViewAround[3]) {
                    this.addSlope(tessellator, x, y, z, 1, brightness, subIconId);
                } else if (blocksViewAround[0] && blocksViewAround[1] && !blocksViewAround[2] && blocksViewAround[3]) {
                    this.addSlope(tessellator, x, y, z, 2, brightness, subIconId);
                } else if (blocksViewAround[0] && blocksViewAround[1] && blocksViewAround[2] && !blocksViewAround[3]) {
                    this.addSlope(tessellator, x, y, z, 3, brightness, subIconId);
                } else if (blocksViewAround[0] && blocksViewAround[1] && !blocksViewAround[2] && !blocksViewAround[3]) {
                    this.addTwoSidedPyramid(tessellator, x, y, z, 2, brightness, subIconId);
                } else if (!blocksViewAround[0] && blocksViewAround[1] && blocksViewAround[2] && !blocksViewAround[3]) {
                    this.addTwoSidedPyramid(tessellator, x, y, z, 3, brightness, subIconId);
                } else if (!blocksViewAround[0] && !blocksViewAround[1] && blocksViewAround[2] && blocksViewAround[3]) {
                    this.addTwoSidedPyramid(tessellator, x, y, z, 0, brightness, subIconId);
                } else if (blocksViewAround[0] && !blocksViewAround[1] && !blocksViewAround[2] && blocksViewAround[3]) {
                    this.addTwoSidedPyramid(tessellator, x, y, z, 1, brightness, subIconId);
                } else {
                    this.addPyramid(tessellator, x, y, z, brightness, subIconId);
                }
                if (!blockAccess.func_147439_a(x, y - 1, z).func_149662_c()) {
                    this.addBottom(tessellator, x, y, z, brightness, subIconId);
                }
            }
            return true;
        }
        return false;
    }

    private boolean[] getBlocksViewAround(IBlockAccess blockAccess, int x, int y, int z) {
        return new boolean[]{blockAccess.func_147439_a(x, y, z + 1).func_149662_c(), blockAccess.func_147439_a(x + 1, y, z).func_149662_c(), blockAccess.func_147439_a(x, y, z - 1).func_149662_c(), blockAccess.func_147439_a(x - 1, y, z).func_149662_c()};
    }

    private void addBottom(Tessellator tessellator, int x, int y, int z, int[][][] brightness, int subIconId) {
        double[][] quad1 = new double[4][3];
        quad1[0] = new double[]{0.0, 0.0, 1.0};
        quad1[1] = new double[]{0.0, 0.0, 0.0};
        quad1[2] = new double[]{1.0, 0.0, 0.0};
        quad1[3] = new double[]{1.0, 0.0, 1.0};
        this.addQuad(tessellator, quad1, x, y, z, ForgeDirection.UP, brightness, subIconId);
    }

    private void addFlatTop(Tessellator tessellator, int x, int y, int z, int[][][] brightness, int subIconId) {
        double[][] quad1 = new double[4][3];
        double height = 0.9;
        quad1[0] = new double[]{1.0, height, 0.0};
        quad1[1] = new double[]{0.0, height, 0.0};
        quad1[2] = new double[]{0.0, height, 1.0};
        quad1[3] = new double[]{1.0, height, 1.0};
        this.addQuad(tessellator, quad1, x, y, z, ForgeDirection.UP, brightness, subIconId);
    }

    private void addSlope(Tessellator tessellator, int x, int y, int z, int rotation, int[][][] brightness, int subIconId) {
        double[][] quad = new double[4][3];
        quad[0] = new double[]{1.0, 1.0, 0.0};
        quad[1] = new double[]{0.0, 1.0, 0.0};
        quad[2] = new double[]{0.0, 0.0, 1.0};
        quad[3] = new double[]{1.0, 0.0, 1.0};
        while (rotation-- > 0) {
            this.rotateQuadByYAxis(quad);
        }
        this.addQuad(tessellator, quad, x, y, z, ForgeDirection.UP, brightness, subIconId);
    }

    private void addTwoSidedPyramid(Tessellator tessellator, int x, int y, int z, int rotation, int[][][] brightness, int subIconId) {
        double[][] quad = new double[4][3];
        quad[0] = new double[]{1.0, 0.0, 0.0};
        quad[1] = new double[]{0.0, 1.0, 0.0};
        quad[2] = new double[]{0.0, 0.0, 1.0};
        quad[3] = new double[]{1.0, 0.0, 1.0};
        while (rotation-- > 0) {
            this.rotateQuadByYAxis(quad);
        }
        this.addQuad(tessellator, quad, x, y, z, ForgeDirection.UP, brightness, subIconId);
    }

    private void addPyramid(Tessellator tessellator, int x, int y, int z, int[][][] brightness, int subIconId) {
        double[][] quad1 = new double[4][3];
        double[][] quad2 = new double[4][3];
        double pileHeight = 0.3;
        quad1[0] = new double[]{1.0, 0.0, 1.0};
        quad1[1] = new double[]{1.0, 0.0, 0.0};
        quad1[2] = new double[]{0.0, 0.0, 0.0};
        quad1[3] = new double[]{0.5, pileHeight, 0.5};
        quad2 = this.copyAndRotateQuadByYAxis(quad1, 2);
        this.addQuad(tessellator, quad1, x, y, z, ForgeDirection.UP, brightness, subIconId);
        this.addQuad(tessellator, quad2, x, y, z, ForgeDirection.UP, brightness, subIconId);
    }

    private void rotateQuadByYAxis(double[][] quad) {
        for (double[] v : quad) {
            double newV2 = 1.0 - v[0];
            v[0] = v[2];
            v[2] = newV2;
        }
    }

    private double[][] copyAndRotateQuadByYAxis(double[][] quad, int rotation) {
        double[][] quadOut = new double[4][3];
        for (int i = 0; i < quad.length * 3; ++i) {
            quadOut[i / 3][i % 3] = quad[i / 3][i % 3];
        }
        while (rotation-- > 0) {
            this.rotateQuadByYAxis(quadOut);
        }
        return quadOut;
    }

    private void addQuad(Tessellator tessellator, double[][] quad, int x, int y, int z, ForgeDirection uvmapping, int[][][] brightness, int subIconId) {
        int iu = 0;
        int iv = 2;
        if (uvmapping.offsetY == 0) {
            iv = 1;
            if (uvmapping.offsetZ == 0) {
                iu = 2;
            }
        }
        float[] normal = IHLMathUtils.get_triangle_normal(quad);
        float minu = this.pileTileEntityRender.getSubIconMinU(subIconId);
        float minv = this.pileTileEntityRender.getSubIconMinV(subIconId);
        float du = this.pileTileEntityRender.getSubIconDU(subIconId);
        float dv = this.pileTileEntityRender.getSubIconDV(subIconId);
        double u1 = (double)minu + quad[0][iu] * (double)du;
        double u2 = (double)minu + quad[1][iu] * (double)du;
        double u3 = (double)minu + quad[2][iu] * (double)du;
        double u4 = (double)minu + quad[3][iu] * (double)du;
        double v1 = (double)minv + quad[0][iv] * (double)dv;
        double v2 = (double)minv + quad[1][iv] * (double)dv;
        double v3 = (double)minv + quad[2][iv] * (double)dv;
        double v4 = (double)minv + quad[3][iv] * (double)dv;
        tessellator.func_78375_b(normal[0], normal[1], normal[2]);
        tessellator.func_78380_c(this.getBrightness(quad[0], brightness));
        tessellator.func_78374_a((double)x + quad[0][0], (double)y + quad[0][1], (double)z + quad[0][2], u1, v1);
        tessellator.func_78380_c(this.getBrightness(quad[1], brightness));
        tessellator.func_78374_a((double)x + quad[1][0], (double)y + quad[1][1], (double)z + quad[1][2], u2, v2);
        tessellator.func_78380_c(this.getBrightness(quad[2], brightness));
        tessellator.func_78374_a((double)x + quad[2][0], (double)y + quad[2][1], (double)z + quad[2][2], u3, v3);
        tessellator.func_78380_c(this.getBrightness(quad[3], brightness));
        tessellator.func_78374_a((double)x + quad[3][0], (double)y + quad[3][1], (double)z + quad[3][2], u4, v4);
    }

    public long getItemStackHash(ItemStack stack) {
        if (stack == null) {
            return 0L;
        }
        return (long)Item.func_150891_b((Item)stack.func_77973_b()) << 31 ^ (long)stack.func_77960_j();
    }

    private void generateBrightnessMatrix(IBlockAccess blockAccess, int x, int y, int z, int[][][] brightness) {
        for (int ix = -1; ix <= 1; ++ix) {
            for (int iy = -1; iy <= 1; ++iy) {
                for (int iz = -1; iz <= 1; ++iz) {
                    Block block = blockAccess.func_147439_a(ix + x, iy + y, iz + z);
                    brightness[ix + 1][iy + 1][iz + 1] = block != null && block != Blocks.field_150350_a ? block.func_149677_c(blockAccess, ix + x, iy + y, iz + z) : block.func_149677_c(blockAccess, x, y, z);
                }
            }
        }
    }

    private int getBrightness(double[] v, int[][][] brightness) {
        int x1 = v[0] < 0.5 ? 0 : 1;
        int x2 = x1 + 1;
        int y1 = v[1] < 0.5 ? 0 : 1;
        int y2 = y1 + 1;
        int z1 = v[2] < 0.5 ? 0 : 1;
        int z2 = z1 + 1;
        float dx = v[0] < 0.5 ? (float)v[0] * 2.0f : (float)v[0] * 2.0f - 1.0f;
        float dy = v[1] < 0.5 ? (float)v[1] * 2.0f : (float)v[1] * 2.0f - 1.0f;
        float dz = v[2] < 0.5 ? (float)v[2] * 2.0f : (float)v[2] * 2.0f - 1.0f;
        int brightness1 = brightness[x1][y1][z1];
        int brightness2 = brightness[x2][y2][z2];
        float d = IHLMathUtils.sqrt(dx * dx + dy * dy + dz * dz);
        return (int)((float)brightness1 * (1.0f - d) * 0.8f + (float)brightness2 * d * 0.8f + (float)brightness[1][1][1] * 0.2f) & 0xFF00FF;
    }

    public boolean shouldRender3DInInventory(int arg0) {
        return true;
    }
}

