/*
 * Decompiled with CFR 0.152.
 */
package ihl.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ihl.model.ModelKnee;
import ihl.model.ModelToplessBox;
import ihl.model.ModelTube;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.TextureOffset;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class IHLModelRenderer {
    public float textureWidth = 64.0f;
    public float textureHeight = 32.0f;
    private int textureOffsetX;
    private int textureOffsetY;
    public float rotationPointX;
    public float rotationPointY;
    public float rotationPointZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    private boolean compiled;
    private int displayList;
    public boolean mirror;
    public boolean showModel = true;
    public boolean isHidden;
    public List<Object> cubeList = new ArrayList<Object>();
    public List<ModelRenderer> childModels;
    public final String boxName;
    private ModelBase baseModel;
    public float offsetX;
    public float offsetY;
    public float offsetZ;
    public boolean drawFromInside = false;

    public IHLModelRenderer(ModelBase par1ModelBase, String par2Str) {
        this.baseModel = par1ModelBase;
        par1ModelBase.field_78092_r.add(this);
        this.boxName = par2Str;
        this.setTextureSize(par1ModelBase.field_78090_t, par1ModelBase.field_78089_u);
    }

    public IHLModelRenderer(ModelBase par1ModelBase) {
        this(par1ModelBase, null);
    }

    public IHLModelRenderer(ModelBase par1ModelBase, int par2, int par3) {
        this(par1ModelBase);
        this.setTextureOffset(par2, par3);
    }

    public void addChild(ModelRenderer par1ModelRenderer) {
        if (this.childModels == null) {
            this.childModels = new ArrayList<ModelRenderer>();
        }
        this.childModels.add(par1ModelRenderer);
    }

    public IHLModelRenderer setTextureOffset(int par1, int par2) {
        this.textureOffsetX = par1;
        this.textureOffsetY = par2;
        return this;
    }

    public IHLModelRenderer addBox(String par1Str, float par2, float par3, float par4, int par5, int par6, int par7, boolean inverted, boolean[] renderFace) {
        par1Str = this.boxName + "." + par1Str;
        TextureOffset var8 = this.baseModel.func_78084_a(par1Str);
        this.setTextureOffset(var8.field_78783_a, var8.field_78782_b);
        this.cubeList.add(new ModelToplessBox(this, this.textureOffsetX, this.textureOffsetY, par2, par3, par4, par5, par6, par7, 0.0f, inverted, renderFace).func_78244_a(par1Str));
        return this;
    }

    public IHLModelRenderer addBox(String par1Str, float par2, float par3, float par4, int par5, int par6, int par7, boolean inverted) {
        boolean[] renderFace = new boolean[]{true, true, true, true, true, true};
        par1Str = this.boxName + "." + par1Str;
        TextureOffset var8 = this.baseModel.func_78084_a(par1Str);
        this.setTextureOffset(var8.field_78783_a, var8.field_78782_b);
        this.cubeList.add(new ModelToplessBox(this, this.textureOffsetX, this.textureOffsetY, par2, par3, par4, par5, par6, par7, 0.0f, inverted, renderFace).func_78244_a(par1Str));
        return this;
    }

    public IHLModelRenderer addBox(float par1, float par2, float par3, int par4, int par5, int par6, boolean inverted, boolean[] renderFace) {
        this.cubeList.add(new ModelToplessBox(this, this.textureOffsetX, this.textureOffsetY, par1, par2, par3, par4, par5, par6, 0.0f, inverted, renderFace));
        return this;
    }

    public IHLModelRenderer addTube(String par1Str, float par1, float par2, float par3, int par4, int par5, int par6, float radius1, float radius2, ForgeDirection direction) {
        par1Str = this.boxName + "." + par1Str;
        TextureOffset var8 = this.baseModel.func_78084_a(par1Str);
        this.setTextureOffset(var8.field_78783_a, var8.field_78782_b);
        this.cubeList.add(new ModelTube(this, this.textureOffsetX, this.textureOffsetY, par1, par2, par3, par4, par5, par6, 0.0f, radius1, radius2, direction));
        return this;
    }

    public IHLModelRenderer addKnee(String par1Str, float par1, float par2, float par3, int par4, int par5, int par6, float radius1, float radius2, ForgeDirection direction, ForgeDirection direction2) {
        par1Str = this.boxName + "." + par1Str;
        TextureOffset var8 = this.baseModel.func_78084_a(par1Str);
        this.setTextureOffset(var8.field_78783_a, var8.field_78782_b);
        this.cubeList.add(new ModelKnee(this, this.textureOffsetX, this.textureOffsetY, par1, par2, par3, par4, par5, par6, 0.0f, radius1, radius2, direction, direction2));
        return this;
    }

    public IHLModelRenderer addBox(float par1, float par2, float par3, int par4, int par5, int par6) {
        boolean[] renderFace = new boolean[]{true, true, true, true, true, true};
        this.cubeList.add(new ModelToplessBox(this, this.textureOffsetX, this.textureOffsetY, par1, par2, par3, par4, par5, par6, 0.0f, false, renderFace));
        return this;
    }

    public void addBox(float par1, float par2, float par3, int par4, int par5, int par6, float par7, boolean inverted, boolean[] renderFace) {
        this.cubeList.add(new ModelToplessBox(this, this.textureOffsetX, this.textureOffsetY, par1, par2, par3, par4, par5, par6, par7, inverted, renderFace));
    }

    public void setRotationPoint(float par1, float par2, float par3) {
        this.rotationPointX = par1;
        this.rotationPointY = par2;
        this.rotationPointZ = par3;
    }

    public void render(float par1) {
        if (!this.isHidden && this.showModel) {
            if (!this.compiled) {
                this.compileDisplayList(par1);
            }
            GL11.glTranslatef((float)this.offsetX, (float)this.offsetY, (float)this.offsetZ);
            if (this.rotateAngleX == 0.0f && this.rotateAngleY == 0.0f && this.rotateAngleZ == 0.0f) {
                if (this.rotationPointX == 0.0f && this.rotationPointY == 0.0f && this.rotationPointZ == 0.0f) {
                    GL11.glCallList((int)this.displayList);
                    if (this.childModels != null) {
                        for (int var2 = 0; var2 < this.childModels.size(); ++var2) {
                            this.childModels.get(var2).func_78785_a(par1);
                        }
                    }
                } else {
                    GL11.glTranslatef((float)(this.rotationPointX * par1), (float)(this.rotationPointY * par1), (float)(this.rotationPointZ * par1));
                    GL11.glCallList((int)this.displayList);
                    if (this.childModels != null) {
                        for (int var2 = 0; var2 < this.childModels.size(); ++var2) {
                            this.childModels.get(var2).func_78785_a(par1);
                        }
                    }
                    GL11.glTranslatef((float)(-this.rotationPointX * par1), (float)(-this.rotationPointY * par1), (float)(-this.rotationPointZ * par1));
                }
            } else {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(this.rotationPointX * par1), (float)(this.rotationPointY * par1), (float)(this.rotationPointZ * par1));
                if (this.rotateAngleZ != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.rotateAngleY != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.rotateAngleX != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
                GL11.glCallList((int)this.displayList);
                if (this.childModels != null) {
                    for (int var2 = 0; var2 < this.childModels.size(); ++var2) {
                        this.childModels.get(var2).func_78785_a(par1);
                    }
                }
                GL11.glPopMatrix();
            }
            GL11.glTranslatef((float)(-this.offsetX), (float)(-this.offsetY), (float)(-this.offsetZ));
        }
    }

    public void renderWithRotation(float par1) {
        if (!this.isHidden && this.showModel) {
            if (!this.compiled) {
                this.compileDisplayList(par1);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.rotationPointX * par1), (float)(this.rotationPointY * par1), (float)(this.rotationPointZ * par1));
            if (this.rotateAngleY != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.rotateAngleX != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (this.rotateAngleZ != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GL11.glCallList((int)this.displayList);
            GL11.glPopMatrix();
        }
    }

    public void postRender(float par1) {
        if (!this.isHidden && this.showModel) {
            if (!this.compiled) {
                this.compileDisplayList(par1);
            }
            if (this.rotateAngleX == 0.0f && this.rotateAngleY == 0.0f && this.rotateAngleZ == 0.0f) {
                if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f) {
                    GL11.glTranslatef((float)(this.rotationPointX * par1), (float)(this.rotationPointY * par1), (float)(this.rotationPointZ * par1));
                }
            } else {
                GL11.glTranslatef((float)(this.rotationPointX * par1), (float)(this.rotationPointY * par1), (float)(this.rotationPointZ * par1));
                if (this.rotateAngleZ != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.rotateAngleY != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.rotateAngleX != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
            }
        }
    }

    private void compileDisplayList(float par1) {
        this.displayList = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)this.displayList, (int)4864);
        Tessellator var2 = Tessellator.field_78398_a;
        for (int var3 = 0; var3 < this.cubeList.size(); ++var3) {
            if (this.cubeList.get(var3) instanceof ModelToplessBox) {
                ((ModelToplessBox)this.cubeList.get(var3)).render(var2, par1);
                continue;
            }
            if (this.cubeList.get(var3) instanceof ModelTube) {
                ((ModelTube)this.cubeList.get(var3)).render(var2, par1);
                continue;
            }
            if (!(this.cubeList.get(var3) instanceof ModelKnee)) continue;
            ((ModelKnee)this.cubeList.get(var3)).render(var2, par1);
        }
        GL11.glEndList();
        this.compiled = true;
    }

    public IHLModelRenderer setTextureSize(int par1, int par2) {
        this.textureWidth = par1;
        this.textureHeight = par2;
        return this;
    }

    public void addBox(String string, float f, float g, float h, int i, int j, int k) {
        this.addBox(string, f, g, h, i, j, k, false);
    }
}

