/*
 * Decompiled with CFR 0.152.
 */
package ihl.crop_harvestors;

import ic2.core.IC2;
import ic2.core.block.TileEntityInventory;
import ic2.core.network.NetworkManager;
import ihl.IHLMod;
import ihl.utils.IHLFluidTank;
import ihl.utils.IHLUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class SackTileEntity
extends TileEntityInventory
implements IFluidHandler {
    private final int maxLeavesHeight = 12;
    private final int maxLeavesWidth = 5;
    public float leavesCounter = 0.0f;
    private int updateCounter = 1100;
    private Random rand = new Random();
    private int blobTimer = 20;
    public byte currentTree = 0;
    public final int blobCapacity = 1;
    private static final byte RUBBERTREE = 0;
    private static final byte SPRUCE = 1;
    public final IHLFluidTank fluidTank = new IHLFluidTank(8000);
    public int visibleFluidId = -1;
    public int visibleFluidAmount = 1;

    public List<String> getNetworkedFields() {
        List fields = super.getNetworkedFields();
        fields.add("visibleFluidId");
        fields.add("visibleFluidAmount");
        fields.add("leavesCounter");
        fields.add("currentTree");
        return fields;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.fluidTank.readFromNBT(nbttagcompound.func_74775_l("fluidTank"));
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagCompound fluidTankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(fluidTankTag);
        nbttagcompound.func_74782_a("fluidTank", (NBTBase)fluidTankTag);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(IHLMod.sackBlock, 1);
    }

    public boolean enableUpdateEntity() {
        return true;
    }

    public void updateEntityClient() {
        super.updateEntityClient();
        if (IHLMod.ic2Leaves != null && IHLMod.ic2Wood != null) {
            if (this.blobTimer <= 0) {
                if (IC2.platform.isRendering()) {
                    switch (this.currentTree) {
                        case 0: {
                            IHLMod.proxy.spawnParticle(1, this.field_145850_b, (double)this.field_145851_c + 0.5 + (double)this.mX() * 0.5, (double)this.field_145848_d + 1.05, (double)this.field_145849_e + 0.5 + (double)this.mZ() * 0.5, -((double)this.mX()) * 0.1, -0.03, -((double)this.mZ()) * 0.1, 0.1f);
                            break;
                        }
                        case 1: {
                            IHLMod.proxy.spawnParticle(2, this.field_145850_b, (double)this.field_145851_c + 0.5 + (double)this.mX() * 0.5, (double)this.field_145848_d + 1.05, (double)this.field_145849_e + 0.5 + (double)this.mZ() * 0.5, -((double)this.mX()) * 0.1, -0.03, -((double)this.mZ()) * 0.1, 0.1f);
                        }
                    }
                }
                if (this.fluidTank.getFluidAmount() >= this.fluidTank.getCapacity() && IC2.platform.isRendering()) {
                    switch (this.currentTree) {
                        case 0: {
                            IHLMod.proxy.spawnParticle(1, this.field_145850_b, (double)this.field_145851_c + 0.5 - (double)this.mX() * 0.3 + (this.rand.nextDouble() - 0.5) * (double)this.mZ() * 0.6, (double)this.field_145848_d + 0.8, (double)this.field_145849_e + 0.5 - (double)this.mZ() * 0.3 + (this.rand.nextDouble() - 0.5) * (double)this.mX() * 0.6, 0.0, -0.05, 0.0, 0.1f);
                            break;
                        }
                        case 1: {
                            IHLMod.proxy.spawnParticle(2, this.field_145850_b, (double)this.field_145851_c + 0.5 - (double)this.mX() * 0.3 + (this.rand.nextDouble() - 0.5) * (double)this.mZ() * 0.6, (double)this.field_145848_d + 0.8, (double)this.field_145849_e + 0.5 - (double)this.mZ() * 0.3 + (this.rand.nextDouble() - 0.5) * (double)this.mX() * 0.6, 0.0, -0.05, 0.0, 0.1f);
                        }
                    }
                }
                this.blobTimer = this.leavesCounter > 1.0f ? Math.round(4000.0f / this.leavesCounter) : 200;
            } else if (this.leavesCounter > 1.0f) {
                --this.blobTimer;
            }
            if (this.updateCounter < 1200) {
                ++this.updateCounter;
            }
        }
    }

    public void updateEntityServer() {
        super.updateEntityServer();
        if (IHLMod.ic2Leaves != null && IHLMod.ic2Wood != null) {
            if (this.blobTimer <= 0) {
                if (IC2.platform.isSimulating()) {
                    switch (this.currentTree) {
                        case 0: {
                            this.fluidTank.fill(new FluidStack(FluidRegistry.getFluid((String)"fluidrubbertreesap"), 1), true);
                            break;
                        }
                        case 1: {
                            this.fluidTank.fill(new FluidStack(FluidRegistry.getFluid((String)"spruceresin"), 1), true);
                        }
                    }
                }
                this.blobTimer = this.leavesCounter > 1.0f ? Math.round(4000.0f / this.leavesCounter) : 200;
            } else if (this.leavesCounter > 1.0f) {
                --this.blobTimer;
            }
            if (this.updateCounter < 1200) {
                ++this.updateCounter;
            } else if (IC2.platform.isSimulating()) {
                FluidStack fStack;
                IFluidHandler fte;
                TileEntity te;
                this.updateCounter = this.rand.nextInt(600);
                if (this.checkCorrectPlacing()) {
                    this.countRubberTreeLeaves();
                } else {
                    this.leavesCounter = 0.0f;
                }
                ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "currentTree");
                ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "leavesCounter");
                if (this.fluidTank.getFluid() != null && (te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) != null && te instanceof IFluidHandler && (fte = (IFluidHandler)te).canFill(ForgeDirection.UP, (fStack = this.fluidTank.drain(Integer.MAX_VALUE, false)).getFluid()) && fte.fill(ForgeDirection.UP, fStack, false) > 0) {
                    int amount = fte.fill(ForgeDirection.UP, fStack, true);
                    this.fluidTank.drain(amount, true);
                }
            }
            if (this.fluidTank.getFluid() != null && (this.visibleFluidId != this.fluidTank.getFluid().getFluid().getID() || Math.abs(this.visibleFluidAmount - this.fluidTank.getFluidAmount()) > 20)) {
                this.visibleFluidId = this.fluidTank.getFluid().getFluid().getID();
                this.visibleFluidAmount = this.fluidTank.getFluidAmount();
                ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "visibleFluidId");
                ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "visibleFluidAmount");
            } else if (this.fluidTank.getFluid() == null && this.visibleFluidId != -1) {
                this.visibleFluidId = -1;
                ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "visibleFluidId");
            }
        }
    }

    private boolean checkCorrectPlacing() {
        int[] xz = new int[]{0, 1, 0, -1, 0};
        for (int i = 0; i <= 3; ++i) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c + xz[i], this.field_145848_d, this.field_145849_e + xz[i + 1]);
            int meta = this.field_145850_b.func_72805_g(this.field_145851_c + xz[i], this.field_145848_d, this.field_145849_e + xz[i + 1]);
            Block block2 = this.field_145850_b.func_147439_a(this.field_145851_c + xz[i], this.field_145848_d + 1, this.field_145849_e + xz[i + 1]);
            int meta2 = this.field_145850_b.func_72805_g(this.field_145851_c + xz[i], this.field_145848_d + 1, this.field_145849_e + xz[i + 1]);
            if (!(meta <= 0 || meta2 <= 0 || block != IHLMod.ic2Wood && block != IHLMod.rubberTreeBlock || block2 != IHLMod.ic2Wood && block2 != IHLMod.rubberTreeBlock)) {
                short newFacing = this.getFacingFromXZ(xz[i], xz[i + 1]);
                this.setFacing(newFacing);
                if (block2 == IHLMod.ic2Wood) {
                    this.field_145850_b.func_147465_d(this.field_145851_c + xz[i], this.field_145848_d + 1, this.field_145849_e + xz[i + 1], IHLMod.rubberTreeBlock, (int)newFacing, 3);
                } else if (newFacing != meta2) {
                    return false;
                }
                this.currentTree = 0;
                return this.checkGround();
            }
            if ((block != Blocks.field_150364_r || meta != 1) && (block != IHLMod.spruceTreeBlock || meta <= 0) || (block2 != Blocks.field_150364_r || meta2 != 1) && (block2 != IHLMod.spruceTreeBlock || meta2 <= 0)) continue;
            short newFacing = this.getFacingFromXZ(xz[i], xz[i + 1]);
            this.setFacing(newFacing);
            if (block2 == Blocks.field_150364_r) {
                this.field_145850_b.func_147465_d(this.field_145851_c + xz[i], this.field_145848_d + 1, this.field_145849_e + xz[i + 1], IHLMod.spruceTreeBlock, (int)newFacing, 3);
            } else if (newFacing != meta2) {
                return false;
            }
            this.currentTree = 1;
            return this.checkGround();
        }
        return false;
    }

    private boolean checkGround() {
        for (int h = 0; h <= this.maxLeavesHeight; ++h) {
            int meta;
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c + this.mX(), this.field_145848_d - h, this.field_145849_e + this.mZ());
            if (!this.isLogBlock(block, meta = this.field_145850_b.func_72805_g(this.field_145851_c + this.mX(), this.field_145848_d - h, this.field_145849_e + this.mZ()))) {
                return IHLUtils.isBlockRegisteredInOreDictionaryAs(block, "blockDirt");
            }
            if (meta > 0) continue;
            return false;
        }
        return false;
    }

    private boolean isLogBlock(Block block, int meta) {
        switch (this.currentTree) {
            case 0: {
                return block == IHLMod.ic2Wood || block == IHLMod.rubberTreeBlock;
            }
            case 1: {
                return block == Blocks.field_150364_r && meta == 1 || block == IHLMod.spruceTreeBlock && meta > 0;
            }
        }
        return false;
    }

    private boolean isLeavesBlock(Block block) {
        switch (this.currentTree) {
            case 0: {
                return block == IHLMod.ic2Leaves;
            }
            case 1: {
                return block == Blocks.field_150362_t;
            }
        }
        return false;
    }

    private boolean isIncisedLog(Block block) {
        switch (this.currentTree) {
            case 0: {
                return block == IHLMod.rubberTreeBlock;
            }
            case 1: {
                return block == IHLMod.spruceTreeBlock;
            }
        }
        return false;
    }

    private void countRubberTreeLeaves() {
        int meta;
        Block block;
        this.leavesCounter = 0.0f;
        int[][][] leavesMatrix = new int[this.maxLeavesWidth][this.maxLeavesWidth][this.maxLeavesHeight];
        for (int iy = 1; iy < this.maxLeavesHeight && (this.isLogBlock(block = this.field_145850_b.func_147439_a(this.field_145851_c + this.mX(), this.field_145848_d + iy, this.field_145849_e + this.mZ()), meta = this.field_145850_b.func_72805_g(this.field_145851_c + this.mX(), this.field_145848_d + iy, this.field_145849_e + this.mZ())) || this.isLeavesBlock(block)); ++iy) {
            if (this.isLeavesBlock(block)) {
                this.leavesCounter += this.field_145850_b.func_72801_o(this.field_145851_c + this.mX(), this.field_145848_d + iy, this.field_145849_e + this.mZ());
            } else if (this.isIncisedLog(block) && iy >= 2) break;
            for (int sign = 1; sign >= -1; sign -= 2) {
                for (int ix = 1; ix <= 2 && this.isLeavesBlock(block = this.field_145850_b.func_147439_a(this.field_145851_c + this.mX() + ix * sign, this.field_145848_d + iy, this.field_145849_e + this.mZ())); ++ix) {
                    this.leavesCounter += this.field_145850_b.func_72801_o(this.field_145851_c + this.mX() + ix * sign, this.field_145848_d + iy, this.field_145849_e + this.mZ());
                    leavesMatrix[2 + ix * sign][2][iy - 1] = 1;
                }
                for (int iz = 1; iz <= 2 && this.isLeavesBlock(block = this.field_145850_b.func_147439_a(this.field_145851_c + this.mX(), this.field_145848_d + iy, this.field_145849_e + this.mZ() + iz * sign)); ++iz) {
                    this.leavesCounter += this.field_145850_b.func_72801_o(this.field_145851_c + this.mX(), this.field_145848_d + iy, this.field_145849_e + this.mZ() + iz * sign);
                    leavesMatrix[2][2 + iz * sign][iy - 1] = 1;
                }
            }
            for (int signx = 1; signx >= -1; signx -= 2) {
                for (int signz = 1; signz >= -1; signz -= 2) {
                    if ((leavesMatrix[2][2 + signz][iy - 1] == 1 || leavesMatrix[2 + signx][2][iy - 1] == 1) && this.isLeavesBlock(block = this.field_145850_b.func_147439_a(this.field_145851_c + this.mX() + signx, this.field_145848_d + iy, this.field_145849_e + this.mZ() + signz))) {
                        this.leavesCounter += this.field_145850_b.func_72801_o(this.field_145851_c + this.mX() + signx, this.field_145848_d + iy, this.field_145849_e + this.mZ() + signz);
                        leavesMatrix[2 + signx][2 + signz][iy - 1] = 1;
                    }
                    if ((leavesMatrix[2 + signx * 2][2][iy - 1] == 1 || leavesMatrix[2 + signx][2 + signz][iy - 1] == 1) && (block = this.field_145850_b.func_147439_a(this.field_145851_c + this.mX() + signx * 2, this.field_145848_d + iy, this.field_145849_e + this.mZ() + signz)) == IHLMod.ic2Leaves) {
                        this.leavesCounter += this.field_145850_b.func_72801_o(this.field_145851_c + this.mX() + signx * 2, this.field_145848_d + iy, this.field_145849_e + this.mZ() + signz);
                        leavesMatrix[2 + signx * 2][2 + signz][iy - 1] = 1;
                    }
                    if ((leavesMatrix[2][2 + signz * 2][iy - 1] == 1 || leavesMatrix[2 + signx][2 + signz][iy - 1] == 1) && this.isLeavesBlock(block = this.field_145850_b.func_147439_a(this.field_145851_c + this.mX() + signx, this.field_145848_d + iy, this.field_145849_e + this.mZ() + signz * 2))) {
                        this.leavesCounter += this.field_145850_b.func_72801_o(this.field_145851_c + this.mX() + signx, this.field_145848_d + iy, this.field_145849_e + this.mZ() + signz * 2);
                        leavesMatrix[2 + signx][2 + signz * 2][iy - 1] = 1;
                    }
                    if (leavesMatrix[2 + signx * 2][2 + signz][iy - 1] != 1 && leavesMatrix[2 + signx][2 + signz * 2][iy - 1] != 1 || !this.isLeavesBlock(block = this.field_145850_b.func_147439_a(this.field_145851_c + this.mX() + signx * 2, this.field_145848_d + iy, this.field_145849_e + this.mZ() + signz * 2))) continue;
                    this.leavesCounter += this.field_145850_b.func_72801_o(this.field_145851_c + this.mX() + signx * 2, this.field_145848_d + iy, this.field_145849_e + this.mZ() + signz * 2);
                }
            }
        }
    }

    public boolean canDrain(ForgeDirection arg0, Fluid arg1) {
        return true;
    }

    public boolean canFill(ForgeDirection arg0, Fluid arg1) {
        return false;
    }

    public String func_145825_b() {
        return "sack";
    }

    private int mX() {
        switch (this.getFacing()) {
            case 4: {
                return -1;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    private int mZ() {
        switch (this.getFacing()) {
            case 3: {
                return 1;
            }
            case 2: {
                return -1;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
        }
        return -1;
    }

    private short getFacingFromXZ(int x, int z) {
        switch (x) {
            case -1: {
                return 4;
            }
            case 1: {
                return 5;
            }
        }
        switch (z) {
            case 1: {
                return 3;
            }
            case -1: {
                return 2;
            }
        }
        return 2;
    }

    public float getRenderLiquidLevel() {
        return (float)this.visibleFluidAmount / (float)this.fluidTank.getCapacity();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }

    public FluidStack drain(ForgeDirection arg0, FluidStack arg1, boolean arg2) {
        if (this.canDrain(arg0, arg1.getFluid())) {
            FluidStack fStack = this.fluidTank.drain(arg1, arg2);
            return fStack;
        }
        return null;
    }

    public FluidStack drain(ForgeDirection arg0, int arg1, boolean arg2) {
        if (this.canDrain(arg0, null)) {
            FluidStack fStack = this.fluidTank.drain(arg1, arg2);
            return fStack;
        }
        return null;
    }

    public int fill(ForgeDirection arg0, FluidStack arg1, boolean arg2) {
        return 0;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection arg0) {
        return new FluidTankInfo[]{this.fluidTank.getInfo()};
    }
}

