/*
 * Decompiled with CFR 0.152.
 */
package ihl.enviroment;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ihl.IHLMod;
import ihl.enviroment.LightSource;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class LightHandler {
    private int[][] directionMasks;
    private int[][] vectors;
    private int bits;
    private int halfValue;
    private int lightBitsPerDimension = 10;
    private int maxLightRadius = (1 << this.lightBitsPerDimension - 1) - 1;
    private int bitmask = (1 << this.lightBitsPerDimension) - 1;
    public final Set<LightSource> lightSources = new HashSet<LightSource>();

    public LightHandler() {
        this.directionMasks = IHLMod.explosionHandler.directionMasks;
        this.vectors = IHLMod.explosionHandler.vectors;
        this.bits = IHLMod.explosionHandler.bits;
        this.halfValue = IHLMod.explosionHandler.halfValue;
    }

    public int encodeXYZ(int x, int y, int z) {
        return x + this.maxLightRadius << this.lightBitsPerDimension * 2 | y + this.maxLightRadius << this.lightBitsPerDimension | z + this.maxLightRadius;
    }

    public int[] decodeXYZ(int l) {
        return new int[]{(l >>> this.lightBitsPerDimension * 2) - this.maxLightRadius, (l >>> this.lightBitsPerDimension & this.bitmask) - this.maxLightRadius, (l & this.bitmask) - this.maxLightRadius};
    }

    public LightSource calculateOmniLightSource(World world, int sourceX, int sourceY, int sourceZ, int power, int red, int green, int blue) {
        LightSource lightSource = new LightSource(sourceX, sourceY, sourceZ, red, green, blue, power);
        int[] borders = new int[]{sourceX, sourceY, sourceZ, sourceX, sourceY, sourceZ};
        int[] evSource = new int[]{sourceX, sourceY, sourceZ};
        int[] lightSourceXYZ = new int[]{sourceX, sourceY, sourceZ};
        for (int i = 0; i < this.directionMasks.length; ++i) {
            int[] directionMask = this.directionMasks[i];
            this.litBlocksAndGetDescendants(world, evSource, lightSourceXYZ, lightSource.illuminatedBlocks, 0, power, directionMask, borders);
        }
        lightSource.setBorders(borders[0], borders[1], borders[2], borders[3], borders[4], borders[5]);
        return lightSource;
    }

    private void litBlocksAndGetDescendants(World world, int[] evSource, int[] lightSource, BitSet illuminatedBlocksSet, int ev, int power, int[] directionMask, int[] borders) {
        power = this.getNewPower(world, ev, evSource, lightSource, power, directionMask, illuminatedBlocksSet, borders);
        if ((power = (power << 4) / 17 - 1) > 1) {
            if (this.vectors[ev][0] == 0) {
                int[] xyz = IHLMod.explosionHandler.decodeXYZ(ev);
                int xb = xyz[0] >> this.bits - 1;
                int yb = xyz[1] >> this.bits - 1;
                int zb = xyz[2] >> this.bits - 1;
                int hashb = xb << 2 | yb << 1 | zb;
                xyz[0] = xyz[0] - xb * this.halfValue;
                xyz[1] = xyz[1] - yb * this.halfValue;
                xyz[2] = xyz[2] - zb * this.halfValue;
                if (hashb == 0 || xb > 1 || yb > 1 || zb > 1) {
                    throw new ArithmeticException("End vectors shall be higher than half value");
                }
                int ev2 = IHLMod.explosionHandler.encodeXYZ(xyz[0], xyz[1], xyz[2]);
                int[] nextEVSource = new int[]{evSource[0] + xb * this.halfValue * directionMask[0], evSource[1] + yb * this.halfValue * directionMask[1], evSource[2] + zb * this.halfValue * directionMask[2]};
                this.litBlocksAndGetDescendants(world, nextEVSource, lightSource, illuminatedBlocksSet, ev2, power, directionMask, borders);
            } else {
                for (int d1 : this.vectors[ev]) {
                    if (d1 == 0) continue;
                    this.litBlocksAndGetDescendants(world, evSource, lightSource, illuminatedBlocksSet, d1, power, directionMask, borders);
                }
            }
        }
    }

    private int getNewPower(World world, int ev, int[] evSource, int[] lightSource, int power, int[] directionMask, BitSet illuminatedBlocksSet, int[] borders) {
        int power1 = power;
        int[] xyz = IHLMod.explosionHandler.decodeXYZ(ev);
        int absX = xyz[0] * directionMask[0] + evSource[0];
        int absY = xyz[1] * directionMask[1] + evSource[1];
        int absZ = xyz[2] * directionMask[2] + evSource[2];
        if (absX < borders[0]) {
            borders[0] = absX;
        } else if (absY < borders[1]) {
            borders[1] = absY;
        } else if (absZ < borders[2]) {
            borders[2] = absZ;
        } else if (absX > borders[3]) {
            borders[3] = absX;
        } else if (absY > borders[4]) {
            borders[4] = absY;
        } else if (absZ > borders[5]) {
            borders[5] = absZ;
        }
        Block block = world.func_147439_a(absX, absY, absZ);
        if (block.equals(Blocks.field_150350_a) || block.isAir((IBlockAccess)world, absX, absY, absZ)) {
            return power;
        }
        int lightBitAddress = this.encodeXYZ(absX - lightSource[0], absY - lightSource[1], absZ - lightSource[2]);
        illuminatedBlocksSet.set(lightBitAddress);
        return power1 *= world.getBlockLightOpacity(absX, absY, absZ) / 16;
    }

    public void addLightSource(LightSource lightSource) {
        System.out.println("Adding light source. Borders:");
        System.out.println("from " + lightSource.fromX + ";" + lightSource.fromY + ";" + lightSource.fromZ);
        System.out.println("to " + lightSource.toX + ";" + lightSource.toY + ";" + lightSource.toZ);
        this.lightSources.add(lightSource);
    }

    public void removeLightSource(LightSource lightSource) {
        this.lightSources.remove(lightSource);
    }
}

