/*
 * Decompiled with CFR 0.152.
 */
package ihl.flexible_cable;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.api.recipe.IRecipeInput;
import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ihl.IHLMod;
import ihl.flexible_cable.InvSlotOutputInProgress;
import ihl.flexible_cable.InvSlotProcessableIronWorkbench;
import ihl.flexible_cable.InvSlotTool;
import ihl.flexible_cable.InvSlotWorkspaceElement;
import ihl.flexible_cable.IronWorkbenchContainer;
import ihl.flexible_cable.IronWorkbenchGui;
import ihl.interfaces.IWire;
import ihl.recipes.IronWorkbenchRecipe;
import ihl.recipes.RecipeInputDetonator;
import ihl.recipes.RecipeInputDie;
import ihl.recipes.RecipeInputObjectInstance;
import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;

public class IronWorkbenchTileEntity
extends TileEntityInventory
implements IHasGui,
INetworkClientTileEntityEventListener,
INetworkTileEntityEventListener {
    public static List<IronWorkbenchRecipe> recipes = new ArrayList<IronWorkbenchRecipe>();
    public int progress;
    public int currentSlot = -1;
    public final int maxProgress;
    public final InvSlotTool tools;
    public final InvSlotWorkspaceElement workspaceElements;
    public final InvSlotProcessableIronWorkbench inputMaterial;
    public final InvSlotOutputInProgress output;
    public boolean isGuiScreenOpened = false;
    private boolean startProcess = false;
    private boolean outputDefined = false;
    private EntityPlayer crafter;
    public ContainerBase<?> container;
    private Map<Integer, IronWorkbenchRecipe> slotRecipeMap = new HashMap<Integer, IronWorkbenchRecipe>();
    private boolean firstTick = true;

    public IronWorkbenchTileEntity() {
        this.maxProgress = 80;
        this.workspaceElements = new InvSlotWorkspaceElement(this, "workspaceElements", 3, InvSlot.Access.NONE, 6);
        this.tools = new InvSlotTool(this, "tools", 0, InvSlot.Access.IO, 12);
        this.inputMaterial = new InvSlotProcessableIronWorkbench(this, "input", 1, InvSlot.Access.IO, 12);
        this.output = new InvSlotOutputInProgress(this, "output", 2, 18);
    }

    public static void addRecipe(IronWorkbenchRecipe recipe) {
        recipes.add(recipe);
    }

    public String func_145825_b() {
        return "ironWorkbench";
    }

    public ItemStack getWrenchDrop(EntityPlayer player) {
        return IHLUtils.getThisModItemStack("ironWorkbench");
    }

    @SideOnly(value=Side.CLIENT)
    public void updateEntityClient() {
        if (this.firstTick) {
            IHLMod.proxy.requestTileEntityInitdataFromClientToServer(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.firstTick = false;
        }
    }

    public void updateEntityServer() {
        if (this.isGuiScreenOpened) {
            if (this.output.isEmpty() && !this.outputDefined) {
                this.workspaceElements.reset();
                for (IronWorkbenchRecipe recipe : recipes) {
                    if (!recipe.isCanBeCrafted(this.tools.getItemStackList(), this.inputMaterial.getItemStackList(), this.workspaceElements.getItemStackList()) || recipe.workspaceElements != null && !recipe.workspaceElements.isEmpty() && !this.workspaceElements.containsAndCanUse(recipe.workspaceElements)) continue;
                    List<ItemStack> newOutputs = recipe.outputs;
                    for (IRecipeInput rinput : recipe.tools) {
                        if (!(rinput instanceof RecipeInputDie)) continue;
                        newOutputs = ((RecipeInputDie)rinput).transformOutput(this.getMatchedItemStack(rinput), recipe.outputs);
                    }
                    for (IRecipeInput rinput : recipe.materials) {
                        if (!(rinput instanceof RecipeInputDetonator)) continue;
                        newOutputs = ((RecipeInputDetonator)rinput).transformOutput(this.getMatchedItemStack(rinput), recipe.outputs);
                    }
                    short slot = this.output.put(newOutputs);
                    if (slot < 0) break;
                    this.slotRecipeMap.put(Integer.valueOf(slot), recipe);
                    this.startProcess = false;
                }
                for (int i = 0; i < this.inputMaterial.size(); ++i) {
                    ItemStack stack = this.inputMaterial.get(i);
                    if (stack == null || !(stack.func_77973_b() instanceof IWire)) continue;
                    if (stack.field_77990_d == null) {
                        stack.field_77990_d = new NBTTagCompound();
                    }
                    int fullLength = this.getFullLengthOfSameWires(stack);
                    List<RecipeInputObjectInstance> list = this.getListOfSameWires(stack);
                    ItemStack result = stack.func_77946_l();
                    result.field_77990_d.func_74768_a("length", fullLength);
                    result.field_77990_d.func_74768_a("fullLength", fullLength);
                    IronWorkbenchRecipe recipe = new IronWorkbenchRecipe(null, list, Arrays.asList(result));
                    short slot = this.output.put(recipe.outputs);
                    if (slot < 0) break;
                    this.slotRecipeMap.put(Integer.valueOf(slot), recipe);
                    this.startProcess = false;
                    break;
                }
                this.outputDefined = true;
            } else if (!this.output.isEmpty()) {
                Set<Integer> crafterEmptyInventorySlotsList = this.getCrafterEmptyInventorySlotsList();
                if (this.startProcess && crafterEmptyInventorySlotsList.size() >= this.slotRecipeMap.get((Object)Integer.valueOf((int)this.currentSlot)).outputs.size() && ++this.progress >= this.maxProgress) {
                    IronWorkbenchRecipe crecipe = this.slotRecipeMap.get(this.currentSlot);
                    List<ItemStack> opts = this.output.getRecipeOutputs(this.currentSlot);
                    int multiplier = this.inputMaterial.getMultiplier(crecipe.materials);
                    Iterator<ItemStack> optsi = opts.iterator();
                    Iterator<Integer> emptySlotsIterator = crafterEmptyInventorySlotsList.iterator();
                    while (optsi.hasNext()) {
                        int slot = emptySlotsIterator.next();
                        ItemStack stack = optsi.next();
                        if (stack.func_77973_b() instanceof IWire) {
                            this.crafter.field_71071_by.field_70462_a[slot] = IHLUtils.getWireItemStackCopyWithLengthMultiplied(stack, multiplier);
                            continue;
                        }
                        this.crafter.field_71071_by.field_70462_a[slot] = stack.func_77946_l();
                        this.crafter.field_71071_by.field_70462_a[slot].field_77994_a *= multiplier;
                    }
                    Iterator<ItemStack> emptyContainers = this.inputMaterial.substract(crecipe.materials, multiplier).iterator();
                    while (emptyContainers.hasNext()) {
                        if (emptySlotsIterator.hasNext()) {
                            int slot = emptySlotsIterator.next();
                            ItemStack stack = emptyContainers.next();
                            this.crafter.field_71071_by.field_70462_a[slot] = stack.func_77946_l();
                            this.crafter.field_71071_by.field_70462_a[slot].field_77994_a *= multiplier;
                            continue;
                        }
                        EntityItem eistack = new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, emptyContainers.next());
                        this.field_145850_b.func_72838_d((Entity)eistack);
                    }
                    this.crafter.field_71069_bz.func_75142_b();
                    this.tools.damage(crecipe.tools);
                    if (!crecipe.workspaceElements.isEmpty()) {
                        this.workspaceElements.use(crecipe.workspaceElements);
                    }
                    this.resetOutput();
                }
            }
        }
    }

    private ItemStack getMatchedItemStack(IRecipeInput rinput) {
        for (ItemStack tool : this.tools.getItemStackList()) {
            if (!rinput.matches(tool)) continue;
            return tool;
        }
        for (ItemStack material : this.inputMaterial.getItemStackList()) {
            if (!rinput.matches(material)) continue;
            return material;
        }
        return null;
    }

    private Set<Integer> getCrafterEmptyInventorySlotsList() {
        HashSet<Integer> list = new HashSet<Integer>(4);
        if (this.crafter != null) {
            for (int var1 = 0; var1 < this.crafter.field_71071_by.field_70462_a.length; ++var1) {
                if (this.crafter.field_71071_by.field_70462_a[var1] != null) continue;
                list.add(var1);
            }
        }
        return list;
    }

    private List<RecipeInputObjectInstance> getListOfSameWires(ItemStack stack1) {
        ArrayList<RecipeInputObjectInstance> list = new ArrayList<RecipeInputObjectInstance>();
        for (int i = 0; i < this.inputMaterial.size(); ++i) {
            ItemStack stack = this.inputMaterial.get(i);
            if (stack == null || !((IWire)stack1.func_77973_b()).isSameWire(stack1, stack)) continue;
            list.add(new RecipeInputObjectInstance(stack));
        }
        return list;
    }

    private int getFullLengthOfSameWires(ItemStack stack1) {
        int fullLength = 0;
        for (int i = 0; i < this.inputMaterial.size(); ++i) {
            ItemStack stack = this.inputMaterial.get(i);
            if (stack == null || !((IWire)stack1.func_77973_b()).isSameWire(stack1, stack)) continue;
            fullLength += IHLUtils.getWireLength(stack);
        }
        return fullLength;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean arg1) {
        return new IronWorkbenchGui(new IronWorkbenchContainer(player, this));
    }

    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        this.resetOutput();
        this.isGuiScreenOpened = true;
        this.crafter = player;
        this.container = new IronWorkbenchContainer(player, this);
        return this.container;
    }

    public void onGuiClosed(EntityPlayer arg0) {
        this.isGuiScreenOpened = false;
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        if (event == 16) {
            this.isGuiScreenOpened = false;
            this.crafter = null;
            this.container = null;
            return;
        }
        for (int i = event; i >= 0; --i) {
            if (!this.slotRecipeMap.containsKey(i)) continue;
            if (!this.slotRecipeMap.get(i).isCanBeCrafted(this.tools.getItemStackList(), this.inputMaterial.getItemStackList(), this.workspaceElements.getItemStackList())) {
                this.resetOutput();
                continue;
            }
            this.currentSlot = i;
            this.startProcess = true;
            return;
        }
    }

    public void resetOutput() {
        this.output.clear();
        this.slotRecipeMap.clear();
        this.progress = 0;
        this.startProcess = false;
        this.currentSlot = -1;
        this.outputDefined = false;
    }

    public void dropContents() {
        int i;
        for (i = 0; i < this.tools.size(); ++i) {
            if (this.tools.get(i) == null) continue;
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.tools.get(i)));
        }
        for (i = 0; i < this.inputMaterial.size(); ++i) {
            if (this.inputMaterial.get(i) == null) continue;
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.inputMaterial.get(i)));
        }
    }

    public void onNetworkEvent(int event) {
    }

    public int gaugeProgressScaled(int i) {
        return this.progress * i / this.maxProgress;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }

    public static void removeRecipeByOutput(List<ItemStack> recipeOutputsItems) {
        Iterator<IronWorkbenchRecipe> ri = recipes.iterator();
        while (ri.hasNext()) {
            IronWorkbenchRecipe recipe = ri.next();
            boolean removeEntry = false;
            Iterator<ItemStack> roi = recipe.outputs.iterator();
            while (roi.hasNext()) {
                if (!IHLUtils.isItemStacksIsEqual(recipeOutputsItems.get(0), roi.next(), true)) continue;
                removeEntry = true;
            }
            if (!removeEntry) continue;
            ri.remove();
        }
    }

    public static void removeRecipeByInput(List<IRecipeInput> recipeInputsTools1, List<IRecipeInput> recipeInputsItems1, List<ItemStack> recipeInputsMachines) {
        List<ItemStack> recipeInputsTools = IHLUtils.convertRecipeInputToItemStackList(recipeInputsTools1);
        List<ItemStack> recipeInputsItems = IHLUtils.convertRecipeInputToItemStackList(recipeInputsItems1);
        Iterator<IronWorkbenchRecipe> ri = recipes.iterator();
        while (ri.hasNext()) {
            IronWorkbenchRecipe recipe = ri.next();
            if (!recipe.isCanBeCrafted(recipeInputsTools, recipeInputsItems, recipeInputsMachines)) continue;
            ri.remove();
        }
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

