/*
 * Decompiled with CFR 0.152.
 */
package ihl.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ihl.items_blocks.FlexibleCableItem;
import ihl.model.ModelTube;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class FlexibleCableItemRender
implements IItemRenderer {
    private ModelTube model;
    private ModelTube modelThin;
    private ModelTube modelLong;
    private ModelTube modelThinLong;
    private final int segmentsAmount = 19;
    private final float spiralStepAngle = 1.0f;
    private final float scale = 0.03125f;
    private final int[] displayListCache = new int[4];

    public FlexibleCableItemRender() {
        float vOffset = 16.0f;
        int longFragmensSize = 24;
        this.model = new ModelTube(null, 0, 0, -2.0f, -3.0f, -2.0f + vOffset, 4, 6, 4, 0.0f, 0.5f, 0.99f, ForgeDirection.UP);
        this.modelLong = new ModelTube(null, 0, 0, -2.0f, -3.0f, -2.0f + vOffset, 4, longFragmensSize, 4, 0.0f, 0.0f, 0.99f, ForgeDirection.UP);
        this.modelThin = new ModelTube(null, 0, 0, -1.0f, -3.0f, -1.0f + vOffset, 2, 6, 2, 0.0f, 0.5f, 0.99f, ForgeDirection.UP);
        this.modelThinLong = new ModelTube(null, 0, 0, -1.0f, -3.0f, -1.0f + vOffset, 2, longFragmensSize, 2, 0.0f, 0.5f, 0.99f, ForgeDirection.UP);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: {
                return true;
            }
            case EQUIPPED: {
                return true;
            }
            case EQUIPPED_FIRST_PERSON: {
                return true;
            }
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        switch (type) {
            case ENTITY: {
                GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
                this.rendercoil(stack);
                break;
            }
            case EQUIPPED: {
                GL11.glTranslatef((float)0.25f, (float)-2.0f, (float)-0.75f);
                this.rendercoil(stack);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                EntityClientPlayerMP var3 = Minecraft.func_71410_x().field_71439_g;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(var3.func_110306_p());
                RenderPlayer var25 = (RenderPlayer)RenderManager.field_78727_a.func_78713_a((Entity)Minecraft.func_71410_x().field_71439_g);
                GL11.glRotatef((float)135.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)35.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                var25.func_82441_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                GL11.glRotatef((float)-35.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)-135.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)0.2f, (float)0.0f);
                GL11.glTranslatef((float)-0.25f, (float)-1.0f, (float)0.0f);
                this.rendercoil(stack);
                break;
            }
            case INVENTORY: {
                GL11.glTranslatef((float)0.0f, (float)-0.2f, (float)0.0f);
                this.rendercoil(stack);
                break;
            }
        }
        GL11.glPopMatrix();
    }

    private void rendercoil(ItemStack stack) {
        int type = this.getCableType(stack);
        if (this.displayListCache[type] != 0) {
            GL11.glCallList((int)this.displayListCache[type]);
        } else {
            this.displayListCache[type] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)this.displayListCache[type], (int)4864);
            GL11.glDisable((int)3553);
            int saMax = this.segmentsAmount * 2 + this.segmentsAmount / 2;
            for (int i = 0; i <= saMax; ++i) {
                GL11.glRotatef((float)-1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.getClass();
                GL11.glRotatef((float)(360.0f / 19.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.004f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                if (i == 0) {
                    if (this.isNoInsulation(stack)) {
                        if (FlexibleCableItem.instance.yellowColoredWires.contains(FlexibleCableItem.instance.getMaterial(stack))) {
                            GL11.glColor3f((float)1.0f, (float)0.75f, (float)0.1f);
                        } else {
                            GL11.glColor3f((float)0.65f, (float)0.65f, (float)0.67f);
                        }
                        this.modelThinLong.render(Tessellator.field_78398_a, 0.03125f);
                        continue;
                    }
                    this.modelLong.render(Tessellator.field_78398_a, 0.03125f);
                    continue;
                }
                if (i == saMax) {
                    GL11.glTranslatef((float)0.0f, (float)-0.55f, (float)0.0f);
                    if (this.isNoInsulation(stack)) {
                        if (FlexibleCableItem.instance.yellowColoredWires.contains(FlexibleCableItem.instance.getMaterial(stack))) {
                            GL11.glColor3f((float)1.0f, (float)0.75f, (float)0.1f);
                        } else {
                            GL11.glColor3f((float)0.65f, (float)0.65f, (float)0.67f);
                        }
                        this.modelThinLong.render(Tessellator.field_78398_a, 0.03125f);
                    } else {
                        this.modelLong.render(Tessellator.field_78398_a, 0.03125f);
                    }
                    GL11.glTranslatef((float)0.0f, (float)0.55f, (float)0.0f);
                    continue;
                }
                if (this.isNoInsulation(stack)) {
                    if (FlexibleCableItem.instance.yellowColoredWires.contains(FlexibleCableItem.instance.getMaterial(stack))) {
                        GL11.glColor3f((float)1.0f, (float)0.75f, (float)0.1f);
                    } else {
                        GL11.glColor3f((float)0.65f, (float)0.65f, (float)0.67f);
                    }
                    this.modelThin.render(Tessellator.field_78398_a, 0.03125f);
                    continue;
                }
                this.model.render(Tessellator.field_78398_a, 0.03125f);
            }
            GL11.glEnable((int)3553);
            GL11.glEndList();
        }
    }

    private int getCableType(ItemStack stack) {
        if (this.isNoInsulation(stack)) {
            if (FlexibleCableItem.instance.yellowColoredWires.contains(FlexibleCableItem.instance.getMaterial(stack))) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    private boolean isNoInsulation(ItemStack stack) {
        return stack.field_77990_d != null && FlexibleCableItem.instance.getInsulationMaterial(stack).equals("null");
    }
}

