/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.metallurgy;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.recipe.IRecipeInput;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.block.invslot.InvSlot;
import ic2.core.network.NetworkManager;
import ihl.processing.chemistry.ApparatusProcessableInvSlot;
import ihl.processing.invslots.IHLInvSlotOutput;
import ihl.processing.metallurgy.BasicElectricMotorTileEntity;
import ihl.processing.metallurgy.RollingMachineContainer;
import ihl.processing.metallurgy.RollingMachineGui;
import ihl.processing.metallurgy.RollingMachinePart2TileEntity;
import ihl.recipes.RecipeOutputItemStack;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import ihl.utils.IHLUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class RollingMachinePart1TileEntity
extends BasicElectricMotorTileEntity {
    public final ApparatusProcessableInvSlot input = new ApparatusProcessableInvSlot(this, "input", 1, InvSlot.Access.IO, 1, 64);
    public final IHLInvSlotOutput output = new IHLInvSlotOutput(this, "output", 2, 1);
    public boolean assembled;
    protected static final UniversalRecipeManager recipeManager = new UniversalRecipeManager("rollingmachine");

    public UniversalRecipeOutput getOutput() {
        return recipeManager.getOutputFor(this.getInput());
    }

    public List<String> getNetworkedFields() {
        List fields = super.getNetworkedFields();
        fields.add("assembled");
        return fields;
    }

    @Override
    public String func_145825_b() {
        return "RollingMachine";
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.assembled && !this.checkCorrectAccembly()) {
            this.assembled = false;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "assembled");
        } else if (!this.assembled && this.checkCorrectAccembly()) {
            this.assembled = true;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "assembled");
        }
        if (this.getActive() && this.progress == 0 && !this.canOperate()) {
            this.setActive(false);
        }
        if (!this.getActive() && this.progress > 0 && this.canOperate()) {
            this.setActive(true);
        }
    }

    public ItemStack getWrenchDrop(EntityPlayer player) {
        return IHLUtils.getThisModItemStack("rollingMachinePart1");
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean arg1) {
        return new RollingMachineGui(new RollingMachineContainer(player, this));
    }

    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        return new RollingMachineContainer(player, this);
    }

    @Override
    public void operate() {
        List<IRecipeInput> rinput = recipeManager.getRecipeInput(this.getInput()).getItemInputs();
        List<RecipeOutputItemStack> output = recipeManager.getOutputFor(this.getInput()).getItemOutputs();
        this.output.add(output);
        this.input.consume(rinput.get(0));
    }

    public List[] getInput() {
        return new List[]{null, Arrays.asList(this.input.get())};
    }

    @Override
    public boolean canOperate() {
        return this.getOutput() != null && this.output.canAdd(this.getOutput().getItemOutputs()) && this.checkCorrectAccembly();
    }

    private boolean checkCorrectAccembly() {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + ForgeDirection.getOrientation((int)this.getFacing()).offsetX, this.field_145848_d + ForgeDirection.getOrientation((int)this.getFacing()).offsetY, this.field_145849_e + ForgeDirection.getOrientation((int)this.getFacing()).offsetZ);
        return te != null && te instanceof RollingMachinePart2TileEntity && ((RollingMachinePart2TileEntity)te).getFacing() == this.getFacing();
    }

    @Override
    public void onGuiClosed(EntityPlayer arg0) {
    }

    public static void addRecipe(ItemStack input, ItemStack output) {
        recipeManager.addRecipe(new UniversalRecipeInput(null, new ItemStack[]{input}), new UniversalRecipeOutput(null, new ItemStack[]{output}, 20));
    }

    public static Map<UniversalRecipeInput, UniversalRecipeOutput> getRecipes() {
        return recipeManager.getRecipes();
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }
}

