/*
 * Decompiled with CFR 0.152.
 */
package ihl.tunneling_shield;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.audio.PositionSpec;
import ic2.core.item.tool.ItemToolWrench;
import ihl.IHLMod;
import ihl.tunneling_shield.DriverTileEntity;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class HorizontalMiningPipe
extends Block {
    public static ArrayList<DriverTileEntity> teList = new ArrayList();

    public HorizontalMiningPipe() {
        super(Material.field_151573_f);
        this.func_149676_a(0.1875f, 0.1875f, 0.1875f, 0.8125f, 0.8125f, 0.8125f);
    }

    public HorizontalMiningPipe(int meta) {
        super(Material.field_151573_f);
        this.func_149676_a(0.1875f * (float)meta, 0.1875f, 0.1875f * (float)(1 - meta), 0.8125f + 0.1875f * (float)(1 - meta), 0.8125f, 0.8125f + 0.1875f * (float)meta);
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return true;
    }

    public Item func_149694_d(World world, int x, int y, int z) {
        return Ic2Items.miningPipe.func_77973_b();
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return Ic2Items.miningPipe.func_77973_b();
    }

    public void func_149690_a(World world, int x, int y, int z, int meta, float chance, int flag) {
        ItemStack result = Ic2Items.miningPipe;
        result.field_77994_a = 1;
        this.func_149642_a(world, x, y, z, result);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("ic2:machine/blockMiningPipe");
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        return this.field_149761_L;
    }

    public int func_149645_b() {
        return -2;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion explosion) {
        super.func_149723_a(world, x, y, z, explosion);
        this.checkIfMachinePart(world, x, y, z);
    }

    public void func_149664_b(World world, int x, int y, int z, int meta) {
        super.func_149664_b(world, x, y, z, meta);
        this.checkIfMachinePart(world, x, y, z);
    }

    private void checkIfMachinePart(World world, int x, int y, int z) {
        if (teList.size() > 0) {
            for (int i = 0; i < teList.size(); ++i) {
                if (teList.get(i) != null && !teList.get(i).isInvalid()) {
                    if (!teList.get(i).isShaftCoord(x, y, z)) continue;
                    return;
                }
                teList.remove(i);
                --i;
            }
        }
    }

    private void checkIfMachinePartNN(World world, int x, int y, int z) {
        boolean setToAir = true;
        if (teList.size() > 0) {
            for (int i = 0; i < teList.size(); ++i) {
                if (teList.get(i) != null) {
                    if (!teList.get(i).isShaftCoordNN(x, y, z) || !HorizontalMiningPipe.teList.get((int)i).hasShield) continue;
                    setToAir = false;
                    continue;
                }
                teList.remove(i);
                --i;
            }
        }
        if (setToAir) {
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.func_149674_a(world, x, y, z, world.field_73012_v);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        this.checkIfMachinePartNN(world, x, y, z);
    }

    public int func_149738_a(World world) {
        return 200;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int i, float pos_x, float pos_y, float pos_z) {
        ItemStack currentIS = entityPlayer.field_71071_by.func_70448_g();
        if (currentIS != null && currentIS.func_77973_b() instanceof ItemToolWrench && entityPlayer.field_71071_by.func_146028_b(Ic2Items.miningPipe.func_77973_b())) {
            if (((ItemToolWrench)currentIS.func_77973_b()).canTakeDamage(currentIS, 10)) {
                if (IC2.platform.isRendering()) {
                    IC2.audioManager.playOnce((Object)entityPlayer, PositionSpec.Hand, "Tools/wrench.ogg", true, 1.0f);
                }
                if (IC2.platform.isSimulating()) {
                    if (teList.size() > 0) {
                        for (int i3 = 0; i3 < teList.size(); ++i3) {
                            DriverTileEntity t = teList.get(i3);
                            if (t != null) {
                                if (!t.isShaftCoordNN(x, y, z) || !t.hasShield) continue;
                                int xA = t.xCoord + t.shaftDestroyedAtA * t.mX();
                                int zA = t.zCoord + t.shaftDestroyedAtA * t.mZ();
                                int xB = t.xCoord + t.shaftDestroyedAtB * t.mX();
                                int zB = t.zCoord + t.shaftDestroyedAtB * t.mZ();
                                if (t.shaftDestroyedAtA != 0 && t.shaftDestroyedAtA == t.shaftDestroyedAtB) {
                                    if (Math.abs(x - xA + z - zA) != 1 || !world.func_147449_b(xA, y, zA, t.mX() != 0 ? IHLMod.horizontalMiningPipeZ : IHLMod.horizontalMiningPipeX)) continue;
                                    t.shaftDestroyedAtB = 0;
                                    t.shaftDestroyedAtA = 0;
                                    entityPlayer.field_71071_by.func_146026_a(Ic2Items.miningPipe.func_77973_b());
                                    entityPlayer.field_71069_bz.func_75142_b();
                                    return true;
                                }
                                if (t.shaftDestroyedAtA == 0) continue;
                                if (Math.abs(x - xA + z - zA) == 1 && world.func_147449_b(xA, y, zA, t.mX() != 0 ? IHLMod.horizontalMiningPipeZ : IHLMod.horizontalMiningPipeX)) {
                                    ++t.shaftDestroyedAtA;
                                    entityPlayer.field_71071_by.func_146026_a(Ic2Items.miningPipe.func_77973_b());
                                    entityPlayer.field_71069_bz.func_75142_b();
                                    return true;
                                }
                                if (Math.abs(x - xB + z - zB) != 1 || !world.func_147449_b(xB, y, zB, t.mX() != 0 ? IHLMod.horizontalMiningPipeZ : IHLMod.horizontalMiningPipeX)) continue;
                                --t.shaftDestroyedAtB;
                                entityPlayer.field_71071_by.func_146026_a(Ic2Items.miningPipe.func_77973_b());
                                entityPlayer.field_71069_bz.func_75142_b();
                                return true;
                            }
                            teList.remove(i);
                            --i;
                        }
                    }
                    ((ItemToolWrench)currentIS.func_77973_b()).damage(currentIS, 10, entityPlayer);
                }
            }
            return true;
        }
        return false;
    }
}

