/*
 * Decompiled with CFR 0.152.
 */
package ihl.flexible_cable;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.core.ExplosionIC2;
import ic2.core.IC2;
import ic2.core.block.TileEntityBlock;
import ic2.core.network.NetworkManager;
import ihl.flexible_cable.SubAnchorEnergyNetNode;
import ihl.interfaces.IEnergyNetNode;
import ihl.interfaces.IMultiPowerCableHolder;
import ihl.utils.IHLUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class AnchorTileEntity
extends TileEntityBlock
implements IEnergySink,
IEnergySource,
IMultiPowerCableHolder {
    public boolean addedToEnergyNet = false;
    public final Set<TileEntity> sacrifices = new HashSet<TileEntity>();
    public SubAnchorEnergyNetNode[] energyNetNodes = new SubAnchorEnergyNetNode[6];
    public boolean[] hasCableOnSide = new boolean[]{false, false, false, false, false, false};
    public int checksum = -1;
    public boolean checkCables = true;

    public AnchorTileEntity() {
        for (short i = 0; i < 6; i = (short)(i + 1)) {
            this.energyNetNodes[i] = new SubAnchorEnergyNetNode(this, i);
        }
    }

    public List<String> getNetworkedFields() {
        List fields = super.getNetworkedFields();
        fields.add("hasCableOnSide");
        return fields;
    }

    public void onLoaded() {
        super.onLoaded();
        for (int i = 0; i < 6; i = (int)((short)(i + 1))) {
            this.energyNetNodes[i].onLoaded();
        }
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
    }

    public boolean wrenchCanRemove(EntityPlayer var1) {
        return false;
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void updateEntityServer() {
        if (!this.sacrifices.isEmpty()) {
            for (TileEntity sacrifice : this.sacrifices) {
                ExplosionIC2 explosion = new ExplosionIC2(this.field_145850_b, null, (double)sacrifice.field_145851_c + 0.5, (double)sacrifice.field_145848_d + 0.5, (double)sacrifice.field_145849_e + 0.5, 3.0f, 0.3f, ExplosionIC2.Type.Normal, null, 0);
                explosion.doExplosion();
                this.sacrifices.remove(sacrifice);
            }
        }
        int newchecksum = 0;
        for (int i = 0; i < 6; i = (int)((short)(i + 1))) {
            if (!this.hasCableOnSide[i]) continue;
            ++newchecksum;
        }
        if (newchecksum != this.checksum) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "hasCableOnSide");
            this.checksum = newchecksum;
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList energyNetNodeNBTList = new NBTTagList();
        for (SubAnchorEnergyNetNode node : this.energyNetNodes) {
            energyNetNodeNBTList.func_74742_a((NBTBase)node.writeToNBT());
        }
        nbt.func_74782_a("energyNetNodes", (NBTBase)energyNetNodeNBTList);
        nbt.func_74757_a("checkCables", this.checkCables);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (!nbt.func_74764_b("energyNetNodes")) {
            short facing = nbt.func_74765_d("facing");
            int gridID = nbt.func_74762_e("gridID");
            this.energyNetNodes[facing].setGrid(gridID);
            NBTTagList cableNBTList = nbt.func_150295_c("cableList", 10);
            for (int i = 0; i < cableNBTList.func_74745_c(); ++i) {
                this.energyNetNodes[facing].addCable(cableNBTList.func_150305_b(i));
            }
        } else {
            NBTTagList energyNetNodeNBTList = nbt.func_150295_c("energyNetNodes", 10);
            for (int i = 0; i < 6; ++i) {
                this.energyNetNodes[i].readFromNBT(energyNetNodeNBTList.func_150305_b(i));
            }
        }
        this.checkCables = nbt.func_74767_n("checkCables");
    }

    public void setFacing(short facing) {
        this.energyNetNodes[facing].removeAttachedChains();
        boolean removeTE = true;
        for (int i = 0; i < 6; i = (int)((short)(i + 1))) {
            if (this.energyNetNodes[i].getCableList().isEmpty()) continue;
            removeTE = false;
        }
        if (removeTE) {
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        switch (direction) {
            case UP: {
                return this.energyNetNodes[0].getGridID() != -1;
            }
            case DOWN: {
                return this.energyNetNodes[1].getGridID() != -1;
            }
            case SOUTH: {
                return this.energyNetNodes[2].getGridID() != -1;
            }
            case NORTH: {
                return this.energyNetNodes[3].getGridID() != -1;
            }
            case EAST: {
                return this.energyNetNodes[4].getGridID() != -1;
            }
            case WEST: {
                return this.energyNetNodes[5].getGridID() != -1;
            }
        }
        return false;
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return this.acceptsEnergyFrom(receiver, direction);
    }

    public double getOfferedEnergy() {
        double offeredEnergy = 0.0;
        for (int i = 0; i < 6; i = (int)((short)(i + 1))) {
            offeredEnergy += this.energyNetNodes[i].getEnergyOfferedByGrid();
        }
        return offeredEnergy;
    }

    public void drawEnergy(double amount) {
        for (int i = 0; i < 6; i = (int)((short)(i + 1))) {
            amount -= this.energyNetNodes[i].drawEnergyFromGrid(amount);
            double voltage = this.energyNetNodes[i].getVoltage();
            if (voltage > 500.0) {
                HashSet<TileEntity> teset = new HashSet<TileEntity>();
                ForgeDirection direction = ForgeDirection.getOrientation((int)i).getOpposite();
                TileEntity te = EnergyNet.instance.getNeighbor((TileEntity)this, direction);
                teset.add(te);
                TileEntity te1 = this.getSink(te, teset);
                if (te1 instanceof IEnergyNetNode && ((IEnergyNetNode)te1).getMaxAllowableVoltage() >= voltage) {
                    return;
                }
                if (te1 != null) {
                    this.sacrifices.add(te1);
                }
            }
            if (amount <= 0.0) break;
        }
    }

    public int getSourceTier() {
        return 4;
    }

    public double getDemandedEnergy() {
        double amount = 0.0;
        for (int i = 0; i < 6; i = (int)((short)(i + 1))) {
            amount += this.energyNetNodes[i].getDemandedEnergy();
        }
        return amount;
    }

    public int getSinkTier() {
        return 4;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        switch (directionFrom) {
            case UP: {
                return this.energyNetNodes[0].injectEnergyToGrid(amount);
            }
            case DOWN: {
                return this.energyNetNodes[1].injectEnergyToGrid(amount);
            }
            case SOUTH: {
                return this.energyNetNodes[2].injectEnergyToGrid(amount);
            }
            case NORTH: {
                return this.energyNetNodes[3].injectEnergyToGrid(amount);
            }
            case EAST: {
                return this.energyNetNodes[4].injectEnergyToGrid(amount);
            }
            case WEST: {
                return this.energyNetNodes[5].injectEnergyToGrid(amount);
            }
        }
        return amount;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return null;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return !this.wrenchCanRemove(entityPlayer);
    }

    public TileEntity getSink(TileEntity te, Set<TileEntity> teset) {
        teset.add(te);
        while (te != null && !(te instanceof IEnergySink)) {
            TileEntity te2;
            TileEntity te1 = EnergyNet.instance.getNeighbor(te, ForgeDirection.NORTH);
            if (te1 == null || teset.contains(te1)) {
                te1 = EnergyNet.instance.getNeighbor(te, ForgeDirection.SOUTH);
            } else {
                te2 = this.getSink(te1, teset);
                if (te2 != null) {
                    return te2;
                }
            }
            if (te1 == null || teset.contains(te1)) {
                te1 = EnergyNet.instance.getNeighbor(te, ForgeDirection.UP);
            } else {
                te2 = this.getSink(te1, teset);
                if (te2 != null) {
                    return te2;
                }
            }
            if (te1 == null || teset.contains(te1)) {
                te1 = EnergyNet.instance.getNeighbor(te, ForgeDirection.DOWN);
            } else {
                te2 = this.getSink(te1, teset);
                if (te2 != null) {
                    return te2;
                }
            }
            if (te1 == null || teset.contains(te1)) {
                te1 = EnergyNet.instance.getNeighbor(te, ForgeDirection.WEST);
            } else {
                te2 = this.getSink(te1, teset);
                if (te2 != null) {
                    return te2;
                }
            }
            if (te1 == null || teset.contains(te1)) {
                te1 = EnergyNet.instance.getNeighbor(te, ForgeDirection.EAST);
            } else {
                te2 = this.getSink(te1, teset);
                if (te2 != null) {
                    return te2;
                }
            }
            if (te1 != null) {
                teset.add(te1);
            }
            te = te1;
        }
        if (te instanceof IEnergySink) {
            return te;
        }
        return null;
    }

    public void checkIfNoCablesLeft() {
        boolean noCables = true;
        for (SubAnchorEnergyNetNode sen : this.energyNetNodes) {
            if (sen.getCableList().isEmpty()) continue;
            noCables = false;
        }
        if (noCables) {
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public boolean isCableRemoved(int chainUniqueID) {
        if (!this.checkCables) {
            return false;
        }
        for (SubAnchorEnergyNetNode sen : this.energyNetNodes) {
            if (sen.isCableRemoved(chainUniqueID)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IEnergyNetNode getEnergyNetNode(short facing) {
        return this.energyNetNodes[facing];
    }

    @Override
    public short getSide(EntityPlayer player) {
        return IHLUtils.getFacingFromPlayerView((EntityLivingBase)player, true);
    }

    @Override
    public void removeAttachedChains() {
        for (int i = 0; i < 6; i = (int)((short)(i + 1))) {
            this.energyNetNodes[i].removeAttachedChains();
        }
    }
}

