/*
 * Decompiled with CFR 0.152.
 */
package ihl.flexible_cable;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.IC2;
import ic2.core.block.TileEntityInventory;
import ic2.core.network.NetworkManager;
import ihl.flexible_cable.SubRTUEnergyNetNode;
import ihl.interfaces.IEnergyNetNode;
import ihl.interfaces.IMultiPowerCableHolder;
import ihl.utils.IHLUtils;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class RectifierTransformerUnitTileEntity
extends TileEntityInventory
implements INetworkClientTileEntityEventListener,
IEnergySink,
IMultiPowerCableHolder {
    public boolean addedToEnergyNet = false;
    public SubRTUEnergyNetNode[] energyNetNodes = new SubRTUEnergyNetNode[2];
    public float mode = 1.0f;
    public static float modeMultiplier = 2.0f;
    public static float modeMax = 128.0f;
    public static float modeMin = 1.0f / modeMax;
    public AxisAlignedBB aabb1;
    public AxisAlignedBB aabb2;
    public AxisAlignedBB aabb1_1;
    public AxisAlignedBB aabb2_1;
    public boolean checkCables = true;

    public RectifierTransformerUnitTileEntity() {
        for (short i = 0; i < 2; i = (short)(i + 1)) {
            this.energyNetNodes[i] = new SubRTUEnergyNetNode(this, i);
        }
        this.aabb1 = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)((double)this.field_145848_d + 1.0), (double)this.field_145849_e, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 1.1), (double)((double)this.field_145849_e + 1.0));
        this.aabb2 = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 1.0), (double)this.field_145849_e, (double)((double)this.field_145851_c + 1.0), (double)((double)this.field_145848_d + 1.1), (double)((double)this.field_145849_e + 1.0));
        this.aabb1_1 = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.2), (double)((double)this.field_145848_d + 1.4), (double)((double)this.field_145849_e + 0.45), (double)((double)this.field_145851_c + 0.3), (double)((double)this.field_145848_d + 1.5), (double)((double)this.field_145849_e + 0.55));
        this.aabb2_1 = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.7), (double)((double)this.field_145848_d + 1.4), (double)((double)this.field_145849_e + 0.45), (double)((double)this.field_145851_c + 0.8), (double)((double)this.field_145848_d + 1.5), (double)((double)this.field_145849_e + 0.55));
    }

    public void onLoaded() {
        super.onLoaded();
        for (int i = 0; i < 2; i = (int)((short)(i + 1))) {
            this.energyNetNodes[i].onLoaded();
        }
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
        this.setupInteractingSpots(this.getFacing());
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public List<String> getNetworkedFields() {
        List fields = super.getNetworkedFields();
        fields.add("mode");
        return fields;
    }

    public void setFacing(short facing1) {
        this.removeAttachedChains();
        short facing2 = (short)Math.max(facing1, 2);
        super.setFacing(facing2);
        this.setupInteractingSpots(facing2);
    }

    public void setupInteractingSpots(short facing2) {
        double yStart = (double)this.field_145848_d + 0.98;
        switch (facing2) {
            case 2: {
                this.aabb1 = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)yStart, (double)this.field_145849_e, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 1.1), (double)((double)this.field_145849_e + 1.0));
                this.aabb2 = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5), (double)yStart, (double)this.field_145849_e, (double)((double)this.field_145851_c + 1.0), (double)((double)this.field_145848_d + 1.1), (double)((double)this.field_145849_e + 1.0));
                this.aabb1_1 = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.2), (double)((double)this.field_145848_d + 1.4), (double)((double)this.field_145849_e + 0.45), (double)((double)this.field_145851_c + 0.3), (double)((double)this.field_145848_d + 1.5), (double)((double)this.field_145849_e + 0.55));
                this.aabb2_1 = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.7), (double)((double)this.field_145848_d + 1.4), (double)((double)this.field_145849_e + 0.45), (double)((double)this.field_145851_c + 0.8), (double)((double)this.field_145848_d + 1.5), (double)((double)this.field_145849_e + 0.55));
                break;
            }
            case 5: {
                this.aabb1 = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)yStart, (double)this.field_145849_e, (double)((double)this.field_145851_c + 1.0), (double)((double)this.field_145848_d + 1.1), (double)((double)this.field_145849_e + 0.5));
                this.aabb2 = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)yStart, (double)((double)this.field_145849_e + 0.5), (double)((double)this.field_145851_c + 1.0), (double)((double)this.field_145848_d + 1.1), (double)((double)this.field_145849_e + 1.0));
                this.aabb1_1 = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.45), (double)((double)this.field_145848_d + 1.4), (double)((double)this.field_145849_e + 0.2), (double)((double)this.field_145851_c + 0.55), (double)((double)this.field_145848_d + 1.5), (double)((double)this.field_145849_e + 0.3));
                this.aabb2_1 = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.45), (double)((double)this.field_145848_d + 1.4), (double)((double)this.field_145849_e + 0.7), (double)((double)this.field_145851_c + 0.55), (double)((double)this.field_145848_d + 1.5), (double)((double)this.field_145849_e + 0.8));
                break;
            }
            case 3: {
                this.aabb2 = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)yStart, (double)this.field_145849_e, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 1.1), (double)((double)this.field_145849_e + 1.0));
                this.aabb1 = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5), (double)yStart, (double)this.field_145849_e, (double)((double)this.field_145851_c + 1.0), (double)((double)this.field_145848_d + 1.1), (double)((double)this.field_145849_e + 1.0));
                this.aabb2_1 = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.2), (double)((double)this.field_145848_d + 1.4), (double)((double)this.field_145849_e + 0.45), (double)((double)this.field_145851_c + 0.3), (double)((double)this.field_145848_d + 1.5), (double)((double)this.field_145849_e + 0.55));
                this.aabb1_1 = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.7), (double)((double)this.field_145848_d + 1.4), (double)((double)this.field_145849_e + 0.45), (double)((double)this.field_145851_c + 0.8), (double)((double)this.field_145848_d + 1.5), (double)((double)this.field_145849_e + 0.55));
                break;
            }
            case 4: {
                this.aabb2 = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)yStart, (double)this.field_145849_e, (double)((double)this.field_145851_c + 1.0), (double)((double)this.field_145848_d + 1.1), (double)((double)this.field_145849_e + 0.5));
                this.aabb1 = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)yStart, (double)((double)this.field_145849_e + 0.5), (double)((double)this.field_145851_c + 1.0), (double)((double)this.field_145848_d + 1.1), (double)((double)this.field_145849_e + 1.0));
                this.aabb2_1 = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.45), (double)((double)this.field_145848_d + 1.4), (double)((double)this.field_145849_e + 0.2), (double)((double)this.field_145851_c + 0.55), (double)((double)this.field_145848_d + 1.5), (double)((double)this.field_145849_e + 0.3));
                this.aabb1_1 = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.45), (double)((double)this.field_145848_d + 1.4), (double)((double)this.field_145849_e + 0.7), (double)((double)this.field_145851_c + 0.55), (double)((double)this.field_145848_d + 1.5), (double)((double)this.field_145849_e + 0.8));
                break;
            }
            default: {
                this.aabb1 = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)yStart, (double)this.field_145849_e, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 1.1), (double)((double)this.field_145849_e + 1.0));
                this.aabb2 = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5), (double)yStart, (double)this.field_145849_e, (double)((double)this.field_145851_c + 1.0), (double)((double)this.field_145848_d + 1.1), (double)((double)this.field_145849_e + 1.0));
                this.aabb1_1 = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.2), (double)((double)this.field_145848_d + 1.4), (double)((double)this.field_145849_e + 0.45), (double)((double)this.field_145851_c + 0.3), (double)((double)this.field_145848_d + 1.5), (double)((double)this.field_145849_e + 0.55));
                this.aabb2_1 = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.7), (double)((double)this.field_145848_d + 1.4), (double)((double)this.field_145849_e + 0.45), (double)((double)this.field_145851_c + 0.8), (double)((double)this.field_145848_d + 1.5), (double)((double)this.field_145849_e + 0.55));
            }
        }
    }

    public ItemStack getWrenchDrop(EntityPlayer player) {
        return IHLUtils.getThisModItemStack("rectifierTransformerUnit");
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != (short)side;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList energyNetNodeNBTList = new NBTTagList();
        for (SubRTUEnergyNetNode node : this.energyNetNodes) {
            energyNetNodeNBTList.func_74742_a((NBTBase)node.writeToNBT());
        }
        nbt.func_74782_a("energyNetNodes", (NBTBase)energyNetNodeNBTList);
        nbt.func_74776_a("mode", this.mode);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList energyNetNodeNBTList = nbt.func_150295_c("energyNetNodes", 10);
        for (int i = 0; i < 2; ++i) {
            this.energyNetNodes[i].readFromNBT(energyNetNodeNBTList.func_150305_b(i));
        }
        this.mode = nbt.func_74760_g("mode");
        this.mode = this.mode == 0.0f ? 1.0f : this.mode;
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        switch (event) {
            default: 
        }
    }

    public void switchModeUp() {
        if (this.mode < modeMax) {
            this.mode *= modeMultiplier;
            if (this.energyNetNodes[1].getGridID() != -1) {
                if (this.energyNetNodes[0].getGridID() != -1) {
                    this.energyNetNodes[1].getGrid().injectEnergy(0.0, this.energyNetNodes[0].getGrid().getSinkVoltage(this.energyNetNodes[0]) * (double)this.mode, this.energyNetNodes[1]);
                } else if (this.energyNetNodes[1].getGrid().energy >= 1.0) {
                    this.energyNetNodes[1].getGrid().injectEnergy(0.0, 400.0 * (double)this.mode, this.energyNetNodes[1]);
                }
            }
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "mode");
        }
    }

    public void switchModeDown() {
        if (this.mode > modeMin) {
            this.mode /= modeMultiplier;
            if (this.energyNetNodes[1].getGridID() != -1) {
                if (this.energyNetNodes[0].getGridID() != -1) {
                    this.energyNetNodes[1].getGrid().injectEnergy(0.0, this.energyNetNodes[0].getGrid().getSinkVoltage(this.energyNetNodes[0]) * (double)this.mode, this.energyNetNodes[1]);
                } else if (this.energyNetNodes[1].getGrid().energy >= 1.0) {
                    this.energyNetNodes[1].getGrid().injectEnergy(0.0, 400.0 * (double)this.mode, this.energyNetNodes[1]);
                }
            }
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "mode");
        }
    }

    public void onNetworkUpdate(String field) {
        if (field.equals("facing") && this.prevFacing != this.getFacing()) {
            this.setupInteractingSpots(this.getFacing());
        }
        super.onNetworkUpdate(field);
    }

    public void updateEntityServer() {
    }

    public String func_145825_b() {
        return "RTU";
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return !direction.equals((Object)ForgeDirection.UP);
    }

    public double getDemandedEnergy() {
        if (this.energyNetNodes[1].getGridID() != -1 && this.energyNetNodes[1].getGrid().energy < 1.0) {
            return 2.147483647E9;
        }
        return 0.0;
    }

    public int getSinkTier() {
        return 4;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.getDemandedEnergy() > 0.0) {
            this.energyNetNodes[1].getGrid().injectEnergy(amount, 400.0 * (double)this.mode, this.energyNetNodes[1]);
            return 0.0;
        }
        return amount;
    }

    @Override
    public boolean isCableRemoved(int chainUniqueID) {
        if (!this.checkCables) {
            return false;
        }
        for (SubRTUEnergyNetNode sen : this.energyNetNodes) {
            if (sen.isCableRemoved(chainUniqueID)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IEnergyNetNode getEnergyNetNode(short facing) {
        return this.energyNetNodes[facing];
    }

    @Override
    public short getSide(EntityPlayer player) {
        if (IHLUtils.isPlayerLookingAt((EntityLivingBase)player, this.aabb1)) {
            return 0;
        }
        if (IHLUtils.isPlayerLookingAt((EntityLivingBase)player, this.aabb2)) {
            return 1;
        }
        return -1;
    }

    @Override
    public void removeAttachedChains() {
        for (int i = 0; i < 2; i = (int)((short)(i + 1))) {
            this.energyNetNodes[i].removeAttachedChains();
        }
    }
}

