/*
 * Decompiled with CFR 0.152.
 */
package ihl.recipes;

import ic2.api.recipe.IRecipeInput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeInputOreDictionaryList
implements IRecipeInput {
    public final String[] input;
    public final int amount;
    public final Integer meta;
    private List<ItemStack> ores;

    public RecipeInputOreDictionaryList(String[] input1) {
        this(input1, 1);
    }

    public RecipeInputOreDictionaryList(String[] input1, int amount1) {
        this(input1, amount1, null);
    }

    public RecipeInputOreDictionaryList(String[] input1, int amount1, Integer meta) {
        this.input = input1;
        this.amount = amount1;
        this.meta = meta;
    }

    public boolean matches(ItemStack subject) {
        List<ItemStack> inputs = this.getOres();
        boolean useOreStackMeta = this.meta == null;
        Item subjectItem = subject.func_77973_b();
        int subjectMeta = subject.func_77960_j();
        Iterator<ItemStack> i$ = inputs.iterator();
        while (true) {
            int metaRequired;
            if (!i$.hasNext()) {
                return false;
            }
            ItemStack oreStack = i$.next();
            Item oreItem = oreStack.func_77973_b();
            if (oreItem == null) continue;
            int n = metaRequired = useOreStackMeta ? oreStack.func_77960_j() : this.meta.intValue();
            if (subjectItem == oreItem && (subjectMeta == metaRequired || metaRequired == Short.MAX_VALUE)) break;
        }
        return true;
    }

    public int getAmount() {
        return this.amount;
    }

    public List<ItemStack> getInputs() {
        List<ItemStack> ores = this.getOres();
        boolean hasInvalidEntries = false;
        for (ItemStack i$ : ores) {
            if (i$.func_77973_b() != null) continue;
            hasInvalidEntries = true;
            break;
        }
        if (!hasInvalidEntries) {
            return ores;
        }
        ArrayList<ItemStack> ret1 = new ArrayList<ItemStack>(ores.size());
        for (ItemStack stack : ores) {
            if (stack.func_77973_b() == null) continue;
            ret1.add(stack);
        }
        return Collections.unmodifiableList(ret1);
    }

    public String toString() {
        return this.meta == null ? "RInputOreDict<" + this.amount + "x" + this.input + ">" : "RInputOreDict<" + this.amount + "x" + this.input + "@" + this.meta + ">";
    }

    private List<ItemStack> getOres() {
        if (this.ores != null) {
            return this.ores;
        }
        this.ores = new ArrayList<ItemStack>();
        for (int i = 0; i < this.input.length; ++i) {
            ArrayList ret = OreDictionary.getOres((String)this.input[i]);
            if (ret == OreDictionary.EMPTY_LIST) continue;
            this.ores.addAll(ret);
        }
        return this.ores;
    }
}

