/*
 * Decompiled with CFR 0.152.
 */
package ihl.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import ihl.IHLMod;
import ihl.utils.IHLUtils;
import ihl.worldgen.WorldGeneratorBase;
import ihl.worldgen.WorldGeneratorSurfaceLake;
import ihl.worldgen.WorldGeneratorUndergroundLake;
import ihl.worldgen.WorldGeneratorVein;
import ihl.worldgen.ores.IHLFluid;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class IHLWorldGenerator
implements IWorldGenerator {
    private static final Block[] replaceableMinerals = new Block[]{Blocks.field_150348_b, Blocks.field_150351_n, Blocks.field_150352_o, Blocks.field_150365_q, Blocks.field_150366_p, Blocks.field_150369_x, Blocks.field_150435_aG, Blocks.field_150482_ag, Blocks.field_150450_ax, Blocks.field_150412_bA};
    private static final Block[] replaceableSand = new Block[]{Blocks.field_150354_m};
    private static final Block[] replaceableForOil = new Block[]{Blocks.field_150353_l, Blocks.field_150356_k, Blocks.field_150343_Z};
    public static IHLWorldGenerator instance;
    private final Set<WorldGeneratorBase> generators = new HashSet<WorldGeneratorBase>(8);

    public IHLWorldGenerator() {
        if (IHLMod.config.generateApatiteOre) {
            this.generators.add(new WorldGeneratorVein(IHLUtils.getOreDictBlock("oreApatite"), replaceableMinerals));
        }
        if (IHLMod.config.generateSaltpeterOre) {
            this.generators.add(new WorldGeneratorVein(IHLUtils.getOreDictBlock("oreSaltpeter"), replaceableMinerals));
        }
        if (IHLMod.config.generateGyubnera) {
            this.generators.add(new WorldGeneratorVein(IHLUtils.getOreDictBlock("oreGyubnera"), replaceableMinerals));
        }
        if (IHLMod.config.generateCinnabar) {
            this.generators.add(new WorldGeneratorVein(IHLUtils.getOreDictBlock("oreCinnabar"), replaceableMinerals));
        }
        if (IHLMod.config.generateRocksalt) {
            this.generators.add(new WorldGeneratorVein(IHLUtils.getOreDictBlock("oreRockSalt"), replaceableMinerals));
        }
        if (IHLMod.config.generateLimestone) {
            this.generators.add(new WorldGeneratorVein(IHLUtils.getOreDictBlock("oreLimestone"), replaceableMinerals));
        }
        if (IHLMod.config.generateGypsum) {
            this.generators.add(new WorldGeneratorVein(IHLUtils.getOreDictBlock("oreGypsum"), replaceableMinerals));
        }
        if (IHLMod.config.generatePotassiumFeldspar) {
            this.generators.add(new WorldGeneratorVein(IHLUtils.getOreDictBlock("orePotassiumFeldspar"), replaceableMinerals));
        }
        if (IHLMod.config.generateTrona) {
            this.generators.add(new WorldGeneratorVein(IHLUtils.getOreDictBlock("oreTrona"), replaceableMinerals));
        }
        if (IHLMod.config.generateBauxite) {
            this.generators.add(new WorldGeneratorVein(IHLUtils.getOreDictBlock("oreBauxite"), replaceableMinerals));
        }
        if (IHLMod.config.generateChromite) {
            this.generators.add(new WorldGeneratorVein(IHLUtils.getOreDictBlock("oreChromite"), replaceableMinerals));
        }
        if (IHLMod.config.generateMuscovite) {
            this.generators.add(new WorldGeneratorVein(IHLUtils.getOreDictBlock("oreMica"), replaceableMinerals));
        }
        if (IHLMod.config.generateOil) {
            this.generators.add(new WorldGeneratorUndergroundLake(IHLFluid.getBlock("oil"), Blocks.field_150343_Z, replaceableForOil));
        }
        if (IHLMod.config.generateSaltwater) {
            this.generators.add(new WorldGeneratorSurfaceLake(IHLFluid.getBlock("saltwater"), replaceableSand));
        }
        if (IHLMod.config.generateDatolite) {
            this.generators.add(new WorldGeneratorVein(IHLUtils.getOreDictBlock("oreDatolite"), replaceableMinerals));
        }
        if (IHLMod.config.generateBischofite) {
            this.generators.add(new WorldGeneratorVein(IHLUtils.getOreDictBlock("oreBischofite"), replaceableMinerals));
        }
        instance = this;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        for (WorldGeneratorBase generator : this.generators) {
            generator.generate(world, chunkX, chunkZ);
        }
    }
}

