/*
 * Decompiled with CFR 0.152.
 */
package ihl.explosion;

import ihl.utils.IHLMathUtils;
import java.util.Random;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.World;

public class ExplosionEntityFX
extends EntityFX {
    private float radius;
    private static final Random random = new Random();
    private final int[] particlesMaxAge;
    private final int[] particlesTextureIndexX;
    private final int[] particlesTextureIndexY;
    private final double[][] startPos;
    private final double[][] pos;
    private final double[][] prevPos;
    private final float[][] motion;
    private final int[] center;

    public ExplosionEntityFX(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.field_70155_l = 5.0;
        int numParticles = 1;
        this.particlesMaxAge = new int[numParticles];
        this.particlesTextureIndexX = new int[numParticles];
        this.particlesTextureIndexY = new int[numParticles];
        this.startPos = new double[numParticles][3];
        this.pos = new double[numParticles][3];
        this.prevPos = new double[numParticles][3];
        this.motion = new float[numParticles][3];
        this.center = new int[3];
    }

    public ExplosionEntityFX(World par1World, int centerX1, int centerY1, int centerZ1, float radius1) {
        super(par1World, (double)centerX1, (double)centerY1, (double)centerZ1, 0.0, 0.0, 0.0);
        this.field_70547_e = 100;
        this.center = new int[3];
        this.center[0] = centerX1;
        this.field_70165_t = this.field_70169_q = (double)this.center[0];
        this.field_70142_S = this.field_70169_q;
        this.center[1] = centerY1;
        this.field_70163_u = this.field_70167_r = (double)this.center[1];
        this.field_70137_T = this.field_70167_r;
        this.center[2] = centerZ1;
        this.field_70161_v = this.field_70166_s = (double)this.center[2];
        this.field_70136_U = this.field_70166_s;
        this.radius = radius1;
        float r2 = this.radius * this.radius;
        int numParticles = Math.min((int)(r2 * this.radius / 32.0f) + 64, 512);
        this.startPos = new double[numParticles][3];
        this.pos = new double[numParticles][3];
        this.prevPos = new double[numParticles][3];
        this.field_70544_f *= 40.0f;
        this.particlesMaxAge = new int[numParticles];
        this.particlesTextureIndexX = new int[numParticles];
        this.particlesTextureIndexY = new int[numParticles];
        this.motion = new float[numParticles][3];
        for (int i = 0; i < numParticles; ++i) {
            float fPosX = random.nextFloat() * 2.0f - 1.0f;
            float fPosY = (random.nextFloat() * 2.0f - 1.0f) * IHLMathUtils.sqrt(1.0f - fPosX * fPosX);
            float fPosZ = (random.nextFloat() * 2.0f - 1.0f) * IHLMathUtils.sqrt(1.0f - fPosX * fPosX - fPosY * fPosY);
            fPosY *= radius1;
            fPosZ *= radius1;
            double d = (fPosX *= radius1) + (float)centerX1;
            this.startPos[i][0] = d;
            this.pos[i][0] = d;
            this.prevPos[i][0] = d;
            double d2 = fPosY + (float)centerY1;
            this.startPos[i][1] = d2;
            this.pos[i][1] = d2;
            this.prevPos[i][1] = d2;
            double d3 = fPosZ + (float)centerZ1;
            this.startPos[i][2] = d3;
            this.pos[i][2] = d3;
            this.prevPos[i][2] = d3;
            this.particlesMaxAge[i] = random.nextInt(this.field_70547_e - 20) + 16;
            this.particlesTextureIndexY[i] = random.nextInt(8);
        }
        this.field_70145_X = true;
        this.field_70155_l = 6.0 + (double)(radius1 / 2.0f);
    }

    public void func_70539_a(Tessellator tessellator, float interFrame, float rotationX, float rotationXZ, float rotationZ, float rotationYZ, float rotationXY) {
        for (int i = 0; i < this.particlesMaxAge.length; ++i) {
            float u1 = (float)this.particlesTextureIndexX[i] / 16.0f;
            float u2 = u1 + 0.0625f;
            float v1 = (float)this.particlesTextureIndexY[i] / 8.0f;
            float v2 = v1 + 0.125f;
            float scale = 0.1f * this.field_70544_f;
            float fPosX = (float)(this.prevPos[i][0] - this.field_70169_q + (this.pos[i][0] - this.prevPos[i][0]) * (double)interFrame);
            float fPosY = (float)(this.prevPos[i][1] - this.field_70167_r + (this.pos[i][1] - this.prevPos[i][1]) * (double)interFrame);
            float fPosZ = (float)(this.prevPos[i][2] - this.field_70166_s + (this.pos[i][2] - this.prevPos[i][2]) * (double)interFrame);
            tessellator.func_78374_a((double)(fPosX - rotationX * scale - rotationYZ * scale), (double)(fPosY - rotationXZ * scale), (double)(fPosZ - rotationZ * scale - rotationXY * scale), (double)u2, (double)v2);
            tessellator.func_78374_a((double)(fPosX - rotationX * scale + rotationYZ * scale), (double)(fPosY + rotationXZ * scale), (double)(fPosZ - rotationZ * scale + rotationXY * scale), (double)u2, (double)v1);
            tessellator.func_78374_a((double)(fPosX + rotationX * scale + rotationYZ * scale), (double)(fPosY + rotationXZ * scale), (double)(fPosZ + rotationZ * scale + rotationXY * scale), (double)u1, (double)v1);
            tessellator.func_78374_a((double)(fPosX + rotationX * scale - rotationYZ * scale), (double)(fPosY - rotationXZ * scale), (double)(fPosZ + rotationZ * scale - rotationXY * scale), (double)u1, (double)v2);
        }
    }

    public void func_70071_h_() {
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_70106_y();
        }
        for (int i = 0; i < this.particlesMaxAge.length; ++i) {
            this.prevPos[i][0] = this.pos[i][0];
            this.prevPos[i][1] = this.pos[i][1];
            this.prevPos[i][2] = this.pos[i][2];
            int maxFrameX = 15;
            int frameX = this.field_70546_d * maxFrameX / this.particlesMaxAge[i];
            if (frameX <= maxFrameX) {
                this.particlesTextureIndexX[i] = frameX;
            }
            if (this.startPos[i][1] < (double)this.center[1]) {
                IHLMathUtils.vector_add(this.motion[i], (float)((double)this.center[0] - this.pos[i][0]) * 4.0E-4f, 0.004f, (float)((double)this.center[2] - this.pos[i][2]) * 4.0E-4f);
            } else {
                float[] ring = new float[]{(float)(this.startPos[i][0] - (double)this.center[0]), 0.0f, (float)(this.startPos[i][2] - (double)this.center[2])};
                IHLMathUtils.scale_vector_to_value(ring, this.radius * 0.6f);
                IHLMathUtils.vector_add(ring, this.center[0], (float)this.startPos[i][1] + (float)this.field_70546_d * 0.001f, this.center[2]);
                float[] from_point_to_ring = IHLMathUtils.vector_return_difference(ring, this.pos[i]);
                float[] from_point_to_center = IHLMathUtils.vector_return_difference(this.center, this.pos[i]);
                float[] tangent_to_ring = IHLMathUtils.vector_vector_multiply(from_point_to_ring, from_point_to_center);
                float[] tangent_to_torus = IHLMathUtils.vector_vector_multiply(from_point_to_ring, tangent_to_ring);
                IHLMathUtils.normalize_vector(tangent_to_torus);
                IHLMathUtils.vector_add(this.motion[i], from_point_to_ring[0] * 0.01f + tangent_to_torus[0] * 0.02f, from_point_to_ring[1] * 0.01f + tangent_to_torus[1] * 0.02f + 0.004f, from_point_to_ring[2] * 0.01f + tangent_to_torus[2] * 0.02f);
            }
            IHLMathUtils.vector_add(this.pos[i], this.motion[i]);
            IHLMathUtils.multiply_vector_to_value(this.motion[i], 0.98f);
        }
    }

    public void func_70536_a(int par1) {
        this.field_94054_b = par1;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }
}

