/*
 * Decompiled with CFR 0.152.
 */
package ihl.flexible_cable;

import ic2.core.block.invslot.InvSlot;
import ihl.flexible_cable.IronWorkbenchInvSlot;
import ihl.flexible_cable.IronWorkbenchTileEntity;
import ihl.interfaces.IWorkspaceElement;
import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class InvSlotWorkspaceElement
extends IronWorkbenchInvSlot {
    private final IWorkspaceElement[] workspaceElements;
    public final boolean[] ready;

    public InvSlotWorkspaceElement(IronWorkbenchTileEntity base1, String name1, int oldStartIndex1, InvSlot.Access access1, int count) {
        super(base1, name1, oldStartIndex1, access1, count);
        this.put(0, IHLUtils.getThisModItemStack("ironWorkbench"));
        this.workspaceElements = new IWorkspaceElement[count];
        this.ready = new boolean[count];
    }

    public boolean accepts(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean getCanTakeStack() {
        return false;
    }

    public boolean containsAndCanUse(List<ItemStack> workspaceElements2) {
        for (ItemStack rWorkspaceElementItemStack : workspaceElements2) {
            boolean presence = false;
            for (int i = 1; i < this.workspaceElements.length; ++i) {
                IWorkspaceElement cWorkspaceElement = this.workspaceElements[i];
                if (cWorkspaceElement == null || rWorkspaceElementItemStack.func_77973_b() != cWorkspaceElement.getWrenchDrop(null).func_77973_b() || !cWorkspaceElement.canBeUsed()) continue;
                presence = true;
                break;
            }
            if (presence) continue;
            return false;
        }
        return true;
    }

    public void use(List<ItemStack> workspaceElements2) {
        block0: for (ItemStack rWorkspaceElementItemStack : workspaceElements2) {
            for (int i = 1; i < this.workspaceElements.length; ++i) {
                IWorkspaceElement cWorkspaceElement = this.workspaceElements[i];
                if (cWorkspaceElement == null || rWorkspaceElementItemStack.func_77973_b() != cWorkspaceElement.getWrenchDrop(null).func_77973_b() || !cWorkspaceElement.canBeUsed()) continue;
                cWorkspaceElement.use();
                continue block0;
            }
        }
    }

    public void reset() {
        int i;
        for (i = 1; i < this.workspaceElements.length; ++i) {
            this.workspaceElements[i] = null;
            this.ready[i] = true;
            this.put(i, null);
        }
        for (i = 1; i < this.workspaceElements.length; ++i) {
            boolean clear = true;
            for (int iy = -1; iy <= 1; ++iy) {
                block3: for (int ix = -2; ix <= 2; ++ix) {
                    for (int iz = -2; iz <= 2; ++iz) {
                        IWorkspaceElement wse;
                        TileEntity te = this.base.func_145831_w().func_147438_o(this.base.field_145851_c + ix, this.base.field_145848_d + iy, this.base.field_145849_e + iz);
                        if (!(te instanceof IWorkspaceElement) || (wse = (IWorkspaceElement)te).getIsInvalid() || this.contains(wse)) continue;
                        this.workspaceElements[i] = wse;
                        this.ready[i] = wse.canBeUsed();
                        this.put(i, wse.getWrenchDrop(null));
                        clear = false;
                        continue block3;
                    }
                }
            }
            if (!clear) continue;
            this.workspaceElements[i] = null;
            this.put(i, null);
        }
    }

    public void writeToNbt(NBTTagCompound nbtTagCompound) {
    }

    public void readFromNbt(NBTTagCompound nbtTagCompound) {
    }

    private boolean contains(IWorkspaceElement wse) {
        for (int i = 0; i < this.workspaceElements.length; ++i) {
            if (this.workspaceElements[i] == null || this.workspaceElements[i].getWrenchDrop(null).func_77973_b() != wse.getWrenchDrop(null).func_77973_b()) continue;
            return true;
        }
        return false;
    }

    public short encodeReadyStatus() {
        short result = 0;
        for (int i = 0; i < this.ready.length; ++i) {
            if (!this.ready[i]) continue;
            result = (short)(result + (1 << i));
        }
        return result;
    }

    public void decodeReadyStatus(short encodedShort) {
        for (int i = 0; i < this.ready.length; ++i) {
            this.ready[i] = (encodedShort >> i & 1) == 1;
        }
    }

    @Override
    public List<ItemStack> getItemStackList() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 1; i < this.size(); ++i) {
            if (this.get(i) == null) continue;
            list.add(this.get(i));
        }
        return list;
    }
}

