/*
 * Decompiled with CFR 0.152.
 */
package ihl.enviroment;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ihl.ClientProxy;
import ihl.IHLMod;
import ihl.utils.IHLMathUtils;
import java.util.BitSet;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class LightSource {
    private final int centerX;
    private final int centerY;
    private final int centerZ;
    public int fromX;
    public int fromY;
    public int fromZ;
    public int toX;
    public int toY;
    public int toZ;
    private final int red;
    private final int green;
    private final int blue;
    private final int power;
    public final BitSet illuminatedBlocks = new BitSet();

    public LightSource(int centerX1, int centerY1, int centerZ1, int red1, int green1, int blue1, int power1) {
        this.centerX = centerX1;
        this.centerY = centerY1;
        this.centerZ = centerZ1;
        this.red = red1;
        this.green = green1;
        this.blue = blue1;
        this.power = power1;
    }

    public void setBorders(int fromX1, int fromY1, int fromZ1, int toX1, int toY1, int toZ1) {
        this.fromX = fromX1;
        this.fromY = fromY1;
        this.fromZ = fromZ1;
        this.toX = toX1;
        this.toY = toY1;
        this.toZ = toZ1;
    }

    public boolean isBlockIlluminated(int x, int y, int z) {
        if (x < this.fromX || x > this.toX || y < this.fromY || y > this.toY || z < this.fromZ || z > this.toZ) {
            return false;
        }
        int rx = x - this.centerX;
        int ry = y - this.centerY;
        int rz = z - this.centerZ;
        int l = ((ClientProxy)IHLMod.proxy).getLightHandler().encodeXYZ(rx, ry, rz);
        return this.illuminatedBlocks.get(l);
    }

    public int[] getLightValue(int x, int y, int z, int[] normal) {
        int dx = this.centerX - x;
        int dy = this.centerY - y;
        int dz = this.centerZ - z;
        int d = dx * dx + dy * dy + dz * dz;
        if (d == 0) {
            return new int[]{240, this.red, this.blue, this.green};
        }
        if (normal[0] + normal[1] + normal[2] == 0) {
            dx = dx < 0 ? -dx : dx;
            dy = dy < 0 ? -dy : dy;
            dz = dz < 0 ? -dz : dz;
        } else {
            dx = normal[0] * dx;
            dy = normal[1] * dy;
            dz = normal[2] * dz;
            dx = dx > 0 ? dx : 0;
            dy = dy > 0 ? dy : 0;
            dz = dz > 0 ? dz : 0;
        }
        int r = this.power * (dx + dy + dz) / d;
        r = r < 0 ? 0 : r;
        int brightness = r > 15 ? 15 : r;
        return new int[]{brightness << 4, this.red * r, this.green * r, this.blue * r};
    }

    public boolean equals(Object o) {
        if (o instanceof LightSource) {
            LightSource otherLS = (LightSource)o;
            return this.centerX == otherLS.centerX && this.centerY == otherLS.centerY && this.centerZ == otherLS.centerZ && this.fromX == otherLS.fromX && this.fromY == otherLS.fromY && this.fromZ == otherLS.fromZ && this.toX == otherLS.toX && this.toY == otherLS.toY && this.toZ == otherLS.toZ;
        }
        return false;
    }

    public void provideLight(World world, int x, int y, int z) {
        int dx = x - this.centerX;
        int dy = y - this.centerY;
        int dz = z - this.centerZ;
        int sqd = dx * dx + dy * dy + dz * dz;
        float d = IHLMathUtils.sqrt(sqd);
        float dx1 = (float)dx / d;
        float dy1 = (float)dy / d;
        float dz1 = (float)dz / d;
        float x1 = (float)x + 0.5f;
        float y1 = (float)y + 0.5f;
        float z1 = (float)z + 0.5f;
        for (int i = 0; i < 64; ++i) {
            int absX = (int)(x1 += dx1);
            int absY = (int)(y1 += dy1);
            int absZ = (int)(z1 += dz1);
            int ddx = absX - this.centerX;
            int ddy = absY - this.centerY;
            int ddz = absZ - this.centerZ;
            this.illuminatedBlocks.set(((ClientProxy)IHLMod.proxy).getLightHandler().encodeXYZ(ddx, ddy, ddz));
            if (absX < this.fromX) {
                this.fromX = absX;
            } else if (absY < this.fromY) {
                this.fromY = absY;
            } else if (absZ < this.fromZ) {
                this.fromZ = absZ;
            } else if (absX > this.toX) {
                this.toX = absX;
            } else if (absY > this.toY) {
                this.toY = absY;
            } else if (absZ > this.toZ) {
                this.toZ = absZ;
            }
            if (world.getBlockLightOpacity(absX, absY, absZ) > 192) break;
        }
    }

    public void castShadow(World world, int x, int y, int z) {
        int dx = x - this.centerX;
        int dy = y - this.centerY;
        int dz = z - this.centerZ;
        int sqd = dx * dx + dy * dy + dz * dz;
        float d = IHLMathUtils.sqrt(sqd);
        float dx1 = (float)dx / d;
        float dy1 = (float)dy / d;
        float dz1 = (float)dz / d;
        float x1 = (float)x + 0.5f;
        float y1 = (float)y + 0.5f;
        float z1 = (float)z + 0.5f;
        x1 += dx1;
        y1 += dy1;
        z1 += dz1;
        for (int i = 0; i < 64; ++i) {
            int absX = (int)(x1 += dx1);
            int absY = (int)(y1 += dy1);
            int absZ = (int)(z1 += dz1);
            int ddx = absX - this.centerX;
            int ddy = absY - this.centerY;
            int ddz = absZ - this.centerZ;
            this.illuminatedBlocks.clear(((ClientProxy)IHLMod.proxy).getLightHandler().encodeXYZ(ddx, ddy, ddz));
            if (absX < this.fromX) {
                this.fromX = absX;
            } else if (absY < this.fromY) {
                this.fromY = absY;
            } else if (absZ < this.fromZ) {
                this.fromZ = absZ;
            } else if (absX > this.toX) {
                this.toX = absX;
            } else if (absY > this.toY) {
                this.toY = absY;
            } else if (absZ > this.toZ) {
                this.toZ = absZ;
            }
            if (world.getBlockLightOpacity(absX, absY, absZ) > 192) break;
        }
    }
}

