/*
 * Decompiled with CFR 0.152.
 */
package ihl.explosion;

import cpw.mods.fml.common.eventhandler.Event;
import ihl.IHLMod;
import ihl.explosion.IHLEntityFallingPile;
import ihl.explosion.PileBlock;
import ihl.explosion.PileTileEntity;
import ihl.explosion.WorldSavedDataBlastWave;
import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S26PacketMapChunkBulk;
import net.minecraft.util.DamageSource;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ExplosionEvent;

public class ExplosionVectorBlockV2 {
    final Set<Integer> startVectors = new HashSet<Integer>();
    public final int[][] directionMasks = new int[8][3];
    public final int bits;
    private final int maxValue;
    public final int halfValue;
    private final int maxArraySize;
    public final int[][] vectors;
    private final Set<Chunk> chunksToUpdate;
    private final Map<Integer, ItemStack> cachedDrops;
    final Map<Integer, WorldSavedDataBlastWave> blastWaveByDimensionId;
    private final Map<ExtendedBlockStorage, Entity[]> cachedEntities;
    private final Random random;

    public ExplosionVectorBlockV2() {
        this.bits = IHLMod.config.explosionVectorSizeBits;
        this.maxValue = (1 << this.bits) - 1;
        this.halfValue = (1 << this.bits - 1) - 1;
        this.maxArraySize = 1 << this.bits * 3;
        this.vectors = new int[this.maxArraySize][0];
        this.chunksToUpdate = new HashSet<Chunk>(64);
        this.cachedDrops = new HashMap<Integer, ItemStack>(128);
        this.blastWaveByDimensionId = new HashMap<Integer, WorldSavedDataBlastWave>();
        this.cachedEntities = new HashMap<ExtendedBlockStorage, Entity[]>();
        this.random = new Random();
        this.precalculateExplosion();
        this.startVectors.add(0);
        this.directionMasks[0] = new int[]{1, 1, 1};
        this.directionMasks[1] = new int[]{-1, 1, 1};
        this.directionMasks[2] = new int[]{1, -1, 1};
        this.directionMasks[3] = new int[]{1, 1, -1};
        this.directionMasks[4] = new int[]{-1, -1, 1};
        this.directionMasks[5] = new int[]{1, -1, -1};
        this.directionMasks[6] = new int[]{-1, 1, -1};
        this.directionMasks[7] = new int[]{-1, -1, -1};
    }

    public int encodeXYZ(int x, int y, int z) {
        return x << this.bits * 2 | y << this.bits | z;
    }

    public int[] decodeXYZ(int l) {
        return new int[]{l >> this.bits * 2, l >> this.bits & this.maxValue, l & this.maxValue};
    }

    public void precalculateExplosion() {
        for (int levelRadius = 1; levelRadius <= this.maxValue; ++levelRadius) {
            for (int ix = 0; ix <= levelRadius; ++ix) {
                for (int iy = 0; iy <= levelRadius; ++iy) {
                    int iz;
                    int n = iz = ix == levelRadius || iy == levelRadius ? 0 : levelRadius;
                    while (iz <= levelRadius) {
                        int vxyz = this.encodeXYZ(ix, iy, iz);
                        int[] prevXYZ = new int[]{ix, iy, iz++};
                        this.reduceCoordinate(prevXYZ, levelRadius);
                        int pvxyz = this.encodeXYZ(prevXYZ[0], prevXYZ[1], prevXYZ[2]);
                        this.findFreeSpace(pvxyz, vxyz);
                    }
                }
            }
        }
    }

    private void findFreeSpace(int pvxyz, int vxyz) {
        int[] nV = new int[this.vectors[pvxyz].length + 1];
        for (int i = 0; i < this.vectors[pvxyz].length; ++i) {
            nV[i] = this.vectors[pvxyz][i];
        }
        nV[this.vectors[pvxyz].length] = vxyz;
        this.vectors[pvxyz] = nV;
    }

    private void reduceCoordinate(int[] pxyz, int levelRadius) {
        float z;
        float x = (float)pxyz[0] + 0.5f;
        float y = (float)pxyz[1] + 0.5f;
        float rx = x / (float)levelRadius;
        float ry = y / (float)levelRadius;
        float rz = z / (float)levelRadius;
        for (z = (float)pxyz[2] + 0.5f; x >= (float)pxyz[0] && y >= (float)pxyz[1] && z >= (float)pxyz[2]; x -= rx, y -= ry, z -= rz) {
        }
        pxyz[0] = x < 0.0f ? 0 : (int)x;
        pxyz[1] = y < 0.0f ? 0 : (int)y;
        pxyz[2] = z < 0.0f ? 0 : (int)z;
    }

    public void breakBlocksAndGetDescendants(World world, int sourceX, int sourceY, int sourceZ, Explosion explosion, int ev, int power, int[] directionMask) {
        power = this.getNewPowerAndProcessBlocks(world, ev, sourceX, sourceY, sourceZ, explosion, power, directionMask);
        if ((power = (int)((double)power * 0.94) - 1) > 1) {
            if (this.vectors[ev].length == 0) {
                int[] xyz = this.decodeXYZ(ev);
                int xb = xyz[0] >> this.bits - 1;
                int yb = xyz[1] >> this.bits - 1;
                int zb = xyz[2] >> this.bits - 1;
                int hashb = xb << 2 | yb << 1 | zb;
                xyz[0] = xyz[0] - xb * this.halfValue;
                xyz[1] = xyz[1] - yb * this.halfValue;
                xyz[2] = xyz[2] - zb * this.halfValue;
                if (hashb == 0 || xb > 1 || yb > 1 || zb > 1) {
                    throw new ArithmeticException("End vectors shall be higher than half value");
                }
                int ev2 = this.encodeXYZ(xyz[0], xyz[1], xyz[2]);
                this.breakBlocksAndGetDescendants(world, sourceX + xb * this.halfValue * directionMask[0], sourceY + yb * this.halfValue * directionMask[1], sourceZ + zb * this.halfValue * directionMask[2], explosion, ev2, power, directionMask);
            } else {
                for (int d1 : this.vectors[ev]) {
                    this.breakBlocksAndGetDescendants(world, sourceX, sourceY, sourceZ, explosion, d1, power, directionMask);
                }
            }
        }
    }

    private int getNewPowerAndProcessBlocks(World world, int ev, int sourceX, int sourceY, int sourceZ, Explosion explosion, int power2, int[] directionMask) {
        int power1 = power2;
        int[] xyz = this.decodeXYZ(ev);
        int absX = xyz[0] * directionMask[0] + sourceX;
        int absY = xyz[1] * directionMask[1] + sourceY;
        int absZ = xyz[2] * directionMask[2] + sourceZ;
        if (absY < 0 || absY >= 256) {
            return 0;
        }
        int absEBSX = absX >> 4;
        int absEBSZ = absZ >> 4;
        if (world.func_72863_F().func_73149_a(absEBSX, absEBSZ)) {
            if (world.func_72863_F().func_73154_d(absEBSX, absEBSZ).func_76625_h() + 24 >= absY) {
                int remainingPower = this.tryDestroyBlock(world, absX, absY, absZ, sourceX, sourceY, sourceZ, power1, explosion);
                return remainingPower;
            }
            return 0;
        }
        WorldSavedDataBlastWave blastWave = null;
        int dimensionId = world.field_73011_w.field_76574_g;
        if (this.blastWaveByDimensionId.containsKey(dimensionId)) {
            blastWave = this.blastWaveByDimensionId.get(dimensionId);
        } else {
            blastWave = new WorldSavedDataBlastWave("blastWave");
            this.blastWaveByDimensionId.put(dimensionId, blastWave);
        }
        long chunkXZKey = ChunkCoordIntPair.func_77272_a((int)absEBSX, (int)absEBSZ);
        blastWave.scheduleExplosionEffectsOnChunkLoad(chunkXZKey, ev, sourceX, sourceY, sourceZ, power1, directionMask);
        return 0;
    }

    public int tryDestroyBlock(World world, int absX, int absY, int absZ, int sourceX, int sourceY, int sourceZ, int power, Explosion explosion) {
        Chunk chunk = world.func_72863_F().func_73154_d(absX >> 4, absZ >> 4);
        ExtendedBlockStorage ebs = this.getEBS(chunk, absX, absY, absZ);
        if (ebs == null) {
            return power;
        }
        Block block = ebs.func_150819_a(absX & 0xF, absY & 0xF, absZ & 0xF);
        if (block.func_149712_f(world, absX, absY, absZ) < 0.0f) {
            return 0;
        }
        if (absX == sourceX && absY == sourceY && absZ == sourceZ) {
            int array_index = (absY & 0xF) << 8 | (absZ & 0xF) << 4 | absX & 0xF;
            if (ebs.func_76658_g()[array_index] != 0 && ebs.func_76660_i() != null && ebs.func_76660_i().func_76582_a(absX & 0xF, absY & 0xF, absZ & 0xF) != 0) {
                --ebs.field_76682_b;
            }
            ebs.func_76658_g()[array_index] = 0;
            if (ebs.func_76660_i() != null) {
                ebs.func_76660_i().func_76581_a(absX & 0xF, absY & 0xF, absZ & 0xF, 0);
            }
            return power;
        }
        int remainingPower = power - (int)(block.getExplosionResistance(null, world, absX, absY, absZ, (double)sourceX, (double)sourceY, (double)sourceZ) * 10.0f + 0.5f);
        if (remainingPower >= 0) {
            int array_index = (absY & 0xF) << 8 | (absZ & 0xF) << 4 | absX & 0xF;
            if (ebs.func_76658_g()[array_index] != 0 && ebs.func_76660_i() != null && ebs.func_76660_i().func_76582_a(absX & 0xF, absY & 0xF, absZ & 0xF) != 0) {
                --ebs.field_76682_b;
            }
            ebs.func_76658_g()[array_index] = 0;
            if (ebs.func_76660_i() != null) {
                ebs.func_76660_i().func_76581_a(absX & 0xF, absY & 0xF, absZ & 0xF, 0);
            }
            ArrayList dropsList = block.getDrops(world, absX, absY, absZ, ebs.func_76665_b(absX & 0xF, absY & 0xF, absZ & 0xF), 0);
            for (ItemStack drop : dropsList) {
                int key = Item.func_150891_b((Item)drop.func_77973_b()) ^ drop.func_77960_j() << 16;
                if (this.cachedDrops.containsKey(key)) {
                    this.cachedDrops.get((Object)Integer.valueOf((int)key)).field_77994_a += drop.field_77994_a;
                    continue;
                }
                this.cachedDrops.put(key, drop);
            }
            Entity[] entities = this.getFromOrCreateCache(world, ebs, absX, absY, absZ);
            if (entities != null && entities[array_index] != null) {
                entities[array_index].func_70097_a(DamageSource.func_94539_a((Explosion)explosion), (float)power / 10.0f);
            }
        } else {
            block.func_149695_a(world, absX, absY, absZ, block);
            if (this.random.nextInt(8) == 0 && (++absY & 0xF) != 0) {
                int array_index = (absY & 0xF) << 8 | (absZ & 0xF) << 4 | absX & 0xF;
                if (ebs.func_76658_g()[array_index] == 0 && (ebs.func_76660_i() == null || ebs.func_76660_i().func_76582_a(absX & 0xF, absY & 0xF, absZ & 0xF) == 0)) {
                    this.placeDrops(world, absX, absY, absZ);
                }
            }
        }
        return remainingPower;
    }

    public Entity[] getFromOrCreateCache(World world, ExtendedBlockStorage ebs, int absX, int absY, int absZ) {
        Chunk chunk;
        List<Entity> eList;
        Entity[] entities = this.cachedEntities.get(ebs);
        if (entities == null && (eList = this.getEntityList(chunk = world.func_72863_F().func_73154_d(absX >> 4, absZ >> 4), absX, absY, absZ)) != null && !eList.isEmpty()) {
            entities = new Entity[4096];
            Iterator<Entity> eListI = eList.iterator();
            this.cachedEntities.put(ebs, entities);
            while (eListI.hasNext()) {
                Entity entity = eListI.next();
                int entityX = (int)entity.field_70121_D.field_72340_a;
                int entityY = (int)entity.field_70121_D.field_72338_b;
                int entityZ = (int)entity.field_70121_D.field_72339_c;
                int rx = entityX & 0xF;
                int ry = entityY & 0xF;
                int rz = entityZ & 0xF;
                int array_index = ry << 8 | rz << 4 | rx;
                entities[array_index] = entity;
            }
        }
        return entities;
    }

    public ExtendedBlockStorage getEBS(Chunk chunk, int absX, int absY, int absZ) {
        ExtendedBlockStorage[] ebsA = chunk.func_76587_i();
        ExtendedBlockStorage ebs = ebsA[absY >> 4];
        if (ebs != null) {
            this.chunksToUpdate.add(chunk);
        }
        return ebs;
    }

    public List<Entity> getEntityList(Chunk chunk, int absX, int absY, int absZ) {
        return chunk.field_76645_j[absY >> 4];
    }

    private void placeDrops(World world, int x, int y, int z) {
        Iterator<Map.Entry<Integer, ItemStack>> di = this.cachedDrops.entrySet().iterator();
        if (di.hasNext()) {
            Map.Entry<Integer, ItemStack> cde = di.next();
            while (di.hasNext()) {
                cde = di.next();
            }
            ItemStack stack = cde.getValue();
            if (stack != null && stack.func_77973_b() != null && stack.field_77994_a > 0) {
                if (stack.field_77994_a <= stack.func_77976_d()) {
                    if (stack.field_77994_a > 0) {
                        PileTileEntity pte = new PileTileEntity();
                        pte.field_145851_c = x;
                        pte.field_145848_d = y;
                        pte.field_145849_e = z;
                        pte.func_145834_a(world);
                        pte.func_145829_t();
                        pte.setContent(stack);
                        IHLUtils.setBlockAndTileEntityRaw(world, x, y, z, PileBlock.instance, pte);
                    }
                    di.remove();
                } else {
                    ItemStack stack1 = stack.func_77946_l();
                    stack1.field_77994_a = stack.func_77976_d();
                    PileTileEntity pte = new PileTileEntity();
                    pte.content = stack1;
                    IHLUtils.setBlockAndTileEntityRaw(world, x, y, z, PileBlock.instance, pte);
                    stack.field_77994_a -= stack.func_77976_d();
                }
            }
        }
    }

    public void sendChunkUpdateToPlayersInExplosionAffectedZone(World world, int sourceX, int sourceY, int sourceZ) {
        for (Chunk chunk : this.chunksToUpdate) {
            chunk.func_76603_b();
            Arrays.fill(chunk.field_76639_c, true);
            chunk.func_150804_b(false);
        }
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        chunks.addAll(this.chunksToUpdate);
        for (Object player : world.field_73010_i) {
            if (!(player instanceof EntityPlayerMP)) continue;
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            playerMP.field_71135_a.func_147359_a((Packet)new S26PacketMapChunkBulk(chunks));
        }
        this.chunksToUpdate.clear();
    }

    public void doExplosion(World world, int sourceX, int sourceY, int sourceZ, Set<Integer> startVectors1, int startPower, int[] directionMask, Explosion explosion) {
        for (int sv : startVectors1) {
            this.breakBlocksAndGetDescendants(world, sourceX - (directionMask[0] < 0 ? 1 : 0), sourceY - (directionMask[1] < 0 ? 1 : 0), sourceZ - (directionMask[2] < 0 ? 1 : 0), explosion, sv, startPower, directionMask);
        }
        this.cachedEntities.clear();
    }

    public void doExplosion(World world, int sourceX, int sourceY, int sourceZ, Set<Integer> startVectors1, int startPower) {
        IHLMod.log.info("Starting explosion server");
        Explosion explosion = new Explosion(world, null, (double)sourceX, (double)sourceY, (double)sourceZ, 100.0f);
        if (!MinecraftForge.EVENT_BUS.post((Event)new ExplosionEvent.Start(world, explosion))) {
            for (int[] directionMask : this.directionMasks) {
                this.doExplosion(world, sourceX, sourceY, sourceZ, startVectors1, startPower, directionMask, explosion);
            }
            this.sendChunkUpdateToPlayersInExplosionAffectedZone(world, sourceX, sourceY, sourceZ);
            Object object = this.cachedDrops.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                IHLEntityFallingPile fallingPile = new IHLEntityFallingPile(world);
                fallingPile.func_70107_b((double)sourceX + 0.5, (double)sourceY + 0.5, (double)sourceZ + 0.5);
                fallingPile.func_92058_a((ItemStack)entry.getValue());
                fallingPile.func_70016_h(this.random.nextDouble() - 0.5, this.random.nextDouble() * 2.0, this.random.nextDouble() - 0.5);
                world.func_72838_d((Entity)fallingPile);
            }
            this.cachedDrops.clear();
        }
    }
}

