/*
 * Decompiled with CFR 0.152.
 */
package ihl.enviroment;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkDataProvider;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.network.NetworkManager;
import ihl.ClientProxy;
import ihl.IHLMod;
import ihl.enviroment.LightSource;
import ihl.utils.IHLUtils;
import java.util.List;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class LightBulbTileEntity
extends TileEntity
implements IEnergySink,
IWrenchable,
INetworkDataProvider {
    private boolean active = false;
    private short facing = 0;
    public boolean prevActive = false;
    public short prevFacing = 0;
    private double energy;
    public boolean addedToEnergyNet = false;
    private boolean loaded = false;
    private int ticker;
    public int colour = 0xFFFFFF;
    @SideOnly(value=Side.CLIENT)
    LightSource lightSource;

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74769_h("energy");
        this.facing = nbttagcompound.func_74765_d("facing");
        this.colour = nbttagcompound.func_74762_e("colour");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
        nbttagcompound.func_74777_a("facing", this.facing);
        nbttagcompound.func_74768_a("colour", this.colour);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onLoaded() {
        if (!this.field_145850_b.field_72995_K) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "colour");
        }
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
        this.loaded = true;
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        this.active = false;
        this.updateLightState();
    }

    public final boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K && this.prevActive != this.active) {
            this.updateLightState();
            this.prevActive = this.active;
        }
        if (!this.loaded) {
            this.onLoaded();
        }
        if (!this.field_145850_b.field_72995_K && ++this.ticker % 4 == 0) {
            if (this.prevFacing != this.facing) {
                this.setFacing(this.facing);
            }
            if (this.energy > 0.0) {
                this.energy -= 1.0;
                this.setActive(true);
            } else {
                this.setActive(false);
            }
        }
    }

    protected void updateLightState() {
        if (IC2.platform.isSimulating()) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (IC2.platform.isRendering()) {
            if (this.getActive()) {
                if (this.lightSource != null) {
                    ((ClientProxy)IHLMod.proxy).getLightHandler().removeLightSource(this.lightSource);
                }
                int red = this.colour >>> 16;
                int green = this.colour >>> 8 & 0xFF;
                int blue = this.colour & 0xFF;
                int max = red;
                if (max < green) {
                    max = green;
                }
                if (max < blue) {
                    max = blue;
                }
                this.lightSource = this.createLightSource(red -= (max -= 255), green -= max, blue -= max);
                ((ClientProxy)IHLMod.proxy).getLightHandler().addLightSource(this.lightSource);
            } else if (this.lightSource != null) {
                ((ClientProxy)IHLMod.proxy).getLightHandler().removeLightSource(this.lightSource);
                this.lightSource = null;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected LightSource createLightSource(int red, int green, int blue) {
        return ((ClientProxy)IHLMod.proxy).getLightHandler().calculateLightSource(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 64, red, green, blue, null);
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        switch (direction) {
            case UP: {
                return this.getFacing() == 0;
            }
            case DOWN: {
                return this.getFacing() == 1;
            }
            case SOUTH: {
                return this.getFacing() == 2;
            }
            case NORTH: {
                return this.getFacing() == 3;
            }
            case EAST: {
                return this.getFacing() == 4;
            }
            case WEST: {
                return this.getFacing() == 5;
            }
        }
        return false;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    public short getFacing() {
        return this.facing;
    }

    public void setFacing(short facing1) {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        this.facing = facing1;
        if (IC2.platform.isSimulating() && this.prevFacing != this.facing) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "facing");
        }
        this.prevFacing = this.facing;
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public List<String> getNetworkedFields() {
        Vector<String> ret = new Vector<String>(2);
        ret.add("active");
        ret.add("facing");
        ret.add("colour");
        return ret;
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return IHLUtils.getThisModItemStack("lightBulb");
    }

    public double getDemandedEnergy() {
        if (this.energy > 10.0) {
            return 0.0;
        }
        return 2.147483647E9;
    }

    public int getSinkTier() {
        return 1;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        this.energy += amount;
        return 0.0;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active1) {
        this.active = active1;
        if (this.prevActive != active1) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "active");
            this.updateLightState();
        }
        this.prevActive = active1;
    }

    public void setActiveWithoutNotify(boolean active1) {
        this.active = active1;
        this.prevActive = active1;
    }
}

