/*
 * Decompiled with CFR 0.152.
 */
package ihl;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ihl.IHLMod;
import ihl.ServerProxy;
import ihl.crop_harvestors.BlobEntityFX;
import ihl.crop_harvestors.BlobRenderFX;
import ihl.crop_harvestors.SackRender;
import ihl.crop_harvestors.SackTileEntity;
import ihl.enviroment.LightBulbModel;
import ihl.enviroment.LightBulbRender;
import ihl.enviroment.LightBulbTileEntity;
import ihl.enviroment.LightHandler;
import ihl.enviroment.LightSource;
import ihl.enviroment.MirrorRender;
import ihl.enviroment.MirrorTileEntity;
import ihl.enviroment.SpotlightModel;
import ihl.enviroment.SpotlightRender;
import ihl.enviroment.SpotlightTileEntity;
import ihl.explosion.ExplosionEntityFX;
import ihl.explosion.ExplosionRenderFX;
import ihl.explosion.IHLEntityFallingPile;
import ihl.explosion.IHLEntityFallingPileRender;
import ihl.explosion.PileBlockRender;
import ihl.explosion.PileTileEntity;
import ihl.flexible_cable.AnchorTileEntity;
import ihl.flexible_cable.BatterySwitchUnitModel;
import ihl.flexible_cable.BatterySwitchUnitTileEntity;
import ihl.flexible_cable.BlastEntityFX;
import ihl.flexible_cable.IronWorkbenchRender;
import ihl.flexible_cable.IronWorkbenchTileEntity;
import ihl.flexible_cable.NodeEntity;
import ihl.flexible_cable.NodeRender;
import ihl.flexible_cable.RectifierTransformerUnitTileEntity;
import ihl.interfaces.INetworkListener;
import ihl.interfaces.ISelectionBoxSpecialRenderer;
import ihl.items_blocks.FlexibleCableItem;
import ihl.items_blocks.IHLTool;
import ihl.items_blocks.MachineBaseBlock;
import ihl.model.CableHolderSelectionBoxSpecialRenderer;
import ihl.model.FlexibleCableItemRender;
import ihl.model.IHLBlockRenderer;
import ihl.model.IHLToolRenderer;
import ihl.model.ImpregnatingMachineBlockRender;
import ihl.model.IronWorkbenchBlockRender;
import ihl.model.RectifierTransformerUnitBlockRender;
import ihl.model.RectifierTransformerUnitSelectionBoxSpecialRenderer;
import ihl.model.RefluxCondenserBlockRender;
import ihl.model.TileEntityRendererDispatcherExt;
import ihl.model.UniversalTileRender;
import ihl.processing.chemistry.ElectrolysisBathModel;
import ihl.processing.chemistry.ElectrolysisBathTileEntity;
import ihl.processing.chemistry.FractionatorBottomModel;
import ihl.processing.chemistry.FractionatorBottomTileEntity;
import ihl.processing.chemistry.FractionatorCoverModel;
import ihl.processing.chemistry.FractionatorCoverTileEntity;
import ihl.processing.chemistry.FractionatorSectionModel;
import ihl.processing.chemistry.FractionatorSectionTileEntity;
import ihl.processing.chemistry.GaedesMercuryRotaryPumpModel;
import ihl.processing.chemistry.GaedesMercuryRotaryPumpTileEntity;
import ihl.processing.chemistry.LoomModel;
import ihl.processing.chemistry.LoomTileEntity;
import ihl.processing.chemistry.RefluxCondenserModel;
import ihl.processing.chemistry.RefluxCondenserTileEntity;
import ihl.processing.metallurgy.CoilerModel;
import ihl.processing.metallurgy.CoilerRender;
import ihl.processing.metallurgy.CoilerTileEntity;
import ihl.processing.metallurgy.DetonationSprayingMachineModel;
import ihl.processing.metallurgy.DetonationSprayingMachineRender;
import ihl.processing.metallurgy.DetonationSprayingMachineTileEntity;
import ihl.processing.metallurgy.ExtruderModel;
import ihl.processing.metallurgy.ExtruderTileEntity;
import ihl.processing.metallurgy.GasWeldingStationModel;
import ihl.processing.metallurgy.GasWeldingStationTileEntity;
import ihl.processing.metallurgy.ImpregnatingMachineRender;
import ihl.processing.metallurgy.ImpregnatingMachineTileEntity;
import ihl.processing.metallurgy.LathePart1Model;
import ihl.processing.metallurgy.LathePart1TileEntity;
import ihl.processing.metallurgy.LathePart2Model;
import ihl.processing.metallurgy.LathePart2TileEntity;
import ihl.processing.metallurgy.RollingMachinePart1Model;
import ihl.processing.metallurgy.RollingMachinePart1TileEntity;
import ihl.processing.metallurgy.RollingMachinePart2Model;
import ihl.processing.metallurgy.RollingMachinePart2TileEntity;
import ihl.processing.metallurgy.RollingMachineRender;
import ihl.processing.metallurgy.VulcanizationExtrudingMoldModel;
import ihl.processing.metallurgy.VulcanizationExtrudingMoldTileEntity;
import ihl.processing.metallurgy.WoodenRollingMachinePart1TileEntity;
import ihl.processing.metallurgy.WoodenRollingMachinePart2Model;
import ihl.processing.metallurgy.WoodenRollingMachinePart2TileEntity;
import ihl.processing.metallurgy.WoodenRollingMachineRender;
import ihl.servitor.FlameEntityFX;
import ihl.servitor.FlameRenderFX;
import ihl.servitor.LostHeadEntity;
import ihl.servitor.LostHeadRender;
import ihl.servitor.SkullItemRender;
import ihl.utils.BlockItemRender;
import ihl.utils.IHLRenderUtils;
import ihl.utils.IHLUtils;
import ihl.worldgen.ores.IHLFluid;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends ServerProxy {
    public boolean loadMirrorRender = true;
    public IHLRenderUtils renderUtils;
    public Map<MachineBaseBlock.MachineType, Integer> sharedBlockRenders = new HashMap<MachineBaseBlock.MachineType, Integer>();
    public Map<Class<? extends TileEntity>, ISelectionBoxSpecialRenderer> selectionBoxSpecialRendererRegistry = new HashMap<Class<? extends TileEntity>, ISelectionBoxSpecialRenderer>();
    public LightHandler lightHandler;

    public LightHandler getLightHandler() {
        return this.lightHandler;
    }

    @Override
    public void load() throws ParserConfigurationException {
        if (this.lightHandler == null) {
            this.lightHandler = new LightHandler();
        }
        if (channel == null) {
            channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("ihl");
            channel.register((Object)this);
        }
        this.renderUtils = new IHLRenderUtils();
        MinecraftForge.EVENT_BUS.register((Object)this.renderUtils);
        TileEntityRendererDispatcher.field_147556_a = new TileEntityRendererDispatcherExt();
        this.registerBlockHandler(new ImpregnatingMachineBlockRender(), MachineBaseBlock.MachineType.BronzeTub);
        this.registerBlockHandler(new RefluxCondenserBlockRender(), MachineBaseBlock.MachineType.RefluxCondenser);
        this.registerBlockHandler(new RectifierTransformerUnitBlockRender(), MachineBaseBlock.MachineType.RectifierTransformerUnit);
        this.registerBlockHandler(new IronWorkbenchBlockRender(), MachineBaseBlock.MachineType.IronWorkbench);
        PileBlockRender pileBlockRender = new PileBlockRender();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)pileBlockRender);
        ClientRegistry.bindTileEntitySpecialRenderer(PileTileEntity.class, (TileEntitySpecialRenderer)pileBlockRender.pileTileEntityRender);
        RenderingRegistry.registerEntityRenderingHandler(IHLEntityFallingPile.class, (Render)new IHLEntityFallingPileRender());
        ClientRegistry.bindTileEntitySpecialRenderer(SackTileEntity.class, (TileEntitySpecialRenderer)new SackRender());
        ClientRegistry.bindTileEntitySpecialRenderer(LathePart1TileEntity.class, (TileEntitySpecialRenderer)new UniversalTileRender(new LathePart1Model(), new ResourceLocation("ihl:textures/blocks/coiler.png")));
        ClientRegistry.bindTileEntitySpecialRenderer(LathePart2TileEntity.class, (TileEntitySpecialRenderer)new UniversalTileRender(new LathePart2Model(), new ResourceLocation("ihl:textures/blocks/coiler.png")));
        ClientRegistry.bindTileEntitySpecialRenderer(LoomTileEntity.class, (TileEntitySpecialRenderer)new UniversalTileRender(new LoomModel(), new ResourceLocation("ihl:textures/blocks/detonationSprayingMachine.png")));
        ClientRegistry.bindTileEntitySpecialRenderer(ImpregnatingMachineTileEntity.class, (TileEntitySpecialRenderer)new ImpregnatingMachineRender());
        ClientRegistry.bindTileEntitySpecialRenderer(DetonationSprayingMachineTileEntity.class, (TileEntitySpecialRenderer)new DetonationSprayingMachineRender());
        ClientRegistry.bindTileEntitySpecialRenderer(CoilerTileEntity.class, (TileEntitySpecialRenderer)new CoilerRender());
        ClientRegistry.bindTileEntitySpecialRenderer(IronWorkbenchTileEntity.class, (TileEntitySpecialRenderer)new IronWorkbenchRender());
        ClientRegistry.bindTileEntitySpecialRenderer(RollingMachinePart1TileEntity.class, (TileEntitySpecialRenderer)new RollingMachineRender());
        ClientRegistry.bindTileEntitySpecialRenderer(RollingMachinePart2TileEntity.class, (TileEntitySpecialRenderer)new UniversalTileRender(new RollingMachinePart2Model(), new ResourceLocation("ihl:textures/blocks/coiler.png")));
        ClientRegistry.bindTileEntitySpecialRenderer(VulcanizationExtrudingMoldTileEntity.class, (TileEntitySpecialRenderer)new UniversalTileRender(new VulcanizationExtrudingMoldModel(), new ResourceLocation("ihl:textures/blocks/coiler.png")));
        ClientRegistry.bindTileEntitySpecialRenderer(ExtruderTileEntity.class, (TileEntitySpecialRenderer)new UniversalTileRender(new ExtruderModel(), new ResourceLocation("ihl:textures/blocks/coiler.png")));
        ClientRegistry.bindTileEntitySpecialRenderer(WoodenRollingMachinePart1TileEntity.class, (TileEntitySpecialRenderer)new WoodenRollingMachineRender());
        ClientRegistry.bindTileEntitySpecialRenderer(WoodenRollingMachinePart2TileEntity.class, (TileEntitySpecialRenderer)new UniversalTileRender(new WoodenRollingMachinePart2Model(), new ResourceLocation("ihl:textures/blocks/woodenRollingMachine.png")));
        ClientRegistry.bindTileEntitySpecialRenderer(GasWeldingStationTileEntity.class, (TileEntitySpecialRenderer)new UniversalTileRender(new GasWeldingStationModel(), new ResourceLocation("ihl:textures/blocks/gasWeldingStation.png")));
        ClientRegistry.bindTileEntitySpecialRenderer(GaedesMercuryRotaryPumpTileEntity.class, (TileEntitySpecialRenderer)new UniversalTileRender(new GaedesMercuryRotaryPumpModel(), new ResourceLocation("ihl:textures/blocks/extruder.png")));
        ClientRegistry.bindTileEntitySpecialRenderer(FractionatorBottomTileEntity.class, (TileEntitySpecialRenderer)new UniversalTileRender(new FractionatorBottomModel(), new ResourceLocation("ihl:textures/blocks/splitInjectionMold.png")));
        ClientRegistry.bindTileEntitySpecialRenderer(FractionatorSectionTileEntity.class, (TileEntitySpecialRenderer)new UniversalTileRender(new FractionatorSectionModel(), new ResourceLocation("ihl:textures/blocks/splitInjectionMold.png")));
        ClientRegistry.bindTileEntitySpecialRenderer(FractionatorCoverTileEntity.class, (TileEntitySpecialRenderer)new UniversalTileRender(new FractionatorCoverModel(), new ResourceLocation("ihl:textures/blocks/splitInjectionMold.png")));
        ClientRegistry.bindTileEntitySpecialRenderer(RefluxCondenserTileEntity.class, (TileEntitySpecialRenderer)new UniversalTileRender(new RefluxCondenserModel(), new ResourceLocation("ihl:textures/blocks/splitInjectionMold.png")));
        ClientRegistry.bindTileEntitySpecialRenderer(BatterySwitchUnitTileEntity.class, (TileEntitySpecialRenderer)new UniversalTileRender(new BatterySwitchUnitModel(), new ResourceLocation("ihl:textures/blocks/batterySwitchUnit.png")));
        ClientRegistry.bindTileEntitySpecialRenderer(ElectrolysisBathTileEntity.class, (TileEntitySpecialRenderer)new UniversalTileRender(new ElectrolysisBathModel(), new ResourceLocation("ihl:textures/blocks/electrolysisBath.png")));
        if (this.loadMirrorRender && IHLMod.config.mirrorReflectionRange > 0) {
            ClientRegistry.bindTileEntitySpecialRenderer(MirrorTileEntity.class, (TileEntitySpecialRenderer)new MirrorRender());
        }
        ClientRegistry.bindTileEntitySpecialRenderer(LightBulbTileEntity.class, (TileEntitySpecialRenderer)new LightBulbRender());
        ClientRegistry.bindTileEntitySpecialRenderer(SpotlightTileEntity.class, (TileEntitySpecialRenderer)new SpotlightRender());
        this.selectionBoxSpecialRendererRegistry.put(AnchorTileEntity.class, new CableHolderSelectionBoxSpecialRenderer());
        this.selectionBoxSpecialRendererRegistry.put(RectifierTransformerUnitTileEntity.class, new RectifierTransformerUnitSelectionBoxSpecialRenderer());
        MinecraftForgeClient.registerItemRenderer((Item)IHLUtils.getThisModItem("cannonBronze"), (IItemRenderer)new BlockItemRender(new DetonationSprayingMachineModel(), new ResourceLocation("ihl:textures/blocks/detonationSprayingMachine.png"), 0, 0, 0.0f, 0.0f));
        MinecraftForgeClient.registerItemRenderer((Item)IHLUtils.getThisModItem("lathePart1"), (IItemRenderer)new BlockItemRender(new LathePart1Model(), new ResourceLocation("ihl:textures/blocks/coiler.png"), 0, 0, 0.0f, 0.0f));
        MinecraftForgeClient.registerItemRenderer((Item)IHLUtils.getThisModItem("lathePart2"), (IItemRenderer)new BlockItemRender(new LathePart2Model(), new ResourceLocation("ihl:textures/blocks/coiler.png"), 0, 0, 0.0f, 0.0f));
        MinecraftForgeClient.registerItemRenderer((Item)IHLUtils.getThisModItem("rollingMachinePart1"), (IItemRenderer)new BlockItemRender(new RollingMachinePart1Model(), new ResourceLocation("ihl:textures/blocks/coiler.png"), 0, 5, 0.0f, 0.0f));
        MinecraftForgeClient.registerItemRenderer((Item)IHLUtils.getThisModItem("rollingMachinePart2"), (IItemRenderer)new BlockItemRender(new RollingMachinePart2Model(), new ResourceLocation("ihl:textures/blocks/coiler.png"), 0, 0, 0.0f, 0.0f));
        MinecraftForgeClient.registerItemRenderer((Item)IHLUtils.getThisModItem("coiler"), (IItemRenderer)new BlockItemRender(new CoilerModel(), new ResourceLocation("ihl:textures/blocks/coiler.png"), 0, 6, 0.0f, 0.0f));
        MinecraftForgeClient.registerItemRenderer((Item)IHLUtils.getThisModItem("loom"), (IItemRenderer)new BlockItemRender(new LoomModel(), new ResourceLocation("ihl:textures/blocks/detonationSprayingMachine.png"), 0, 0, 0.0f, 0.0f));
        MinecraftForgeClient.registerItemRenderer((Item)IHLUtils.getThisModItem("vulcanizationExtrudingMold"), (IItemRenderer)new BlockItemRender(new VulcanizationExtrudingMoldModel(), new ResourceLocation("ihl:textures/blocks/coiler.png"), 0, 0, 0.0f, 0.0f));
        MinecraftForgeClient.registerItemRenderer((Item)IHLUtils.getThisModItem("extruder"), (IItemRenderer)new BlockItemRender(new ExtruderModel(), new ResourceLocation("ihl:textures/blocks/coiler.png"), 0, 0, 0.0f, 0.0f));
        MinecraftForgeClient.registerItemRenderer((Item)IHLUtils.getThisModItem("woodenRollingMachinePart1"), (IItemRenderer)new BlockItemRender(new WoodenRollingMachinePart2Model(), new ResourceLocation("ihl:textures/blocks/woodenRollingMachine.png"), 0, 0, 0.0f, 0.0f));
        MinecraftForgeClient.registerItemRenderer((Item)IHLUtils.getThisModItem("woodenRollingMachinePart2"), (IItemRenderer)new BlockItemRender(new WoodenRollingMachinePart2Model(), new ResourceLocation("ihl:textures/blocks/woodenRollingMachine.png"), 0, 0, 0.0f, 0.0f));
        MinecraftForgeClient.registerItemRenderer((Item)IHLUtils.getThisModItem("gasWeldingStation"), (IItemRenderer)new BlockItemRender(new GasWeldingStationModel(), new ResourceLocation("ihl:textures/blocks/gasWeldingStation.png"), 0, 0, 0.0f, 0.0f));
        MinecraftForgeClient.registerItemRenderer((Item)IHLUtils.getThisModItem("gaedesMercuryRotaryPump"), (IItemRenderer)new BlockItemRender(new GaedesMercuryRotaryPumpModel(), new ResourceLocation("ihl:textures/blocks/extruder.png"), 0, 0, 0.0f, 0.0f));
        MinecraftForgeClient.registerItemRenderer((Item)IHLMod.ihlSkull, (IItemRenderer)new SkullItemRender());
        MinecraftForgeClient.registerItemRenderer((Item)IHLUtils.getThisModItem("fractionatorBottom"), (IItemRenderer)new BlockItemRender(new FractionatorBottomModel(), new ResourceLocation("ihl:textures/blocks/splitInjectionMold.png"), 0, 0, 0.0f, 0.0f));
        MinecraftForgeClient.registerItemRenderer((Item)IHLUtils.getThisModItem("fractionatorSection"), (IItemRenderer)new BlockItemRender(new FractionatorSectionModel(), new ResourceLocation("ihl:textures/blocks/splitInjectionMold.png"), 0, 0, 0.0f, 0.0f));
        MinecraftForgeClient.registerItemRenderer((Item)IHLUtils.getThisModItem("fractionatorCover"), (IItemRenderer)new BlockItemRender(new FractionatorCoverModel(), new ResourceLocation("ihl:textures/blocks/splitInjectionMold.png"), 0, 0, 0.0f, 0.0f));
        MinecraftForgeClient.registerItemRenderer((Item)IHLUtils.getThisModItem("refluxCondenser"), (IItemRenderer)new BlockItemRender(new RefluxCondenserModel(), new ResourceLocation("ihl:textures/blocks/splitInjectionMold.png"), 0, 0, 0.0f, 0.0f));
        MinecraftForgeClient.registerItemRenderer((Item)IHLUtils.getThisModItem("batterySwitchUnit"), (IItemRenderer)new BlockItemRender(new BatterySwitchUnitModel(), new ResourceLocation("ihl:textures/blocks/batterySwitchUnit.png"), 0, 0, 0.0f, 0.0f));
        MinecraftForgeClient.registerItemRenderer((Item)IHLUtils.getThisModItem("electrolysisBath"), (IItemRenderer)new BlockItemRender(new ElectrolysisBathModel(), new ResourceLocation("ihl:textures/blocks/electrolysisBath.png"), 0, 0, 0.0f, 0.0f));
        MinecraftForgeClient.registerItemRenderer((Item)IHLUtils.getThisModItem("lightBulb"), (IItemRenderer)new BlockItemRender(new LightBulbModel(), new ResourceLocation("ihl:textures/blocks/lightBulb.png"), 0, 1, 0.0f, 0.0f, true));
        MinecraftForgeClient.registerItemRenderer((Item)IHLUtils.getThisModItem("spotlight"), (IItemRenderer)new BlockItemRender(new SpotlightModel(), new ResourceLocation("ihl:textures/blocks/spotlight.png"), 0, 1, 0.0f, 0.0f));
        MinecraftForgeClient.registerItemRenderer((Item)IHLTool.instance, (IItemRenderer)new IHLToolRenderer());
        MinecraftForgeClient.registerItemRenderer((Item)FlexibleCableItem.instance, (IItemRenderer)new FlexibleCableItemRender());
        RenderingRegistry.registerEntityRenderingHandler(LostHeadEntity.class, (Render)new LostHeadRender());
        RenderingRegistry.registerEntityRenderingHandler(FlameEntityFX.class, (Render)new FlameRenderFX("ihl:textures/particles/flameTongue.png"));
        RenderingRegistry.registerEntityRenderingHandler(BlastEntityFX.class, (Render)new FlameRenderFX("ihl:textures/particles/blast.png"));
        RenderingRegistry.registerEntityRenderingHandler(BlobEntityFX.class, (Render)new BlobRenderFX());
        RenderingRegistry.registerEntityRenderingHandler(ExplosionEntityFX.class, (Render)new ExplosionRenderFX("ihl:textures/particles/explosion.png"));
        RenderingRegistry.registerEntityRenderingHandler(NodeEntity.class, (Render)new NodeRender());
    }

    @Override
    public void spawnParticle(int particle, World world, double x, double y, double z, double mx, double my, double mz, float particleScale) {
        switch (particle) {
            case 0: {
                FlameEntityFX flamePEFX1 = new FlameEntityFX(world, x, y, z, mx, my, mz, particleScale);
                world.func_72838_d((Entity)flamePEFX1);
                break;
            }
            case 1: {
                BlobEntityFX blob = new BlobEntityFX(world, x, y, z, mx, my, mz, particleScale, BlobEntityFX.FluidType.RESIN);
                world.func_72838_d((Entity)blob);
                break;
            }
            case 2: {
                BlobEntityFX blob2 = new BlobEntityFX(world, x, y, z, mx, my, mz, particleScale, BlobEntityFX.FluidType.SAP);
                world.func_72838_d((Entity)blob2);
                break;
            }
            case 3: {
                BlastEntityFX blast = new BlastEntityFX(world, x, y, z, mx, my, mz, particleScale);
                world.func_72838_d((Entity)blast);
                break;
            }
            case 4: {
                world.func_72869_a("smoke", x, y, z, mx, my, mz);
                break;
            }
            default: {
                FlameEntityFX flamePEFX2 = new FlameEntityFX(world, x, y, z, mx, my, mz, particleScale);
                world.func_72838_d((Entity)flamePEFX2);
            }
        }
    }

    @Override
    public void createExplosionEffect(World world, int x, int y, int z, float radius) {
        world.func_72980_b((double)x, (double)y, (double)z, "ihl:explosion", 100.0f, 1.0f, false);
        ExplosionEntityFX explosionFX = new ExplosionEntityFX(world, x, y, z, radius);
        world.func_72838_d((Entity)explosionFX);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerIcons(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 0) {
            IHLFluid.registerIcons(event.map);
        }
    }

    public Render getRenderForEntityClass(Class<? extends Entity> entityClass) {
        return (Render)RenderManager.field_78727_a.field_78729_o.get(entityClass);
    }

    @Override
    public void initBlockRenderer() {
        new IHLBlockRenderer();
    }

    @Override
    public int getGLDisplayList() {
        return GLAllocation.func_74526_a((int)1);
    }

    @Override
    public File getMinecraftDir() {
        return Minecraft.func_71410_x().field_71412_D;
    }

    @Override
    public int shareBlockRendererByMachineType(MachineBaseBlock.MachineType type) {
        return this.sharedBlockRenders.get((Object)type);
    }

    public void registerBlockHandler(ISimpleBlockRenderingHandler handler, MachineBaseBlock.MachineType ... types) {
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)handler);
        for (MachineBaseBlock.MachineType type : types) {
            this.sharedBlockRenders.put(type, handler.getRenderId());
        }
    }

    @SubscribeEvent
    public void onPacketFromServerToClient(FMLNetworkEvent.ClientCustomPacketEvent event) throws IOException {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        ByteBuf data = event.packet.payload();
        ByteBufInputStream byteBufInputStream = new ByteBufInputStream(data);
        switch (byteBufInputStream.read()) {
            case 0: {
                int particleId = byteBufInputStream.read();
                float x = byteBufInputStream.readFloat();
                float y = byteBufInputStream.readFloat();
                float z = byteBufInputStream.readFloat();
                float mx = byteBufInputStream.readFloat();
                float my = byteBufInputStream.readFloat();
                float mz = byteBufInputStream.readFloat();
                float particleScale = byteBufInputStream.readFloat();
                this.spawnParticle(particleId, (World)world, x, y, z, mx, my, mz, particleScale);
                break;
            }
            case 1: {
                int entityId = byteBufInputStream.readInt();
                INetworkListener listener = (INetworkListener)world.func_73045_a(entityId);
                if (listener != null) {
                    listener.recieveData(byteBufInputStream);
                    IHLMod.log.debug("Data delivered to client");
                    break;
                }
                this.delayedEntityDataPacket.put(entityId, data);
                IHLMod.log.debug("Data delayed. Entity ID=" + entityId);
                break;
            }
            case 2: {
                int posX = byteBufInputStream.readInt();
                int posY = byteBufInputStream.readInt();
                int posZ = byteBufInputStream.readInt();
                float radius = byteBufInputStream.readFloat();
                this.createExplosionEffect((World)world, posX, posY, posZ, radius);
                break;
            }
            case 3: {
                int soundId = byteBufInputStream.read();
                float x = byteBufInputStream.readFloat();
                float y = byteBufInputStream.readFloat();
                float z = byteBufInputStream.readFloat();
                float volume = byteBufInputStream.readFloat();
                float pitch = byteBufInputStream.readFloat();
                this.playSound(world, soundId, x, y, z, volume, pitch);
                break;
            }
            case 4: {
                int posX = byteBufInputStream.readInt();
                int posY = byteBufInputStream.readInt();
                int posZ = byteBufInputStream.readInt();
                for (LightSource lightSource : ((ClientProxy)IHLMod.proxy).getLightHandler().lightSources) {
                    if (!lightSource.isBlockIlluminated(posX, posY, posZ)) continue;
                    lightSource.provideLight((World)world, posX, posY, posZ);
                }
                break;
            }
            case 5: {
                int posX = byteBufInputStream.readInt();
                int posY = byteBufInputStream.readInt();
                int posZ = byteBufInputStream.readInt();
                for (LightSource lightSource : ((ClientProxy)IHLMod.proxy).getLightHandler().lightSources) {
                    if (!lightSource.isBlockIlluminated(posX, posY, posZ)) continue;
                    lightSource.castShadow((World)world, posX, posY, posZ);
                }
                break;
            }
        }
        byteBufInputStream.close();
    }

    private void playSound(WorldClient world, int soundId, float x, float y, float z, float volume, float pitch) {
        world.func_72980_b((double)x, (double)y, (double)z, "ihl:fuse", 1.0f, 1.0f, false);
    }

    @Override
    public boolean renderTESpecialSelectionBox(TileEntity te, EntityPlayer player, ItemStack currentItem, MovingObjectPosition target, float partialTicks) {
        ISelectionBoxSpecialRenderer ssbr = this.selectionBoxSpecialRendererRegistry.get(te.getClass());
        if (ssbr != null) {
            ssbr.drawSelectionBox(player, currentItem, target, partialTicks);
            return true;
        }
        return false;
    }

    @Override
    public void sendItemStackNBTTagFromClientToServerPlayer(EntityPlayer player, int slotNumber, String fieldName, int fieldValue) {
        ByteBuf bb = Unpooled.buffer((int)36);
        ByteBufOutputStream byteBufOutputStream = new ByteBufOutputStream(bb);
        try {
            byteBufOutputStream.write(0);
            byteBufOutputStream.writeInt(player.func_145782_y());
            byteBufOutputStream.writeInt(player.field_70170_p.field_73011_w.field_76574_g);
            byteBufOutputStream.writeInt(slotNumber);
            byteBufOutputStream.writeInt(fieldValue);
            byteBufOutputStream.writeUTF(fieldName);
            channel.sendToServer(new FMLProxyPacket(byteBufOutputStream.buffer(), "ihl"));
            byteBufOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void requestTileEntityInitdataFromClientToServer(int x, int y, int z) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ByteBuf bb = Unpooled.buffer((int)36);
        ByteBufOutputStream byteBufOutputStream = new ByteBufOutputStream(bb);
        try {
            byteBufOutputStream.write(1);
            byteBufOutputStream.writeInt(player.func_145782_y());
            byteBufOutputStream.writeInt(player.field_70170_p.field_73011_w.field_76574_g);
            byteBufOutputStream.writeInt(x);
            byteBufOutputStream.writeInt(y);
            byteBufOutputStream.writeInt(z);
            channel.sendToServer(new FMLProxyPacket(byteBufOutputStream.buffer(), "ihl"));
            byteBufOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void sendIntegerFieldValueFromClientToServer(int value, String fieldName, TileEntity tileEntity) {
        ByteBuf bb = Unpooled.buffer((int)64);
        ByteBufOutputStream byteBufOutputStream = new ByteBufOutputStream(bb);
        try {
            byteBufOutputStream.write(2);
            byteBufOutputStream.writeInt(tileEntity.func_145831_w().field_73011_w.field_76574_g);
            byteBufOutputStream.writeInt(tileEntity.field_145851_c);
            byteBufOutputStream.writeInt(tileEntity.field_145848_d);
            byteBufOutputStream.writeInt(tileEntity.field_145849_e);
            byteBufOutputStream.writeInt(value);
            byteBufOutputStream.writeUTF(fieldName);
            channel.sendToServer(new FMLProxyPacket(byteBufOutputStream.buffer(), "ihl"));
            byteBufOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

