/*
 * Decompiled with CFR 0.152.
 */
package ihl.items_blocks;

import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.tile.IEnergyTile;
import ihl.IHLCreativeTab;
import ihl.IHLMod;
import ihl.flexible_cable.AnchorTileEntity;
import ihl.flexible_cable.NodeEntity;
import ihl.flexible_cable.PowerCableNodeEntity;
import ihl.interfaces.ICableHolder;
import ihl.interfaces.IEnergyNetNode;
import ihl.interfaces.IMultiPowerCableHolder;
import ihl.interfaces.IWire;
import ihl.utils.IHLUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class FlexibleCableItem
extends Item
implements IWire {
    public static FlexibleCableItem instance;
    public final Set<String> yellowColoredWires = new HashSet<String>(3);

    public FlexibleCableItem() {
        this.yellowColoredWires.add("Gold");
        this.yellowColoredWires.add("Copper");
        this.yellowColoredWires.add("Bronze");
        this.func_77637_a(IHLCreativeTab.tab);
        this.func_77625_d(1);
        this.func_77664_n();
        instance = this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List itemList) {
        itemList.add(IHLUtils.getUninsulatedWire("Copper", 160, 15));
        itemList.add(IHLUtils.getUninsulatedWire("Copper", 160, 240));
        itemList.add(IHLUtils.getUninsulatedWire("Steel", 160, 15));
        itemList.add(IHLUtils.getUninsulatedWire("Steel", 160, 240));
        itemList.add(IHLUtils.getInsulatedWire("Copper", 160, 15, "RawRubber", 100));
        itemList.add(IHLUtils.getInsulatedWire("Copper", 160, 240, "RawRubber", 100));
        itemList.add(IHLUtils.getInsulatedWire("Steel", 160, 15, "RawRubber", 100));
        itemList.add(IHLUtils.getInsulatedWire("Steel", 160, 240, "RawRubber", 100));
        itemList.add(IHLUtils.getInsulatedWire("Copper", 160, 15, "Rubber", 100));
        itemList.add(IHLUtils.getInsulatedWire("Copper", 160, 240, "Rubber", 100));
        itemList.add(IHLUtils.getInsulatedWire("Steel", 160, 15, "Rubber", 100));
        itemList.add(IHLUtils.getInsulatedWire("Steel", 160, 240, "Rubber", 100));
    }

    public static void init() {
        GameRegistry.registerItem((Item)new FlexibleCableItem(), (String)"copperWire");
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        TileEntity t = world.func_147438_o(x, y, z);
        short facing = IHLUtils.getFacingFromPlayerView((EntityLivingBase)player, true);
        if (!world.field_72995_K && t instanceof IEnergyTile && !(t instanceof IMultiPowerCableHolder) && !(t instanceof ICableHolder)) {
            ForgeDirection direction = ForgeDirection.getOrientation((int)facing);
            t = world.func_147438_o(x += direction.offsetX, y += direction.offsetY, z += direction.offsetZ);
            if (IHLUtils.isBlockCanBeReplaced(world, x, y, z)) {
                world.func_147449_b(x, y, z, IHLMod.cableAnchorBlock);
            } else if (!(t instanceof AnchorTileEntity)) {
                return false;
            }
            t = world.func_147438_o(x, y, z);
        }
        if (world.field_72995_K) {
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "step.stone", 1.0f, 0.8f);
        }
        if (!world.field_72995_K && t != null && (t instanceof IEnergyNetNode || t instanceof IMultiPowerCableHolder) && stack.field_77990_d.func_74762_e("fullLength") >= 1) {
            ICableHolder te;
            if (t instanceof IMultiPowerCableHolder) {
                facing = ((IMultiPowerCableHolder)t).getSide(player);
                if (facing == -1) {
                    return false;
                }
                te = ((IMultiPowerCableHolder)t).getEnergyNetNode(facing);
            } else {
                te = (ICableHolder)t;
            }
            double ppx = te.getPortPos((EntityLivingBase)player)[0];
            double ppy = te.getPortPos((EntityLivingBase)player)[1];
            double ppz = te.getPortPos((EntityLivingBase)player)[2];
            if (stack.field_77990_d.func_74767_n("firstConnection")) {
                int x1 = stack.field_77990_d.func_74762_e("connectorX");
                int y1 = stack.field_77990_d.func_74762_e("connectorY");
                int z1 = stack.field_77990_d.func_74762_e("connectorZ");
                int l1 = stack.field_77990_d.func_74762_e("fullLength");
                int l2 = stack.field_77990_d.func_74762_e("length");
                if (x == x1 && y == y1 && z == z1) {
                    this.cleanUp(stack.field_77990_d.func_74762_e("chainUID"));
                    stack.field_77990_d.func_74757_a("firstConnection", false);
                    stack.field_77990_d.func_74768_a("length", l1);
                    return true;
                }
                int t2DimensionId = stack.field_77990_d.func_74762_e("connectorDimensionId");
                short facing2 = stack.field_77990_d.func_74765_d("connectorFacing");
                TileEntity t2 = MinecraftServer.func_71276_C().func_71218_a(t2DimensionId).func_147438_o(x1, y1, z1);
                if (t2 == null) {
                    stack.field_77990_d.func_74757_a("firstConnection", false);
                    return false;
                }
                if (t instanceof IMultiPowerCableHolder) {
                    facing = ((IMultiPowerCableHolder)t).getSide(player);
                    if (facing == -1) {
                        return false;
                    }
                    te = ((IMultiPowerCableHolder)t).getEnergyNetNode(facing);
                } else {
                    te = (ICableHolder)t;
                }
                te.setCableCheck(true);
                this.connect(t, facing, t2, facing2, stack);
                stack.field_77990_d.func_74768_a("fullLength", l2);
                if (l2 <= 0) {
                    --stack.field_77994_a;
                }
                stack.field_77990_d.func_74757_a("firstConnection", false);
                stack.field_77990_d.func_74768_a("chainArrangeNumber", stack.field_77990_d.func_74762_e("chainArrangeNumber") + 1);
                x = x1;
                y = y1;
                z = z1;
            } else {
                te.setCableCheck(false);
                stack.field_77990_d.func_74757_a("firstConnection", true);
                stack.field_77990_d.func_74768_a("connectorX", x);
                stack.field_77990_d.func_74768_a("connectorY", y);
                stack.field_77990_d.func_74768_a("connectorZ", z);
                stack.field_77990_d.func_74777_a("connectorFacing", facing);
                stack.field_77990_d.func_74768_a("connectorDimensionId", world.field_73011_w.field_76574_g);
                stack.field_77990_d.func_74768_a("prevDimensionId", world.field_73011_w.field_76574_g);
                stack.field_77990_d.func_74768_a("chainArrangeNumber", 0);
                stack.field_77990_d.func_74768_a("chainUID", world.field_73012_v.nextInt());
                stack.field_77990_d.func_74780_a("prevNodePosX", ppx);
                stack.field_77990_d.func_74780_a("prevNodePosY", ppy);
                stack.field_77990_d.func_74780_a("prevNodePosZ", ppz);
            }
            NodeEntity node = this.newNode(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack, stack.field_77990_d.func_74762_e("chainArrangeNumber"), x, y, z);
            node.virtualNodePosX = ppx;
            node.virtualNodePosY = ppy;
            node.virtualNodePosZ = ppz;
            return true;
        }
        return false;
    }

    protected void connect(TileEntity t1, short facing, TileEntity t2, short facing2, ItemStack stack) {
        IEnergyNetNode te = t1 instanceof IEnergyNetNode ? (IEnergyNetNode)t1 : ((IMultiPowerCableHolder)t1).getEnergyNetNode(facing);
        IEnergyNetNode te1 = t2 instanceof IEnergyNetNode ? (IEnergyNetNode)t2 : ((IMultiPowerCableHolder)t2).getEnergyNetNode(facing2);
        int newGridID = IHLMod.enet.mergeGrids(te.getGridID(), te1.getGridID());
        int l1 = stack.field_77990_d.func_74762_e("fullLength");
        int l2 = stack.field_77990_d.func_74762_e("length");
        NBTTagCompound cable = (NBTTagCompound)stack.field_77990_d.func_74737_b();
        cable.func_74768_a("length", l1 - l2);
        cable.func_74757_a("firstConnection", false);
        cable.func_74768_a("connectorX1", t1.field_145851_c);
        cable.func_74768_a("connectorY1", t1.field_145848_d);
        cable.func_74768_a("connectorZ1", t1.field_145849_e);
        cable.func_74777_a("connectorFacing1", facing);
        cable.func_74768_a("connectorDimensionId1", t1.func_145831_w().field_73011_w.field_76574_g);
        if (te.addCable(cable) && te1.addCable(cable)) {
            te.setGrid(newGridID);
            te1.setGrid(newGridID);
        }
    }

    private int getTransverseSection(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        return stack.field_77990_d.func_74762_e("transverseSection");
    }

    public String getMaterial(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        return stack.field_77990_d.func_74779_i("material");
    }

    public int getVoltageLimit(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        if (stack.field_77990_d.func_74764_b("maxVoltage")) {
            return stack.field_77990_d.func_74762_e("maxVoltage");
        }
        return 0;
    }

    private long getResistance(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        return IHLUtils.getResistance(stack.field_77990_d);
    }

    private void cleanUp(int uid) {
        Set<NodeEntity> cs = IHLMod.proxy.nodeEntityRegistry.get(uid);
        if (cs != null) {
            for (NodeEntity ne : cs) {
                if (ne == null) continue;
                ne.func_70106_y();
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotIndex, boolean isCurrentItem) {
        int leight;
        if (!world.field_72995_K && stack.field_77990_d != null && stack.field_77990_d.func_74767_n("firstConnection") && (leight = stack.field_77990_d.func_74762_e("length")) > 0) {
            double sqd;
            double pnpx = stack.field_77990_d.func_74769_h("prevNodePosX");
            double pnpy = stack.field_77990_d.func_74769_h("prevNodePosY");
            double pnpz = stack.field_77990_d.func_74769_h("prevNodePosZ");
            double ppx = entity.field_70165_t;
            double ppy = entity.field_70163_u;
            double ppz = entity.field_70161_v;
            if (pnpx != 0.0 && pnpy != 0.0 && pnpz != 0.0 && (sqd = (ppx - pnpx) * (ppx - pnpx) + (ppy - pnpy) * (ppy - pnpy) + (ppz - pnpz) * (ppz - pnpz)) > 2.0) {
                int can = stack.field_77990_d.func_74762_e("chainArrangeNumber") + 1;
                int cx = stack.field_77990_d.func_74762_e("connectorX");
                int cy = stack.field_77990_d.func_74762_e("connectorY");
                int cz = stack.field_77990_d.func_74762_e("connectorZ");
                NodeEntity node = this.newNode(world, ppx, ppy, ppz, stack, can, cx, cy, cz);
                node.shouldFollowPlayer = true;
                node.virtualNodePosX = ppx + (ppx - pnpx) * 2.0;
                node.virtualNodePosY = ppy + (ppy - pnpy) * 2.0;
                node.virtualNodePosZ = ppz + (ppz - pnpz) * 2.0;
                stack.field_77990_d.func_74768_a("chainArrangeNumber", can);
                stack.field_77990_d.func_74780_a("prevNodePosX", ppx);
                stack.field_77990_d.func_74780_a("prevNodePosY", ppy);
                stack.field_77990_d.func_74780_a("prevNodePosZ", ppz);
                stack.field_77990_d.func_74768_a("length", --leight);
                stack.field_77990_d.func_74768_a("prevDimensionId", world.field_73011_w.field_76574_g);
            }
        }
    }

    public void onPlayerTeleport(PlayerEvent.PlayerChangedDimensionEvent event) {
        EntityPlayer player = event.player;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || !(stack.func_77973_b() instanceof FlexibleCableItem) || !stack.field_77990_d.func_74767_n("firstConnection")) continue;
            int can = -1;
            Set<NodeEntity> ns = IHLMod.proxy.nodeEntityRegistry.get(stack.field_77990_d.func_74762_e("chainUID"));
            if (ns != null) {
                NodeEntity lastNode = null;
                for (NodeEntity node : ns) {
                    node.shouldFollowPlayer = false;
                    if (node.chainArrangeNumber <= can) continue;
                    lastNode = node;
                    can = node.chainArrangeNumber;
                }
                if (lastNode != null) {
                    lastNode.setVirtualNodePosToNearestPortal();
                }
            }
            double[] cc = IHLUtils.tracePlayerView((EntityLivingBase)player);
            can = stack.field_77990_d.func_74762_e("chainArrangeNumber") + 1;
            int cx = stack.field_77990_d.func_74762_e("connectorX");
            int cy = stack.field_77990_d.func_74762_e("connectorY");
            int cz = stack.field_77990_d.func_74762_e("connectorZ");
            int leight = stack.field_77990_d.func_74762_e("length");
            NodeEntity node = this.newNode((World)MinecraftServer.func_71276_C().func_71218_a(event.toDim), cc[0], player.field_70163_u, cc[2], stack, can, cx, cy, cz);
            node.setVirtualNodePosToNearestPortal();
            stack.field_77990_d.func_74768_a("chainArrangeNumber", can);
            stack.field_77990_d.func_74780_a("prevNodePosX", cc[0]);
            stack.field_77990_d.func_74780_a("prevNodePosY", cc[1]);
            stack.field_77990_d.func_74780_a("prevNodePosZ", cc[2]);
            stack.field_77990_d.func_74768_a("length", --leight);
            stack.field_77990_d.func_74768_a("prevDimensionId", event.toDim);
        }
    }

    protected NodeEntity newNode(World world, double ppx, double ppy, double ppz, ItemStack stack, int can, int x, int y, int z) {
        PowerCableNodeEntity node = new PowerCableNodeEntity(world);
        node.func_70107_b(ppx, ppy, ppz);
        node.setChainUniqueID(stack.field_77990_d.func_74762_e("chainUID"));
        short facing = stack.field_77990_d.func_74765_d("connectorFacing");
        int dimensionId = stack.field_77990_d.func_74762_e("connectorDimensionId");
        node.setAnchor(x, y, z, facing, dimensionId);
        node.chainArrangeNumber = can;
        node.colorIndex = this.getColor(stack);
        node.addCable((NBTTagCompound)stack.field_77990_d.func_74737_b());
        node.type = stack.field_77990_d.func_74764_b("insulationMaterial") ? 1 : 0;
        world.func_72838_d((Entity)node);
        return node;
    }

    private int getColor(ItemStack stack) {
        if (!stack.field_77990_d.func_74764_b("insulationMaterial")) {
            if (this.yellowColoredWires.contains(this.getMaterial(stack))) {
                return 0xFF9900;
            }
            return 0xAAAABB;
        }
        return 0xFFFFFF;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean flag) {
        if (itemStack.field_77990_d != null) {
            info.add(StatCollector.func_74838_a((String)"ihl.lenght") + ": " + itemStack.field_77990_d.func_74762_e("length") + " m");
            info.add(StatCollector.func_74838_a((String)"ihl.wire_material") + "Wire material: " + this.getMaterial(itemStack));
            info.add(StatCollector.func_74838_a((String)"ihl.resistivity") + "Resistivity: " + (float)this.getResistance(itemStack) / 1000.0f + " V^2/(EU*m)");
            info.add(StatCollector.func_74838_a((String)"ihl.transverse_section") + "Transverse section: " + (float)this.getTransverseSection(itemStack) / 10.0f + " sq. mm.");
            if (itemStack.field_77990_d.func_74764_b("insulationMaterial")) {
                info.add(StatCollector.func_74838_a((String)"ihl.insulation_material") + "Insulation material: " + this.getInsulationMaterial(itemStack));
                info.add(StatCollector.func_74838_a((String)"ihl.insulation_thickness") + "Insulation thickness: " + (float)this.getInsulationThickness(itemStack) / 10.0f + " mm");
                info.add(StatCollector.func_74838_a((String)"ihl.insulation_beakdown_voltage") + "Insulation breakdown voltage: " + this.getVoltageLimit(itemStack) / 1000 + " kV");
            }
            info.add(StatCollector.func_74838_a((String)"ihl.powerCableTooltip"));
        }
    }

    @Override
    public String getTag() {
        return "length";
    }

    @Override
    public String getTagSecondary() {
        return "fullLength";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("ihl:copperWire");
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.field_77990_d != null && !this.getInsulationMaterial(stack).equals("null")) {
            return "cable";
        }
        return "wire";
    }

    @Override
    public boolean isSameWire(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77960_j() == stack2.func_77960_j() && stack1.field_77990_d != null && stack2.field_77990_d != null) {
            return this.getMaterial(stack1).equals(this.getMaterial(stack2)) && this.getTransverseSection(stack1) == this.getTransverseSection(stack2) && this.getInsulationMaterial(stack1).equals(this.getInsulationMaterial(stack2)) && this.getInsulationThickness(stack1) == this.getInsulationThickness(stack2);
        }
        return false;
    }

    public String getInsulationMaterial(ItemStack stack) {
        if (stack.field_77990_d.func_74764_b("insulationMaterial")) {
            return stack.field_77990_d.func_74779_i("insulationMaterial");
        }
        return "null";
    }

    public int getInsulationThickness(ItemStack stack) {
        if (stack.field_77990_d.func_74764_b("insulationThickness")) {
            return stack.field_77990_d.func_74762_e("insulationThickness");
        }
        return 0;
    }
}

