/*
 * Decompiled with CFR 0.152.
 */
package ihl.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;

@SideOnly(value=Side.CLIENT)
public class RenderInfo {
    public Block template = Blocks.field_150348_b;
    public IIcon[] texture = null;
    public IIcon override = null;
    public float minX = 0.0f;
    public float minY = 0.0f;
    public float minZ = 0.0f;
    public float maxX = 1.0f;
    public float maxY = 1.0f;
    public float maxZ = 1.0f;
    public boolean[] renderSide = new boolean[6];
    public float light = -1.0f;
    public int brightness = -1;

    public RenderInfo() {
        this.setRenderAllSides();
    }

    public RenderInfo(Block template, IIcon[] texture) {
        this();
        this.template = template;
        this.texture = texture;
    }

    public RenderInfo(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this();
        this.setBlockBounds(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public final void setBlockBounds(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public final void setRenderSingleSide(int side) {
        Arrays.fill(this.renderSide, false);
        this.renderSide[side] = true;
    }

    public final void setRenderAllSides() {
        Arrays.fill(this.renderSide, true);
    }

    public IIcon getBlockTextureFromSide(int i) {
        if (this.override != null) {
            return this.override;
        }
        if (this.texture == null || this.texture.length == 0) {
            return this.template.func_149733_h(i);
        }
        if (i >= this.texture.length) {
            i = 0;
        }
        return this.texture[i];
    }
}

