/*
 * Decompiled with CFR 0.152.
 */
package ihl.nei_integration;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import ic2.core.util.StackUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public abstract class IHLRecipeHandler
extends TemplateRecipeHandler {
    protected int ticks;

    public abstract String getRecipeName();

    public abstract String getRecipeId();

    public abstract String getGuiTexture();

    public abstract String getOverlayIdentifier();

    public abstract Map<IRecipeInput, RecipeOutput> getRecipeList();

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)140, (int)65);
    }

    public void drawExtras(int i) {
        float f = this.ticks >= 20 ? (float)((this.ticks - 20) % 20) / 20.0f : 0.0f;
        this.drawProgressBar(74, 23, 176, 14, 25, 16, f, 0);
        f = this.ticks <= 20 ? (float)this.ticks / 20.0f : 1.0f;
        this.drawProgressBar(51, 25, 176, 0, 14, 14, f, 3);
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticks;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 25, 16), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<IRecipeInput, RecipeOutput> entry : this.getRecipeList().entrySet()) {
                this.arecipes.add(new CachedIORecipe(entry.getKey(), entry.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        block0: for (Map.Entry<IRecipeInput, RecipeOutput> entry : this.getRecipeList().entrySet()) {
            for (ItemStack output : entry.getValue().items) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)output, (ItemStack)result)) continue;
                this.arecipes.add(new CachedIORecipe(entry.getKey(), entry.getValue()));
                continue block0;
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<IRecipeInput, RecipeOutput> entry : this.getRecipeList().entrySet()) {
            if (!entry.getKey().matches(ingredient)) continue;
            this.arecipes.add(new CachedIORecipe(entry.getKey(), entry.getValue()));
        }
    }

    protected int getInputPosX() {
        return 51;
    }

    protected int getInputPosY() {
        return 6;
    }

    protected int getOutputPosX() {
        return 111;
    }

    protected int getOutputPosY() {
        return 24;
    }

    protected boolean isOutputsVertical() {
        return true;
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final List<PositionedStack> ingredients;
        private final PositionedStack output;
        private final List<PositionedStack> otherStacks;

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(IHLRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.otherStacks;
        }

        public CachedIORecipe(ItemStack input, ItemStack output1) {
            super((TemplateRecipeHandler)IHLRecipeHandler.this);
            this.ingredients = new ArrayList<PositionedStack>();
            this.otherStacks = new ArrayList<PositionedStack>();
            if (input == null) {
                throw new NullPointerException("Input must not be null (recipe " + input + " -> " + output1 + ").");
            }
            if (output1 == null) {
                throw new NullPointerException("Output must not be null (recipe " + input + " -> " + output1 + ").");
            }
            this.ingredients.add(new PositionedStack((Object)input, IHLRecipeHandler.this.getInputPosX(), IHLRecipeHandler.this.getInputPosY()));
            this.output = new PositionedStack((Object)output1, IHLRecipeHandler.this.getOutputPosX(), IHLRecipeHandler.this.getOutputPosY());
        }

        public CachedIORecipe(IRecipeInput input, RecipeOutput output1) {
            super((TemplateRecipeHandler)IHLRecipeHandler.this);
            this.ingredients = new ArrayList<PositionedStack>();
            this.otherStacks = new ArrayList<PositionedStack>();
            if (input == null) {
                throw new NullPointerException("Input must not be null (recipe " + input + " -> " + output1 + ").");
            }
            if (output1 == null) {
                throw new NullPointerException("Output must not be null (recipe " + input + " -> " + output1 + ").");
            }
            if (output1.items.isEmpty()) {
                throw new IllegalArgumentException("Output must not be empty (recipe " + input + " -> " + output1 + ").");
            }
            if (output1.items.contains(null)) {
                throw new IllegalArgumentException("Output must not contain null (recipe " + input + " -> " + output1 + ").");
            }
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (ItemStack item : input.getInputs()) {
                items.add(StackUtil.copyWithSize((ItemStack)item, (int)input.getAmount()));
            }
            this.ingredients.add(new PositionedStack(items, IHLRecipeHandler.this.getInputPosX(), IHLRecipeHandler.this.getInputPosY()));
            this.output = new PositionedStack(output1.items.get(0), IHLRecipeHandler.this.getOutputPosX(), IHLRecipeHandler.this.getOutputPosY());
            for (int var7 = 1; var7 < output1.items.size(); ++var7) {
                if (IHLRecipeHandler.this.isOutputsVertical()) {
                    this.otherStacks.add(new PositionedStack(output1.items.get(var7), IHLRecipeHandler.this.getOutputPosX(), IHLRecipeHandler.this.getOutputPosY() + var7 * 18));
                    continue;
                }
                this.otherStacks.add(new PositionedStack(output1.items.get(var7), IHLRecipeHandler.this.getOutputPosX() + var7 * 18, IHLRecipeHandler.this.getOutputPosY()));
            }
        }
    }
}

