/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.metallurgy;

import ic2.core.IC2;
import ihl.metallurgy.constants.Details;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

public class InjectionMoldTileEntity
extends TileEntity
implements IFluidHandler {
    public short timer = (short)100;
    public String resultSuffix;
    public boolean isContainStearin = false;
    public short maxAmount = Short.MAX_VALUE;
    public ItemStack result;
    public ItemStack result2;
    private final FluidTank fluidTank = new FluidTank(864);
    protected static final UniversalRecipeManager recipeManager = new UniversalRecipeManager("injectionmold");

    public static void addRecipe(FluidStack input, ItemStack input1, ItemStack output) {
        recipeManager.addRecipe(new UniversalRecipeInput(new FluidStack[]{input}, new ItemStack[]{input1}), new UniversalRecipeOutput(null, new ItemStack[]{output}, 20));
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.fluidTank.readFromNBT(nbttagcompound.func_74775_l("fluidTank"));
        this.resultSuffix = nbttagcompound.func_74779_i("resultSuffix");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagCompound fluidTankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(fluidTankTag);
        nbttagcompound.func_74782_a("fluidTank", (NBTBase)fluidTankTag);
        nbttagcompound.func_74778_a("resultSuffix", this.resultSuffix);
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_145845_h() {
        if (this.getFluidStackfromTank() != null && this.getFluidStackfromTank().amount > 16) {
            String formattedFluidName;
            short s = this.timer;
            this.timer = (short)(s - 1);
            if (s == 0 && (formattedFluidName = this.getFormattedMaterialName(this.getFluidfromTank().getName())) != "") {
                int stackSize1;
                int fluidAmountPerItem = Details.getMeltingFluidAmount(this.resultSuffix);
                ArrayList<ItemStack> resultList = OreDictionary.getOres((String)(this.resultSuffix + formattedFluidName));
                if (resultList.isEmpty() || fluidAmountPerItem <= 0) {
                    List<ItemStack> ii;
                    resultList = new ArrayList<ItemStack>();
                    List<FluidStack> fi = Arrays.asList(this.fluidTank.getFluid());
                    UniversalRecipeOutput ro = recipeManager.getOutputFor(fi, ii = Arrays.asList(IHLUtils.getThisModItemStackWithDamage("injectionMold", this.resultSuffix.hashCode() & Integer.MAX_VALUE)));
                    if (ro != null) {
                        ItemStack stack = ro.getItemOutputs().get((int)0).itemStack.func_77946_l();
                        stack.field_77994_a = Math.round(ro.getItemOutputs().get((int)0).quantity);
                        resultList.add(stack);
                        UniversalRecipeInput ri = recipeManager.getRecipeInput(fi, ii);
                        fluidAmountPerItem = ri.getFluidInputs().get(0).getAmount();
                    }
                }
                int fluidAmountPerItem2 = Details.getMeltingFluidAmount("nugget");
                ArrayList resultList2 = OreDictionary.getOres((String)("nugget" + formattedFluidName));
                if (!resultList.isEmpty() && fluidAmountPerItem > 0 && (stackSize1 = Math.min(this.maxAmount, this.getFluidStackfromTank().amount / fluidAmountPerItem)) > 0) {
                    this.result = ((ItemStack)resultList.get(0)).func_77946_l();
                    this.result.field_77994_a = stackSize1;
                }
                if (!resultList2.isEmpty()) {
                    stackSize1 = this.getFluidStackfromTank().amount / fluidAmountPerItem2;
                    if (this.result != null) {
                        stackSize1 = this.getFluidStackfromTank().amount % fluidAmountPerItem / fluidAmountPerItem2;
                    }
                    if (stackSize1 > 0) {
                        this.result2 = ((ItemStack)resultList2.get(0)).func_77946_l();
                        this.result2.field_77994_a = stackSize1;
                    }
                }
            }
        }
    }

    public boolean canDrain(ForgeDirection arg0, Fluid arg1) {
        return false;
    }

    public boolean canFill(ForgeDirection direction, Fluid fluid1) {
        return direction == ForgeDirection.UP && !this.isContainStearin;
    }

    public String getInventoryName() {
        return "injectionMold";
    }

    private String getFormattedMaterialName(String input) {
        String input2 = input.replace("molten.", "").replace(".molten", "");
        String firstletter = String.valueOf(input2.charAt(0)).toUpperCase();
        input2 = input2.replaceFirst(".", firstletter);
        return input2;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public FluidStack getFluidStackfromTank() {
        return this.getFluidTank().getFluid();
    }

    public Fluid getFluidfromTank() {
        return this.getFluidStackfromTank().getFluid();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.canFill(from, resource.getFluid()) ? this.getFluidTank().fill(resource, doFill) : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.getFluidTank().drain(maxDrain, doDrain);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.getFluidTank().getInfo()};
    }

    public void dropContents() {
        if (this.result != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.result));
        }
        if (this.result2 != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.result2));
        }
    }

    public static Map<UniversalRecipeInput, UniversalRecipeOutput> getRecipes() {
        return recipeManager.getRecipes();
    }
}

