/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.metallurgy;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.network.NetworkManager;
import ihl.processing.chemistry.ApparatusProcessableInvSlot;
import ihl.recipes.UniversalRecipeOutput;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class MachineBaseTileEntity
extends TileEntityInventory
implements IHasGui,
IEnergySink {
    public short progress;
    protected short operationLength = (short)200;
    protected double energy;
    public int maxStorage;
    public int energyConsume;
    public final ApparatusProcessableInvSlot input;
    private boolean addedToEnergyNet = false;

    public MachineBaseTileEntity(int inputCount) {
        this.input = new ApparatusProcessableInvSlot(this, "input", 0, InvSlot.Access.IO, inputCount, 64);
        this.maxStorage = 128;
        this.energyConsume = 5;
    }

    public List<String> getNetworkedFields() {
        List fields = super.getNetworkedFields();
        return fields;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74765_d("progress");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("progress", this.progress);
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != (short)side;
    }

    public void setFacing(short facing1) {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        super.setFacing(facing1);
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public abstract String getStartSoundFile();

    public abstract String getLoopSoundFile();

    public abstract String getStopSoundFile();

    public void updateEntityServer() {
        if (this.energy > (double)this.maxStorage) {
            this.energy = this.maxStorage;
        }
        if (this.canOperate() && this.energy >= (double)this.energyConsume) {
            this.setActive(true);
            if (this.progress == 0) {
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 0, true);
            }
            this.progress = (short)(this.progress + 1);
            this.energy -= (double)this.energyConsume;
            if (this.progress >= this.operationLength) {
                this.operate();
                this.progress = 0;
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 2, true);
            }
        } else {
            if (this.progress != 0 && this.getActive()) {
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 1, true);
            }
            if (!this.canOperate()) {
                this.progress = 0;
            }
            this.setActive(false);
        }
    }

    protected int mX() {
        switch (this.getFacing()) {
            case 4: {
                return 1;
            }
            case 5: {
                return -1;
            }
        }
        return 0;
    }

    protected int mY() {
        switch (this.getFacing()) {
            case 0: {
                return -1;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    protected int mZ() {
        switch (this.getFacing()) {
            case 2: {
                return 1;
            }
            case 3: {
                return -1;
            }
        }
        return 0;
    }

    public abstract String func_145825_b();

    @SideOnly(value=Side.CLIENT)
    public abstract GuiScreen getGui(EntityPlayer var1, boolean var2);

    public abstract ContainerBase<?> getGuiContainer(EntityPlayer var1);

    public void onGuiClosed(EntityPlayer arg0) {
    }

    public int gaugeProgressScaled(int i) {
        return this.progress * i / this.operationLength;
    }

    public boolean canOperate() {
        return this.getOutput() != null;
    }

    public abstract UniversalRecipeOutput getOutput();

    public List[] getInput() {
        return new List[]{null, this.input.getItemStackList()};
    }

    public double getDemandedEnergy() {
        return (double)this.maxStorage - this.energy;
    }

    public int getSinkTier() {
        return 4;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy >= (double)this.maxStorage) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public abstract void operate();

    public short getEnergy() {
        return (short)this.energy;
    }

    public void setEnergy(int value) {
        this.energy = value;
    }

    public int getGUIEnergy(int i) {
        if (this.energy < 3.4028234663852886E38) {
            return Math.round((float)this.energy / (float)this.maxStorage * (float)i);
        }
        return Math.round((float)(this.energy / (double)this.maxStorage) * (float)i);
    }
}

