/*
 * Decompiled with CFR 0.152.
 */
package ihl.recipes;

import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ihl.interfaces.IWire;
import ihl.recipes.IRecipeInputFluid;
import ihl.recipes.RecipeInputFluidStack;
import ihl.recipes.RecipeInputWire;
import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class UniversalRecipeInput {
    private final List<IRecipeInputFluid> fluidInputs = new ArrayList<IRecipeInputFluid>();
    private final List<IRecipeInput> itemInputs = new ArrayList<IRecipeInput>();

    public UniversalRecipeInput(Object[] fluidStacks, Object[] iRecipeInputs) {
        if (fluidStacks != null) {
            for (Object material : fluidStacks) {
                if (material == null) {
                    throw new NullPointerException("Recipe input cannot be null!");
                }
                if (material instanceof FluidStack) {
                    this.fluidInputs.add(new RecipeInputFluidStack((FluidStack)material));
                    continue;
                }
                this.fluidInputs.add((IRecipeInputFluid)material);
            }
        }
        if (iRecipeInputs != null) {
            for (Object material : iRecipeInputs) {
                if (material == null) {
                    throw new NullPointerException("Recipe input cannot be null!");
                }
                if (material instanceof ItemStack) {
                    ItemStack stack = (ItemStack)material;
                    String oreDictName = IHLUtils.getFirstOreDictNameExcludingTagAny(stack);
                    if (stack.func_77973_b() instanceof IWire) {
                        this.itemInputs.add(new RecipeInputWire(stack));
                        continue;
                    }
                    if (!oreDictName.isEmpty() && oreDictName.length() > 3) {
                        this.itemInputs.add((IRecipeInput)new RecipeInputOreDict(oreDictName, stack.field_77994_a));
                        continue;
                    }
                    this.itemInputs.add((IRecipeInput)new RecipeInputItemStack(stack));
                    continue;
                }
                this.itemInputs.add((IRecipeInput)material);
            }
        }
    }

    public boolean matches(List<FluidStack> fluidInputs1, List<ItemStack> itemInputs1) {
        return this.matches(fluidInputs1, itemInputs1, false);
    }

    public List<IRecipeInputFluid> getFluidInputs() {
        return this.fluidInputs;
    }

    public List<IRecipeInput> getItemInputs() {
        return this.itemInputs;
    }

    public boolean matches(UniversalRecipeInput input) {
        List<IRecipeInput> rInputs = input.getItemInputs();
        Iterator<IRecipeInput> ii = rInputs.iterator();
        ArrayList<ItemStack> rInputsItems = new ArrayList<ItemStack>();
        while (ii.hasNext()) {
            IRecipeInput is = ii.next();
            rInputsItems.add((ItemStack)is.getInputs().get(0));
        }
        ArrayList<FluidStack> rInputsFluids = new ArrayList<FluidStack>();
        List<IRecipeInputFluid> rInputsF = input.getFluidInputs();
        for (IRecipeInputFluid is : rInputsF) {
            rInputsFluids.add(is.getInputs().get(0));
        }
        return this.matches(rInputsFluids, rInputsItems);
    }

    public boolean matches(List<FluidStack> fluidInputs1, List<ItemStack> itemInputs1, boolean doCheckAmounts) {
        if (this.incorrectInputAmount(fluidInputs1, itemInputs1)) {
            return false;
        }
        if (fluidInputs1 != null) {
            for (IRecipeInputFluid fs : this.fluidInputs) {
                FluidStack fs1 = this.getMatchedFluidStack(fs, fluidInputs1);
                if (fs1 == null || !fs.matches(fs1)) {
                    return false;
                }
                if (!doCheckAmounts || fs1.amount >= fs.getAmount()) continue;
                return false;
            }
        }
        if (itemInputs1 != null) {
            for (IRecipeInput is : this.itemInputs) {
                ItemStack is1 = this.getMatchedItemStack(is, itemInputs1);
                if (is1 == null || !is.matches(is1)) {
                    return false;
                }
                if (!doCheckAmounts || is1.field_77994_a >= is.getAmount()) continue;
                return false;
            }
        }
        return true;
    }

    private ItemStack getMatchedItemStack(IRecipeInput is, List<ItemStack> itemInputs1) {
        for (ItemStack is1 : itemInputs1) {
            if (is1 == null || !is.matches(is1)) continue;
            return is1;
        }
        return null;
    }

    private FluidStack getMatchedFluidStack(IRecipeInputFluid fs, List<FluidStack> fluidInputs1) {
        for (FluidStack fs1 : fluidInputs1) {
            if (!fs.matches(fs1)) continue;
            return fs1;
        }
        return null;
    }

    public boolean containItemStack(ItemStack ingredient) {
        if (this.itemInputs == null || this.itemInputs.isEmpty()) {
            return false;
        }
        for (IRecipeInput is : this.itemInputs) {
            if (!is.matches(ingredient)) continue;
            return true;
        }
        return false;
    }

    public boolean containFluidStack(FluidStack fluidStack) {
        if (this.fluidInputs == null || this.fluidInputs.isEmpty()) {
            return false;
        }
        for (IRecipeInputFluid is : this.fluidInputs) {
            if (is == null || !is.matches(fluidStack)) continue;
            return true;
        }
        return false;
    }

    private boolean incorrectInputAmount(List<FluidStack> fluidInputs1, List<ItemStack> itemInputs1) {
        return this.fluidInputs.size() > 0 && fluidInputs1 == null || this.itemInputs.size() > 0 && itemInputs1 == null || fluidInputs1 != null && this.fluidInputs.size() > fluidInputs1.size() || itemInputs1 != null && this.itemInputs.size() > itemInputs1.size();
    }
}

