/*
 * Decompiled with CFR 0.152.
 */
package ihl.worldgen.ores;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ihl.worldgen.ores.DebugScannerContainer;
import ihl.worldgen.ores.DebugScannerGui;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.oredict.OreDictionary;

public class DebugScannerTileEntity
extends TileEntityInventory
implements IHasGui {
    public final InvSlot itemsSlot;
    private ItemStack lastItem;
    public List<String> oreDictionaryEntries = new ArrayList<String>();

    public DebugScannerTileEntity() {
        this.itemsSlot = new InvSlot((TileEntityInventory)this, "drainInput", 0, InvSlot.Access.I, 2);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != (short)side && side != 0 && side != 1;
    }

    public void updateEntityClient() {
        if (IC2.platform.isRendering()) {
            if (this.itemsSlot.get(0) != null && this.itemsSlot.get(0) != this.lastItem) {
                this.oreDictionaryEntries.clear();
                int[] ids = OreDictionary.getOreIDs((ItemStack)this.itemsSlot.get());
                String itemNameFromIR = Item.field_150901_e.func_148750_c((Object)this.itemsSlot.get().func_77973_b());
                this.oreDictionaryEntries.add("ItemRegistry entry:");
                this.oreDictionaryEntries.add(" " + itemNameFromIR);
                this.oreDictionaryEntries.add("Item damage: " + this.itemsSlot.get().func_77960_j());
                this.oreDictionaryEntries.add("Item class:");
                this.oreDictionaryEntries.add(" " + this.itemsSlot.get().func_77973_b().getClass().getCanonicalName());
                if (this.itemsSlot.get().field_77990_d != null) {
                    this.oreDictionaryEntries.add("NBT keys:");
                    for (String entry : this.itemsSlot.get().field_77990_d.func_150296_c()) {
                        if (this.itemsSlot.get().field_77990_d.func_74781_a(entry) instanceof NBTTagCompound) {
                            this.oreDictionaryEntries.add(" " + entry);
                            NBTTagCompound ct = this.itemsSlot.get().field_77990_d.func_74775_l(entry);
                            if (ct == null || ct.func_150296_c() == null || ct.func_150296_c().isEmpty()) continue;
                            this.oreDictionaryEntries.add(" -NBT compound tag subkeys:");
                            for (String entry2 : ct.func_150296_c()) {
                                this.oreDictionaryEntries.add("    " + entry2 + "=" + ct.func_74779_i(entry2));
                            }
                            continue;
                        }
                        this.oreDictionaryEntries.add(" " + entry + "=" + this.itemsSlot.get().field_77990_d.func_74779_i(entry));
                    }
                }
                if (ids.length > 0) {
                    this.oreDictionaryEntries.add("Ore dict. entries:");
                    for (int i = 0; i < ids.length; ++i) {
                        this.oreDictionaryEntries.add(" " + OreDictionary.getOreName((int)ids[i]));
                    }
                }
                this.lastItem = this.itemsSlot.get(0);
            }
            if (this.itemsSlot.get(1) != null && this.itemsSlot.get(1) != this.lastItem) {
                this.oreDictionaryEntries.clear();
                FluidStack fluid = null;
                this.oreDictionaryEntries.add("Fluid related item type:");
                if (this.itemsSlot.get(1).func_77973_b() instanceof IFluidContainerItem) {
                    this.oreDictionaryEntries.add(" IFluidContainerItem");
                    fluid = ((IFluidContainerItem)this.itemsSlot.get(1).func_77973_b()).getFluid(this.itemsSlot.get(1));
                } else if (FluidContainerRegistry.isContainer((ItemStack)this.itemsSlot.get(1))) {
                    this.oreDictionaryEntries.add(" FluidContainerRegistry entry");
                    if (FluidContainerRegistry.isBucket((ItemStack)this.itemsSlot.get(1))) {
                        this.oreDictionaryEntries.add("This is bucket.");
                    } else {
                        this.oreDictionaryEntries.add("This is not a bucket.");
                    }
                    ItemStack emptyContainer = FluidContainerRegistry.drainFluidContainer((ItemStack)this.itemsSlot.get(1));
                    if (emptyContainer != null) {
                        this.oreDictionaryEntries.add("This container could return empty container:");
                        this.oreDictionaryEntries.add(" " + emptyContainer.func_82833_r());
                    } else {
                        this.oreDictionaryEntries.add("This container has no empty version.");
                    }
                    fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.itemsSlot.get(1));
                } else {
                    this.oreDictionaryEntries.add(" none");
                }
                if (fluid != null) {
                    this.oreDictionaryEntries.add("Internal fluid name:");
                    this.oreDictionaryEntries.add(" " + fluid.getFluid().getName());
                    this.oreDictionaryEntries.add("Fluid class:");
                    this.oreDictionaryEntries.add(" " + fluid.getFluid().getClass().getName());
                    this.oreDictionaryEntries.add("Fluid id:");
                    this.oreDictionaryEntries.add(" " + fluid.getFluid().getID());
                    this.oreDictionaryEntries.add("Fluid still icon:");
                    if (fluid.getFluid().getStillIcon() != null) {
                        this.oreDictionaryEntries.add(" " + fluid.getFluid().getStillIcon().func_94215_i());
                    } else {
                        this.oreDictionaryEntries.add(" <missing icon> ");
                    }
                    this.oreDictionaryEntries.add("Fluid flowing icon:");
                    if (fluid.getFluid().getFlowingIcon() != null) {
                        this.oreDictionaryEntries.add(" " + fluid.getFluid().getFlowingIcon().func_94215_i());
                    } else {
                        this.oreDictionaryEntries.add(" <missing icon> ");
                    }
                }
                this.lastItem = this.itemsSlot.get(1);
            }
        }
    }

    public String func_145825_b() {
        return "debugScanner";
    }

    public ContainerBase<?> getGuiContainer(EntityPlayer entityPlayer) {
        return new DebugScannerContainer(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new DebugScannerGui(new DebugScannerContainer(entityPlayer, this));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public boolean getGui(EntityPlayer player) {
        return this instanceof IHasGui ? (IC2.platform.isSimulating() ? IC2.platform.launchGui(player, (IHasGui)this) : true) : false;
    }
}

