/*
 * Decompiled with CFR 0.152.
 */
package ihl.explosion;

import ic2.core.IC2;
import ihl.IHLMod;
import ihl.utils.IHLMathUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.oredict.OreDictionary;

public class ExplosiveTileEntity
extends TileEntity {
    public int explosionPower = 10000;
    private int explosionType = 1;
    private int detonator_delay = 1;
    private int burn_time = 0;
    public boolean is_detonator_burning = false;

    public void createExplosion(EntityPlayer player) {
        this.func_145843_s();
        int power = this.explosionPower;
        this.explosionPower = 0;
        IHLMod.explosionHandler.doExplosion(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, IHLMod.explosionHandler.startVectors, power);
        IHLMod.proxy.createExplosionEffectFromServer(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 32.0f * IHLMathUtils.sqrt((float)power / 16384.0f));
    }

    public boolean canUpdate() {
        return IC2.platform.isSimulating();
    }

    public void func_145845_h() {
        if (this.is_detonator_burning) {
            IHLMod.proxy.spawnParticleFromServer(4, this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.0, (double)this.field_145849_e + 0.5, 0.0, 0.2, 0.0, 1.0f);
            if (this.burn_time++ > this.detonator_delay * 20) {
                this.createExplosion(null);
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        if (nbt != null) {
            this.explosionPower = nbt.func_74762_e("explosionPower");
            this.explosionType = nbt.func_74762_e("explosionType");
            this.detonator_delay = nbt.func_74762_e("detonator_delay");
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        nbt.func_74768_a("explosionPower", this.explosionPower);
        nbt.func_74768_a("explosionType", this.explosionType);
        nbt.func_74768_a("detonator_delay", this.detonator_delay);
    }

    public boolean ignite(EntityPlayer player) {
        if (player != null && player.func_71045_bC() != null) {
            for (int oid : OreDictionary.getOreIDs((ItemStack)player.func_71045_bC())) {
                if (!OreDictionary.getOreName((int)oid).matches("toolLighter")) continue;
                this.ignite();
                return false;
            }
        }
        return true;
    }

    public void ignite() {
        IHLMod.proxy.playSoundEffectFromServer(0, this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 10.0f, 1.0f);
        this.is_detonator_burning = true;
    }
}

