/*
 * Decompiled with CFR 0.152.
 */
package ihl.nei_integration;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ic2.api.recipe.IRecipeInput;
import ihl.flexible_cable.IronWorkbenchGui;
import ihl.flexible_cable.IronWorkbenchTileEntity;
import ihl.interfaces.IWire;
import ihl.recipes.IronWorkbenchRecipe;
import ihl.utils.IHLUtils;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class IronWorkbenchRecipeHandler
extends TemplateRecipeHandler {
    private static final int workspaceItemsPosX = 1;
    private static final int workspaceItemsPosY = 1;
    private static final int toolsPosX = 19;
    private static final int toolsPosY = 1;
    private static final int materialsPosX = 58;
    private static final int materialsPosY = 1;
    private static final int outputPosX = 109;
    private static final int outputPosY = 1;

    public Class<? extends GuiContainer> getGuiClass() {
        return IronWorkbenchGui.class;
    }

    public String getRecipeName() {
        return "Iron workbench";
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getRecipeId() {
        return "ihl.ironWorkbench";
    }

    public String getGuiTexture() {
        return "ihl:textures/gui/GUIIronWorkbench.png";
    }

    public String getOverlayIdentifier() {
        return "ironWorkbench";
    }

    public List<IronWorkbenchRecipe> getRecipeList() {
        return IronWorkbenchTileEntity.recipes;
    }

    public void drawBackground(int recipeNumber) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)7, (int)7, (int)162, (int)108);
    }

    public void drawExtras(int i) {
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(94, -1, 15, 108), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (IronWorkbenchRecipe entry : this.getRecipeList()) {
                this.arecipes.add(new CachedIORecipe(entry));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        block0: for (IronWorkbenchRecipe entry : this.getRecipeList()) {
            for (ItemStack output : entry.outputs) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)output, (ItemStack)result)) continue;
                this.arecipes.add(new CachedIORecipe(entry));
                continue block0;
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        block0: for (IronWorkbenchRecipe entry : this.getRecipeList()) {
            if (entry.workspaceElements != null && !entry.workspaceElements.isEmpty()) {
                for (ItemStack itemStack : entry.workspaceElements) {
                    if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)itemStack, (ItemStack)ingredient) && !IHLUtils.isItemsHaveSameOreDictionaryEntry(itemStack, ingredient) && itemStack.func_77973_b() != ingredient.func_77973_b()) continue;
                    this.arecipes.add(new CachedIORecipe(entry));
                    break;
                }
            }
            if (entry.tools != null && !entry.tools.isEmpty()) {
                for (IRecipeInput iRecipeInput : entry.tools) {
                    if (!iRecipeInput.matches(ingredient)) continue;
                    this.arecipes.add(new CachedIORecipe(entry));
                    break;
                }
            }
            if (entry.materials == null || entry.materials.isEmpty()) continue;
            for (IRecipeInput iRecipeInput : entry.materials) {
                if (!iRecipeInput.matches(ingredient)) continue;
                this.arecipes.add(new CachedIORecipe(entry));
                continue block0;
            }
        }
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final List<PositionedStack> ingredients;
        private final PositionedStack output;
        private final List<PositionedStack> otherStacks;

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(IronWorkbenchRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.otherStacks;
        }

        public CachedIORecipe(IronWorkbenchRecipe recipe) {
            IRecipeInput rInput;
            ItemStack stack;
            int y;
            int x;
            int index;
            Iterator<ItemStack> i;
            super((TemplateRecipeHandler)IronWorkbenchRecipeHandler.this);
            this.ingredients = new ArrayList<PositionedStack>();
            this.otherStacks = new ArrayList<PositionedStack>();
            if (recipe == null) {
                throw new NullPointerException("Recipe must not be null.");
            }
            this.ingredients.add(new PositionedStack((Object)IHLUtils.getThisModItemStack("ironWorkbench"), 1, 1));
            if (recipe.workspaceElements != null && !recipe.workspaceElements.isEmpty()) {
                i = recipe.workspaceElements.iterator();
                index = 1;
                while (i.hasNext()) {
                    x = 1;
                    y = 1 + index * 18;
                    stack = i.next();
                    this.ingredients.add(new PositionedStack((Object)stack, x, y));
                    ++index;
                }
            }
            if (recipe.tools != null && !recipe.tools.isEmpty()) {
                i = recipe.tools.iterator();
                index = 0;
                while (i.hasNext()) {
                    x = 19 + index % 2 * 18;
                    y = 1 + index / 2 * 18;
                    rInput = (IRecipeInput)i.next();
                    this.ingredients.add(new PositionedStack((Object)rInput.getInputs(), x, y));
                    ++index;
                }
            }
            if (recipe.materials != null && !recipe.materials.isEmpty()) {
                i = recipe.materials.iterator();
                index = 0;
                while (i.hasNext()) {
                    x = 58 + index % 2 * 18;
                    y = 1 + index / 2 * 18;
                    rInput = (IRecipeInput)i.next();
                    Iterator rInputsi = rInput.getInputs().iterator();
                    ArrayList<ItemStack> itemInputs = new ArrayList<ItemStack>();
                    while (rInputsi.hasNext()) {
                        ItemStack stack2 = ((ItemStack)rInputsi.next()).func_77946_l();
                        if (!(stack2.func_77973_b() instanceof IWire)) {
                            stack2.field_77994_a = rInput.getAmount();
                        }
                        itemInputs.add(stack2);
                    }
                    this.ingredients.add(new PositionedStack(itemInputs, x, y));
                    ++index;
                }
            }
            this.output = new PositionedStack((Object)recipe.outputs.get(0), 109, 1);
            i = recipe.outputs.iterator();
            index = 0;
            while (i.hasNext()) {
                x = 109 + index % 3 * 18;
                y = 1 + index / 3 * 18;
                stack = i.next();
                if (index > 0) {
                    this.otherStacks.add(new PositionedStack((Object)stack, x, y));
                }
                ++index;
            }
        }
    }
}

