/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.invslots;

import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotOutput;
import ihl.recipes.RecipeOutputItemStack;
import ihl.utils.IHLUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class IHLInvSlotOutput
extends InvSlotOutput {
    private final Map<Long, Float> substanceAmount = new HashMap<Long, Float>();

    public IHLInvSlotOutput(TileEntityInventory base1, String name1, int oldStartIndex1, int count) {
        super(base1, name1, oldStartIndex1, count);
    }

    public boolean canAdd(List itemOutputs) {
        if (itemOutputs == null || itemOutputs.isEmpty()) {
            return true;
        }
        Iterator ioi = itemOutputs.iterator();
        if (this.size() >= itemOutputs.size()) {
            if (!ioi.hasNext()) {
                return true;
            }
            Object rois = ioi.next();
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) == null || this.objectMatchesSlot(rois, i) && (float)this.get((int)i).field_77994_a + this.getAmoutOfObject(rois) < (float)this.getStackSizeLimit() && (float)this.get((int)i).field_77994_a + this.getAmoutOfObject(rois) <= (float)this.get(i).func_77976_d()) {
                    if (ioi.hasNext()) {
                        rois = ioi.next();
                        continue;
                    }
                    return true;
                }
                if (i != this.size() - 1) continue;
                return false;
            }
        }
        return false;
    }

    private float getAmoutOfObject(Object obj) {
        if (obj instanceof ItemStack) {
            return ((ItemStack)obj).field_77994_a;
        }
        if (obj instanceof RecipeOutputItemStack) {
            return ((RecipeOutputItemStack)obj).quantity;
        }
        return 32767.0f;
    }

    public boolean objectMatchesSlot(Object obj, int slot) {
        if (this.get(slot) == null) {
            return true;
        }
        if (obj instanceof ItemStack) {
            return IHLUtils.isItemStacksIsEqual(this.get(slot), (ItemStack)obj, true);
        }
        if (obj instanceof RecipeOutputItemStack) {
            return ((RecipeOutputItemStack)obj).matches(this.get(slot));
        }
        return false;
    }

    public void add(RecipeOutputItemStack rois) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) != null && (!this.objectMatchesSlot(rois, i) || !((float)this.get((int)i).field_77994_a + this.getAmoutOfObject(rois) < (float)this.getStackSizeLimit()))) continue;
            this.add(i, rois);
            break;
        }
    }

    private void add(int i, RecipeOutputItemStack rois) {
        long key = (Item.func_150891_b((Item)rois.itemStack.func_77973_b()) << 32) + rois.itemStack.func_77960_j();
        float amount = 0.0f;
        if (this.substanceAmount.containsKey(key)) {
            amount = this.substanceAmount.get(key).floatValue();
        }
        amount += rois.quantity;
        while (amount >= 1.0f) {
            amount -= 1.0f;
            this.add(rois.itemStack.func_77946_l());
        }
        this.substanceAmount.put(key, Float.valueOf(amount));
    }

    public int add(List itemOutputs) {
        if (itemOutputs == null || itemOutputs.isEmpty()) {
            return 0;
        }
        Iterator ioi = itemOutputs.iterator();
        if (this.size() >= itemOutputs.size() && ioi.hasNext()) {
            Object rois = ioi.next();
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) == null || this.objectMatchesSlot(rois, i) && (float)this.get((int)i).field_77994_a + this.getAmoutOfObject(rois) < (float)this.getStackSizeLimit()) {
                    if (rois instanceof ItemStack) {
                        this.add(((ItemStack)rois).func_77946_l());
                    } else if (rois instanceof RecipeOutputItemStack) {
                        this.add(i, (RecipeOutputItemStack)rois);
                    }
                    if (ioi.hasNext()) {
                        rois = ioi.next();
                        continue;
                    }
                    return itemOutputs.size();
                }
                if (i != this.size() - 1) continue;
                return 0;
            }
        }
        return 0;
    }

    public void readFromNbt(NBTTagCompound nbtTagCompound) {
        super.readFromNbt(nbtTagCompound);
        NBTTagList amountTagList = nbtTagCompound.func_150295_c("substanceAmountMap", 10);
        for (int i = 0; i < amountTagList.func_74745_c(); ++i) {
            if (!amountTagList.func_150305_b(i).func_74764_b("substanceKey")) continue;
            long substanceKey = amountTagList.func_150305_b(i).func_74763_f("substanceKey");
            float substanceAmount = amountTagList.func_150305_b(i).func_74760_g("substanceAmount");
            this.substanceAmount.put(substanceKey, Float.valueOf(substanceAmount));
        }
    }

    public void writeToNbt(NBTTagCompound nbtTagCompound) {
        super.writeToNbt(nbtTagCompound);
        NBTTagList sAmountsList = new NBTTagList();
        for (Map.Entry<Long, Float> entry : this.substanceAmount.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74772_a("substanceKey", entry.getKey().longValue());
            tag.func_74776_a("substanceAmount", entry.getValue().floatValue());
            sAmountsList.func_74742_a((NBTBase)tag);
        }
        nbtTagCompound.func_74782_a("substanceAmountMap", (NBTBase)sAmountsList);
    }
}

