/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.metallurgy;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.core.ContainerBase;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotOutput;
import ihl.IHLMod;
import ihl.items_blocks.IHLTool;
import ihl.processing.chemistry.ApparatusProcessableInvSlot;
import ihl.processing.invslots.InvSlotConsumableLiquidIHL;
import ihl.processing.metallurgy.BasicElectricMotorTileEntity;
import ihl.processing.metallurgy.IProductionLine;
import ihl.processing.metallurgy.WireMillContainer;
import ihl.processing.metallurgy.WireMillGui;
import ihl.recipes.IRecipeInputFluid;
import ihl.recipes.RecipeInputDie;
import ihl.recipes.RecipeInputFluidDictionary;
import ihl.recipes.RecipeInputFluidStack;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import ihl.utils.IHLFluidTank;
import ihl.utils.IHLUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class WireMillTileEntity
extends BasicElectricMotorTileEntity
implements IFluidHandler {
    public final ApparatusProcessableInvSlot dice;
    public final InvSlotConsumableLiquidIHL fillInputSlot;
    public final InvSlotConsumableLiquidIHL drainInputSlot;
    public final InvSlotOutput emptyFluidItemsSlot;
    public final IHLFluidTank oilFluidTank = new IHLFluidTank(1100);
    public final IHLFluidTank waterFluidTank = new IHLFluidTank(1100);
    public final IHLFluidTank metalFluidTank = new IHLFluidTank(1100);
    protected static final UniversalRecipeManager recipeManager = new UniversalRecipeManager("wiremill");
    protected static final UniversalRecipeManager recipeManagerMelting = new UniversalRecipeManager("wiremillMelting");

    public WireMillTileEntity() {
        this.emptyFluidItemsSlot = new InvSlotOutput((TileEntityInventory)this, "emptyWaterFluidItemsSlot", 2, 1);
        this.fillInputSlot = new InvSlotConsumableLiquidIHL(this, "fillInput", -1, InvSlot.Access.I, 1, InvSlot.InvSide.BOTTOM, InvSlotConsumableLiquid.OpType.Fill);
        this.drainInputSlot = new InvSlotConsumableLiquidIHL(this, "drainInput", -1, InvSlot.Access.I, 1, InvSlot.InvSide.BOTTOM, InvSlotConsumableLiquid.OpType.Drain, "ingot");
        this.dice = new ApparatusProcessableInvSlot(this, "dice", 3, InvSlot.Access.IO, 1, 64);
        this.operationLength = (short)600;
    }

    @Override
    public String func_145825_b() {
        return "WireMill";
    }

    public ItemStack getWrenchDrop(EntityPlayer player) {
        return IHLUtils.getThisModItemStack("wireMill");
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean arg1) {
        return new WireMillGui(new WireMillContainer(player, this));
    }

    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        return new WireMillContainer(player, this);
    }

    @Override
    public void operate() {
        UniversalRecipeInput rInput = recipeManager.getRecipeInput(this.getInput());
        IRecipeInput rInputDice = rInput.getItemInputs().get(0);
        UniversalRecipeOutput rOutput = this.getOutput();
        ItemStack rOutputItemStack = null;
        if (!rOutput.getItemOutputs().isEmpty()) {
            rOutputItemStack = rOutput.getItemOutputs().get((int)0).itemStack.func_77946_l();
        }
        List<IRecipeInputFluid> rInputFluidStacks = rInput.getFluidInputs();
        int consumeMoltenMetalAmount = 1;
        if (!rInputFluidStacks.isEmpty() && rOutputItemStack != null && rInputDice != null && rInputDice instanceof RecipeInputDie) {
            consumeMoltenMetalAmount = rInputFluidStacks.size() >= 3 ? rInputFluidStacks.get(2).getAmount() : rInputFluidStacks.get(0).getAmount();
            if (rOutputItemStack != null && rInputDice != null && rInputDice instanceof RecipeInputDie) {
                consumeMoltenMetalAmount *= ((RecipeInputDie)rInputDice).transformOutput(this.dice.get(), rOutputItemStack);
            }
        }
        if (this.dice.get() != null) {
            if (this.dice.get().func_77973_b() instanceof IHLTool) {
                IHLUtils.damageItemViaNBTTag(this.dice.get(), 1);
                if (this.dice.get().field_77994_a <= 0) {
                    this.dice.put(null);
                }
            } else {
                this.dice.consume(rInputDice);
            }
        }
        if (this.drainInputSlot.get() != null && !rInput.getItemInputs().isEmpty() && rInput.getItemInputs().get(0).matches(this.drainInputSlot.get())) {
            this.drainInputSlot.consume(1);
        }
        if (!rOutput.getFluidOutputs().isEmpty()) {
            this.metalFluidTank.fill(rOutput.getFluidOutputs().get(0), true);
        }
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + ForgeDirection.getOrientation((int)this.getFacing()).offsetX, this.field_145848_d + ForgeDirection.getOrientation((int)this.getFacing()).offsetY, this.field_145849_e + ForgeDirection.getOrientation((int)this.getFacing()).offsetZ);
        if (rOutputItemStack != null && te instanceof IProductionLine) {
            if (!rInputFluidStacks.isEmpty()) {
                this.oilFluidTank.drain(1, true);
                this.waterFluidTank.drain(1, true);
                this.metalFluidTank.drain(consumeMoltenMetalAmount, true);
            }
            ((IProductionLine)te).process(rOutputItemStack);
        }
    }

    public List[] getInput() {
        return new List[]{Arrays.asList(this.oilFluidTank.getFluid(), this.waterFluidTank.getFluid(), this.metalFluidTank.getFluid()), Arrays.asList(this.dice.get(), this.drainInputSlot.get())};
    }

    public UniversalRecipeOutput getOutput() {
        return recipeManager.getOutputFor(this.getInput());
    }

    public static void addRecipe(FluidStack moltenMetal, IRecipeInput inputDice, ItemStack output1) {
        recipeManager.addRecipe(new UniversalRecipeInput(new IRecipeInputFluid[]{new RecipeInputFluidDictionary("lubricant", 1), new RecipeInputFluidDictionary("water", 1), new RecipeInputFluidStack(moltenMetal)}, new IRecipeInput[]{inputDice}), new UniversalRecipeOutput(null, new ItemStack[]{output1}, 200));
    }

    public static void addRecipe(String string, FluidStack fluidStack) {
        recipeManager.addRecipe(new UniversalRecipeInput(null, new IRecipeInput[]{new RecipeInputOreDict(string)}), new UniversalRecipeOutput(new FluidStack[]{fluidStack}, null, 200));
    }

    @Override
    public boolean canOperate() {
        UniversalRecipeOutput output = this.getOutput();
        if (output != null) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)this.getFacing()).getRotation(ForgeDirection.DOWN);
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + ForgeDirection.getOrientation((int)this.getFacing()).offsetX, this.field_145848_d + ForgeDirection.getOrientation((int)this.getFacing()).offsetY, this.field_145849_e + ForgeDirection.getOrientation((int)this.getFacing()).offsetZ);
            if (te instanceof IProductionLine && !output.getItemOutputs().isEmpty()) {
                ItemStack isOut = this.getOutput().getItemOutputs().get((int)0).itemStack.func_77946_l();
                if (this.dice.get() != null) {
                    isOut.field_77990_d.func_74768_a("transverseSection", this.dice.get().field_77990_d.func_74762_e("transverseSection"));
                }
                return ForgeDirection.getOrientation((int)((IProductionLine)te).getFacing()).equals((Object)dir) && ((IProductionLine)te).canProcess(isOut);
            }
            if (!output.getFluidOutputs().isEmpty()) {
                FluidStack fstack = output.getFluidOutputs().get(0);
                return this.metalFluidTank.fill(fstack, false) == fstack.amount;
            }
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.oilFluidTank.readFromNBT(nbttagcompound.func_74775_l("oilFluidTank"));
        this.waterFluidTank.readFromNBT(nbttagcompound.func_74775_l("waterFluidTank"));
        this.metalFluidTank.readFromNBT(nbttagcompound.func_74775_l("metalFluidTank"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagCompound oilFluidTankTag = new NBTTagCompound();
        this.oilFluidTank.writeToNBT(oilFluidTankTag);
        nbttagcompound.func_74782_a("oilFluidTank", (NBTBase)oilFluidTankTag);
        NBTTagCompound waterFluidTankTag = new NBTTagCompound();
        this.waterFluidTank.writeToNBT(waterFluidTankTag);
        nbttagcompound.func_74782_a("waterFluidTank", (NBTBase)waterFluidTankTag);
        NBTTagCompound metalFluidTankTag = new NBTTagCompound();
        this.metalFluidTank.writeToNBT(metalFluidTankTag);
        nbttagcompound.func_74782_a("metalFluidTank", (NBTBase)metalFluidTankTag);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        FluidStack drainSlotContent = this.drainInputSlot.drain(null, Integer.MAX_VALUE, null, true);
        if (drainSlotContent != null) {
            String fluidDictionaryName = IHLMod.fluidDictionary.getFluidName(drainSlotContent.getFluid());
            if (fluidDictionaryName != null && fluidDictionaryName.equals("lubricant")) {
                IHLUtils.handleFluidSlotsBehaviour(this.fillInputSlot, this.drainInputSlot, this.emptyFluidItemsSlot, this.oilFluidTank);
            } else if (fluidDictionaryName != null && fluidDictionaryName.equals("water")) {
                IHLUtils.handleFluidSlotsBehaviour(this.fillInputSlot, this.drainInputSlot, this.emptyFluidItemsSlot, this.waterFluidTank);
            } else {
                IHLUtils.handleFluidSlotsBehaviour(this.fillInputSlot, this.drainInputSlot, this.emptyFluidItemsSlot, this.metalFluidTank);
            }
        } else if (this.metalFluidTank.getNumberOfFluids() > 0) {
            IHLUtils.handleFluidSlotsBehaviour(this.fillInputSlot, this.drainInputSlot, this.emptyFluidItemsSlot, this.metalFluidTank);
        } else if (this.oilFluidTank.getNumberOfFluids() > 0) {
            IHLUtils.handleFluidSlotsBehaviour(this.fillInputSlot, this.drainInputSlot, this.emptyFluidItemsSlot, this.oilFluidTank);
        } else {
            IHLUtils.handleFluidSlotsBehaviour(this.fillInputSlot, this.drainInputSlot, this.emptyFluidItemsSlot, this.waterFluidTank);
        }
    }

    public int gaugeLiquidScaled(int i) {
        if (this.oilFluidTank.getFluid() != null) {
            return this.oilFluidTank.getFluidAmount() * i / this.oilFluidTank.getCapacity();
        }
        return 0;
    }

    @Override
    public int gaugeProgressScaled(int i) {
        return this.progress * i / this.operationLength;
    }

    public int gaugeWaterScaled(int i) {
        if (this.waterFluidTank.getFluid() != null) {
            return this.waterFluidTank.getFluidAmount() * i / this.waterFluidTank.getCapacity();
        }
        return 0;
    }

    public static Map<UniversalRecipeInput, UniversalRecipeOutput> getRecipes() {
        return recipeManager.getRecipes();
    }

    public boolean canDrain(ForgeDirection arg0, Fluid arg1) {
        return true;
    }

    public boolean canFill(ForgeDirection arg0, Fluid arg1) {
        return true;
    }

    public FluidStack drain(ForgeDirection direction, FluidStack arg1, boolean arg2) {
        if (direction.equals((Object)ForgeDirection.DOWN)) {
            return this.metalFluidTank.drain(arg1, arg2);
        }
        if (direction.equals((Object)ForgeDirection.UP)) {
            return this.waterFluidTank.drain(arg1, arg2);
        }
        return this.oilFluidTank.drain(arg1, arg2);
    }

    public FluidStack drain(ForgeDirection direction, int arg1, boolean arg2) {
        if (direction.equals((Object)ForgeDirection.DOWN)) {
            return this.metalFluidTank.drain(arg1, arg2);
        }
        if (direction.equals((Object)ForgeDirection.UP)) {
            return this.waterFluidTank.drain(arg1, arg2);
        }
        return this.oilFluidTank.drain(arg1, arg2);
    }

    public int fill(ForgeDirection direction, FluidStack arg1, boolean arg2) {
        if (direction.equals((Object)ForgeDirection.DOWN)) {
            return this.metalFluidTank.fill(arg1, arg2);
        }
        if (direction.equals((Object)ForgeDirection.UP)) {
            return this.waterFluidTank.fill(arg1, arg2);
        }
        return this.oilFluidTank.fill(arg1, arg2);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection direction) {
        if (direction.equals((Object)ForgeDirection.DOWN)) {
            return new FluidTankInfo[]{this.metalFluidTank.getInfo()};
        }
        if (direction.equals((Object)ForgeDirection.UP)) {
            return new FluidTankInfo[]{this.waterFluidTank.getInfo()};
        }
        return new FluidTankInfo[]{this.oilFluidTank.getInfo()};
    }
}

