/*
 * Decompiled with CFR 0.152.
 */
package ihl.flexible_cable;

import ihl.IHLMod;
import ihl.interfaces.IEnergyNetNode;
import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;

public class IHLGrid {
    private static final double powerLossLimitPerMeter = 1.6;
    public final Set<IEnergyNetNode> telist = new HashSet<IEnergyNetNode>();
    public double energy = 0.0;
    private IEnergyNetNode sink;
    private IEnergyNetNode source;
    private double voltage;
    private double lastVoltage;
    public boolean isGridValid = true;
    private double total20TicksEU;
    private int lastTickCounter = 0;
    private int tickCounterFireStart = 0;
    public final List<IEnergyNetNode> calculatedSinks = new ArrayList<IEnergyNetNode>();
    public final List<IEnergyNetNode> calculatedSources = new ArrayList<IEnergyNetNode>();
    public final Set<NBTTagCompound> cablesOnFire = new HashSet<NBTTagCompound>();
    private final Map<IEnergyNetNode, Double> energyLossSinkMap = new HashMap<IEnergyNetNode, Double>();
    private final Map<IEnergyNetNode, Double> voltageSinkMap = new HashMap<IEnergyNetNode, Double>();
    private double averageEUTransfered;
    private double lastAverageEUTransfered = 0.0;

    public void drawEnergy(double amount, IEnergyNetNode sink1) {
        this.energy -= amount;
        if (this.energyLossSinkMap.get(sink1) != null) {
            this.energy -= this.energyLossSinkMap.get(sink1) * amount * amount;
        } else {
            this.telist.add(sink1);
        }
        this.sink = sink1;
    }

    public void injectEnergy(double amount, double voltage1, IEnergyNetNode source1) {
        this.energy += amount;
        this.voltage = voltage1;
        this.source = source1;
        this.total20TicksEU += amount;
        int tickCounter = MinecraftServer.func_71276_C().func_71259_af();
        if (tickCounter - this.lastTickCounter < 0) {
            this.lastTickCounter = tickCounter;
            this.total20TicksEU = 0.0;
        }
        Iterator<IEnergyNetNode> i = this.telist.iterator();
        while (this.energy > 1.0 && i.hasNext()) {
            IEnergyNetNode eNode = i.next();
            if (!(eNode.getEnergyAmountThisNodeWant() > 0.0)) continue;
            double powerToInject = Math.min(this.energy, eNode.getEnergyAmountThisNodeWant());
            eNode.injectEnergyInThisNode(powerToInject, this.getSinkVoltage(eNode));
            this.energy -= powerToInject;
            if (this.energyLossSinkMap.get(eNode) != null) {
                this.energy -= this.energyLossSinkMap.get(eNode) * powerToInject * powerToInject;
                continue;
            }
            this.sink = eNode;
        }
        int d = tickCounter - this.lastTickCounter;
        if (d >= 200) {
            this.averageEUTransfered = this.total20TicksEU / (double)d;
            this.lastTickCounter = tickCounter;
            this.total20TicksEU = 0.0;
            if (IHLMod.config.enableFlexibleCablesGridPowerLossCalculations && this.isGridValid && this.averageEUTransfered > 1.0) {
                this.telist.add(source1);
                this.updateGrid();
            }
        }
        if ((d = tickCounter - this.tickCounterFireStart) >= 200 && !this.cablesOnFire.isEmpty()) {
            for (NBTTagCompound cable : this.cablesOnFire) {
                this.removeCableAndSplitGrids(cable);
            }
            this.cablesOnFire.clear();
        }
    }

    public void removeCableAndSplitGrids(NBTTagCompound cable) {
        IHLUtils.removeChain(cable, null);
        for (IEnergyNetNode cte : this.telist) {
            cte.setGrid(-1);
        }
        IHLMod.enet.removeCableEntities(cable);
        block1: for (IEnergyNetNode cte : this.telist) {
            if (cte.getGridID() != -1) continue;
            for (IEnergyNetNode cte2 : this.telist) {
                if (cte2 == cte || !IHLMod.enet.hasSame(cte.getCableList(), cte2.getCableList())) continue;
                int result = IHLMod.enet.mergeGrids(cte.getGridID(), cte2.getGridID());
                cte.setGrid(result);
                cte2.setGrid(result);
                continue block1;
            }
        }
    }

    private void updateGrid() {
        if (!(this.source == null || this.sink == null || this.source == this.sink || this.sink.getCableList().isEmpty() || this.source.getCableList().isEmpty() || this.calculatedSources.contains(this.source) && this.calculatedSinks.contains(this.sink) && !(this.averageEUTransfered > this.lastAverageEUTransfered) && this.voltage == this.lastVoltage)) {
            HashMap<IEnergyNetNode, NBTTagCompound> map = new HashMap<IEnergyNetNode, NBTTagCompound>();
            HashSet<IEnergyNetNode> templist = new HashSet<IEnergyNetNode>();
            HashSet<IEnergyNetNode> processlist = new HashSet<IEnergyNetNode>();
            HashSet<IEnergyNetNode> templist2 = new HashSet<IEnergyNetNode>();
            templist.addAll(this.telist);
            processlist.add(this.sink);
            int threads = 0;
            block0: while (!templist.isEmpty()) {
                if (threads++ > 1000) {
                    this.isGridValid = false;
                    return;
                }
                templist.removeAll(processlist);
                templist2.clear();
                Iterator it1 = processlist.iterator();
                while (it1.hasNext()) {
                    if (threads++ > 1000) {
                        this.isGridValid = false;
                        return;
                    }
                    IEnergyNetNode ate1 = (IEnergyNetNode)it1.next();
                    Iterator it2 = templist.iterator();
                    while (it2.hasNext()) {
                        NBTTagCompound cable;
                        if (threads++ > 1000) {
                            this.isGridValid = false;
                            return;
                        }
                        IEnergyNetNode ate2 = (IEnergyNetNode)it2.next();
                        if (ate1 == ate2 || (cable = this.getSame(ate1.getCableList(), ate2.getCableList())) == null) continue;
                        map.put(ate2, cable);
                        templist2.add(ate2);
                        if (ate2 != this.source) continue;
                        break block0;
                    }
                    templist.removeAll(templist2);
                }
                processlist.clear();
                processlist.addAll(templist2);
            }
            IEnergyNetNode cursor = this.source;
            double voltage1 = this.voltage;
            double euTransfered = this.averageEUTransfered;
            double voltageLossPerMeter = 0.0;
            double powerLossPerMeter = 0.0;
            double powerLossPerSquaredEU = 0.0;
            this.energyLossSinkMap.remove(this.sink);
            this.voltageSinkMap.remove(this.sink);
            while (cursor != this.sink) {
                NBTTagCompound cable = (NBTTagCompound)map.get(cursor);
                voltageLossPerMeter = (double)IHLUtils.getResistance(cable) / 1000.0 * euTransfered / voltage1;
                powerLossPerMeter = voltageLossPerMeter * euTransfered / voltage1;
                euTransfered -= powerLossPerMeter * (double)cable.func_74762_e("length");
                powerLossPerSquaredEU += (double)IHLUtils.getResistance(cable) / 1000.0 * (double)cable.func_74762_e("length") / (voltage1 -= voltageLossPerMeter * (double)cable.func_74762_e("length")) / voltage1;
                if (!this.cablesOnFire.contains(cable) && powerLossPerMeter > 1.6) {
                    IHLMod.enet.setOnFire(cable);
                    this.tickCounterFireStart = this.lastTickCounter;
                    this.cablesOnFire.add(cable);
                }
                cursor = this.getHasCable(cable, cursor);
            }
            this.energyLossSinkMap.put(this.sink, powerLossPerSquaredEU);
            this.voltageSinkMap.put(this.sink, voltage1);
            this.calculatedSources.add(this.source);
            this.calculatedSinks.add(this.sink);
            this.lastAverageEUTransfered = this.averageEUTransfered;
            this.lastVoltage = this.voltage;
        }
    }

    private NBTTagCompound getSame(Set<NBTTagCompound> set, Set<NBTTagCompound> set2) {
        for (NBTTagCompound cable : set) {
            if (!set2.contains(cable)) continue;
            return cable;
        }
        return null;
    }

    public double getSinkVoltage(IEnergyNetNode node) {
        if (this.voltageSinkMap.containsKey(node)) {
            return this.voltageSinkMap.get(node);
        }
        return this.voltage;
    }

    private IEnergyNetNode getHasCable(NBTTagCompound cable, IEnergyNetNode exclude) {
        for (IEnergyNetNode ate1 : this.telist) {
            if (ate1 == exclude || !ate1.getCableList().contains(cable)) continue;
            return ate1;
        }
        return null;
    }

    public void add(IEnergyNetNode e) {
        this.telist.add(e);
        this.isGridValid = true;
        if (!e.getCableList().isEmpty()) {
            for (NBTTagCompound cable : e.getCableList()) {
                IHLMod.enet.cablesToGrids.put(cable.func_74762_e("chainUID"), this);
            }
        }
    }
}

