/*
 * Decompiled with CFR 0.152.
 */
package ihl.worldgen;

import ihl.utils.IHLUtils;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public abstract class WorldGeneratorBase {
    private final Random random = new Random();
    protected final Block ore;
    private final Set<Block> replaceableBlocks = new HashSet<Block>(2);

    public WorldGeneratorBase(Block oreIn, Block ... replaceableBlocksIn) {
        this.ore = oreIn;
        for (Block block : replaceableBlocksIn) {
            this.replaceableBlocks.add(block);
        }
    }

    public void generate(World world, int chunkX, int chunkZ) {
        int[] centralPOI = this.getPOI(world, chunkX, chunkZ, 0, 0);
        int[] xz = new int[]{0, 1, 0, -1, 0};
        for (int i = 0; i < 4; ++i) {
            int[] surroundPOI = this.getPOI(world, chunkX + xz[i], chunkZ + xz[i + 1], xz[i], xz[i + 1]);
            this.replaceBlocks(world, centralPOI, surroundPOI, chunkX << 4, chunkZ << 4);
        }
    }

    protected abstract void replaceBlocks(World var1, int[] var2, int[] var3, int var4, int var5);

    protected boolean replace(World world, int absX, int absY, int absZ, Block block) {
        if (!world.func_72863_F().func_73149_a(absX >> 4, absZ >> 4)) {
            throw new IllegalStateException("quered chunk is not yet generated!");
        }
        Chunk chunk = world.func_72938_d(absX, absZ);
        ExtendedBlockStorage ebs = chunk.func_76587_i()[absY >> 4];
        if (ebs != null && this.replaceableBlocks.contains(ebs.func_150819_a(absX & 0xF, absY & 0xF, absZ & 0xF))) {
            IHLUtils.setBlockRaw(ebs, absX & 0xF, absY & 0xF, absZ & 0xF, block);
            return true;
        }
        return false;
    }

    protected boolean replaceAll(World world, int absX, int absY, int absZ, Block block) {
        if (!world.func_72863_F().func_73149_a(absX >> 4, absZ >> 4)) {
            throw new IllegalStateException("quered chunk is not yet generated!");
        }
        Chunk chunk = world.func_72938_d(absX, absZ);
        ExtendedBlockStorage ebs = chunk.func_76587_i()[absY >> 4];
        if (ebs != null) {
            IHLUtils.setBlockRaw(ebs, absX & 0xF, absY & 0xF, absZ & 0xF, block);
            return true;
        }
        return false;
    }

    protected boolean replaceAllExceptOre(World world, int absX, int absY, int absZ, Block block) {
        Block olblock;
        if (!world.func_72863_F().func_73149_a(absX >> 4, absZ >> 4)) {
            throw new IllegalStateException("quered chunk is not yet generated!");
        }
        Chunk chunk = world.func_72938_d(absX, absZ);
        ExtendedBlockStorage ebs = chunk.func_76587_i()[absY >> 4];
        if (!(ebs == null || (olblock = ebs.func_150819_a(absX & 0xF, absY & 0xF, absZ & 0xF)).equals(this.ore) || olblock.equals(Blocks.field_150357_h) || olblock.equals(Blocks.field_150424_aL) || olblock.equals(Blocks.field_150348_b) || olblock.equals(Blocks.field_150435_aG))) {
            IHLUtils.setBlockRaw(ebs, absX & 0xF, absY & 0xF, absZ & 0xF, block);
            return true;
        }
        return false;
    }

    private int[] getPOI(World world, int chunkX, int chunkZ, int xOffset, int zOffset) {
        long seed = (long)chunkX << 16 ^ (long)(chunkZ << 8) ^ (long)Block.func_149682_b((Block)this.ore);
        this.random.setSeed(seed);
        return new int[]{this.random.nextInt(16) + xOffset * 16, this.random.nextInt(world.func_72940_L() / 2), this.random.nextInt(16) + zOffset * 16};
    }
}

