/*
 * Decompiled with CFR 0.152.
 */
package ihl.explosion;

import ihl.IHLMod;
import ihl.explosion.PileBlock;
import ihl.explosion.PileBlockRender;
import ihl.explosion.PileTileEntity;
import ihl.utils.IHLItemRenderer;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.util.glu.GLU;

public class PileTileEntityRender
extends TileEntitySpecialRenderer {
    private int fb = -1;
    private final int textureWidth = 64;
    private final int textureHeight = 64;
    private final PileBlockRender pileBlockRender;
    public final Map<Long, Integer> subIconIdMap = new HashMap<Long, Integer>();
    private int nextAvailableId = -1;
    private boolean framebufferReady = false;
    private Minecraft mc;
    private final IHLItemRenderer ihlItemRenderer = new IHLItemRenderer(false);
    private final Random random = new Random();

    public PileTileEntityRender(PileBlockRender pileBlockRender1) {
        this.pileBlockRender = pileBlockRender1;
        this.mc = Minecraft.func_71410_x();
    }

    public void renderAModelAt(PileTileEntity tile, double x, double y, double z, float f) {
        long hash;
        ItemStack stack = tile.content;
        if (!this.framebufferReady) {
            this.generateFrameBuffer();
            Minecraft.func_71410_x().field_71460_t.func_78479_a(f, 0);
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        } else if (stack != null && !this.subIconIdMap.containsKey(hash = this.pileBlockRender.getItemStackHash(stack))) {
            this.subIconIdMap.put(hash, ++this.nextAvailableId);
            this.preparetexture();
            this.drawTexture(tile, this.nextAvailableId);
            Minecraft.func_71410_x().field_71460_t.func_78479_a(f, 0);
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
            tile.updateBlockRender();
        }
    }

    private void generateFrameBuffer() {
        this.fb = GL30.glGenFramebuffers();
        this.preparetexture();
        if (GL30.glCheckFramebufferStatus((int)36160) != 36053) {
            IHLMod.log.error("Something went wrong while creating frame buffer!");
            IHLMod.log.error((Object)GL30.glCheckFramebufferStatus((int)36160));
        } else {
            IHLMod.log.info("FrameBuffer loaded correctly!");
        }
        this.framebufferReady = true;
    }

    private void preparetexture() {
        GL30.glBindFramebuffer((int)36160, (int)this.fb);
        int texture = Minecraft.func_71410_x().field_71446_o.func_110581_b(TextureMap.field_110575_b).func_110552_b();
        GL11.glBindTexture((int)3553, (int)texture);
        GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)texture, (int)0);
    }

    private void drawTexture(PileTileEntity tile, int subIconId) {
        IIcon picon = PileBlock.instance.func_149691_a(0, 0);
        float minu = picon.func_94209_e();
        float minv = picon.func_94206_g();
        float maxu = picon.func_94212_f();
        float maxv = picon.func_94210_h();
        int iconwidth = picon.func_94211_a();
        int iconheight = picon.func_94216_b();
        float du = maxu - minu;
        float dv = maxv - minv;
        int n = picon.func_94211_a();
        ((Object)((Object)this)).getClass();
        int iconNumU = n / 64;
        int posu = (int)(minu * (float)iconwidth / du) + subIconId % iconNumU * 64;
        int posv = (int)(minv * (float)iconheight / dv) + subIconId / iconNumU * 64;
        GL11.glViewport((int)posu, (int)posv, (int)64, (int)64);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)-1.0, (double)1.0, (double)-1.0, (double)1.0, (double)0.05f, (double)((float)this.mc.field_71474_y.field_151451_c * 32.0f));
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        ItemStack stack = tile.content;
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.0f);
        GLU.gluLookAt((float)0.0f, (float)0.0f, (float)0.0f, (float)-32.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        if (stack.func_77973_b() instanceof ItemBlock) {
            Block block = ((ItemBlock)stack.func_77973_b()).field_150939_a;
            IIcon icon = block.func_149691_a(0, stack.func_77960_j());
            double u1 = icon.func_94214_a(0.0);
            double u2 = icon.func_94214_a(16.0);
            double v1 = icon.func_94207_b(0.0);
            double v2 = icon.func_94207_b(16.0);
            Tessellator tessellator = Tessellator.field_78398_a;
            this.func_147499_a(TextureMap.field_110575_b);
            tessellator.func_78382_b();
            tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
            tessellator.func_78374_a(-0.5, -0.5, 0.0, u1, v1);
            tessellator.func_78374_a(0.5, -0.5, 0.0, u1, v2);
            tessellator.func_78374_a(0.5, 0.5, 0.0, u2, v2);
            tessellator.func_78374_a(-0.5, 0.5, 0.0, u2, v1);
            tessellator.func_78381_a();
        }
        for (int i = 0; i < 128; ++i) {
            GL11.glPushMatrix();
            float tx = this.random.nextFloat() - 0.5f;
            float ty = this.random.nextFloat() - 0.5f;
            GL11.glTranslatef((float)tx, (float)ty, (float)0.0f);
            this.ihlItemRenderer.doRender(RenderManager.field_78727_a, stack, 0.0, 0.0, 0.0);
            GL11.glTranslatef((float)(-tx), (float)(-ty), (float)0.0f);
            GL11.glPopMatrix();
        }
        GL11.glViewport((int)0, (int)0, (int)Display.getWidth(), (int)Display.getHeight());
    }

    public float getSubIconMinU(int index) {
        IIcon picon = PileBlock.instance.func_149691_a(0, 0);
        int n = picon.func_94211_a();
        ((Object)((Object)this)).getClass();
        int iconNumU = n / 64;
        float minu = picon.func_94209_e();
        float maxu = picon.func_94212_f();
        float du = (maxu - minu) / (float)iconNumU;
        return minu + (float)(index % iconNumU) * du;
    }

    public float getSubIconMinV(int index) {
        IIcon picon = PileBlock.instance.func_149691_a(0, 0);
        int n = picon.func_94211_a();
        ((Object)((Object)this)).getClass();
        int iconNumU = n / 64;
        int n2 = picon.func_94216_b();
        ((Object)((Object)this)).getClass();
        int iconNumV = n2 / 64;
        float minv = picon.func_94206_g();
        float maxv = picon.func_94210_h();
        float dv = (maxv - minv) / (float)iconNumV;
        return minv + (float)(index / iconNumU) * dv;
    }

    public float getSubIconDU(int index) {
        IIcon picon = PileBlock.instance.func_149691_a(0, 0);
        int n = picon.func_94211_a();
        ((Object)((Object)this)).getClass();
        int iconNumU = n / 64;
        float minu = picon.func_94209_e();
        float maxu = picon.func_94212_f();
        float du = (maxu - minu) / (float)iconNumU;
        return du;
    }

    public float getSubIconDV(int index) {
        IIcon picon = PileBlock.instance.func_149691_a(0, 0);
        int n = picon.func_94216_b();
        ((Object)((Object)this)).getClass();
        int iconNumV = n / 64;
        float minv = picon.func_94206_g();
        float maxv = picon.func_94210_h();
        float dv = (maxv - minv) / (float)iconNumV;
        return dv;
    }

    public void func_147500_a(TileEntity par1TileEntity, double par2, double par4, double par6, float par8) {
        this.renderAModelAt((PileTileEntity)par1TileEntity, par2, par4, par6, par8);
    }
}

