/*
 * Decompiled with CFR 0.152.
 */
package ihl.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ihl.ClientProxy;
import ihl.IHLMod;
import ihl.enviroment.LightSource;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

@SideOnly(value=Side.CLIENT)
public class RenderBlocksExt
extends RenderBlocks {
    public static RenderBlocksExt instance;
    static final int[][] NULL_NORMAL;
    private static final int[][] YNEG;
    private static final int[][] YPOS;
    private static final int[][] XNEG;
    private static final int[][] XPOS;
    private static final int[][] ZNEG;
    private static final int[][] ZPOS;
    private static final int BRIGHT = 0xFF00F7;
    static final int MASK = 0xFF0003;

    public RenderBlocksExt(IBlockAccess blockAccess) {
        super(blockAccess);
        instance = this;
    }

    private void transformColour(Block block, int x, int y, int z, int[][] normal) {
        int brightnessBase;
        int brightnessBase1 = brightnessBase = block.func_149677_c(this.field_147845_a, x + normal[0][0], y + normal[0][1], z + normal[0][2]);
        int l = block.func_149720_d(this.field_147845_a, x, y, z);
        float redF = (float)(l >> 16 & 0xFF) / 255.0f;
        float greenF = (float)(l >> 8 & 0xFF) / 255.0f;
        float blueF = (float)(l & 0xFF) / 255.0f;
        int baseColourValue = 255;
        int[] baseColour = new int[]{baseColourValue, baseColourValue, baseColourValue};
        int[] topLeft = new int[]{baseColourValue, baseColourValue, baseColourValue};
        int[] topRight = new int[]{baseColourValue, baseColourValue, baseColourValue};
        int[] bottomLeft = new int[]{baseColourValue, baseColourValue, baseColourValue};
        int[] bottomRight = new int[]{baseColourValue, baseColourValue, baseColourValue};
        int brightnessTopLeft1 = this.field_147864_al;
        int brightnessTopRight1 = this.field_147870_ao;
        int brightnessBottomLeft1 = this.field_147874_am;
        int brightnessBottomRight1 = this.field_147876_an;
        boolean lightAffected = false;
        for (LightSource lightSource : ((ClientProxy)IHLMod.proxy).getLightHandler().lightSources) {
            int colourFactor;
            if (!lightSource.isBlockIlluminated(x, y, z)) continue;
            lightAffected = true;
            int[] lightValue = lightSource.getLightValue(x, y, z, normal[0]);
            if ((brightnessBase & 0xF0) < lightValue[0]) {
                colourFactor = lightValue[0] - (brightnessBase & 0xF0);
                if ((brightnessBase1 & 0xF0) < lightValue[0]) {
                    brightnessBase1 &= 0xFF0003;
                    brightnessBase1 |= lightValue[0];
                }
                baseColour[0] = baseColour[0] + lightValue[1] * colourFactor / 255;
                baseColour[1] = baseColour[1] + lightValue[2] * colourFactor / 255;
                baseColour[2] = baseColour[2] + lightValue[3] * colourFactor / 255;
            }
            if (!this.field_147863_w) continue;
            if (lightSource.isBlockIlluminated(x + normal[1][0], y + normal[1][1], z + normal[1][2]) && lightSource.isBlockIlluminated(x + normal[2][0], y + normal[2][1], z + normal[2][2]) && lightSource.isBlockIlluminated(x + normal[3][0], y + normal[3][1], z + normal[3][2]) && (this.field_147864_al & 0xF0) < (lightValue = lightSource.getLightValue(x + normal[3][0], y + normal[3][1], z + normal[3][2], normal[0]))[0]) {
                colourFactor = lightValue[0] - (this.field_147864_al & 0xF0);
                if ((brightnessTopLeft1 & 0xF0) < lightValue[0]) {
                    brightnessTopLeft1 &= 0xFF0003;
                    brightnessTopLeft1 |= lightValue[0];
                }
                topLeft[0] = topLeft[0] + lightValue[1] * colourFactor / 255;
                topLeft[1] = topLeft[1] + lightValue[2] * colourFactor / 255;
                topLeft[2] = topLeft[2] + lightValue[3] * colourFactor / 255;
            }
            if (lightSource.isBlockIlluminated(x + normal[4][0], y + normal[4][1], z + normal[4][2]) && lightSource.isBlockIlluminated(x + normal[5][0], y + normal[5][1], z + normal[5][2]) && lightSource.isBlockIlluminated(x + normal[6][0], y + normal[6][1], z + normal[6][2]) && (this.field_147870_ao & 0xF0) < (lightValue = lightSource.getLightValue(x + normal[6][0], y + normal[6][1], z + normal[6][2], normal[0]))[0]) {
                colourFactor = lightValue[0] - (this.field_147870_ao & 0xF0);
                if ((brightnessTopRight1 & 0xF0) < lightValue[0]) {
                    brightnessTopRight1 &= 0xFF0003;
                    brightnessTopRight1 |= lightValue[0];
                }
                topRight[0] = topRight[0] + lightValue[1] * colourFactor / 255;
                topRight[1] = topRight[1] + lightValue[2] * colourFactor / 255;
                topRight[2] = topRight[2] + lightValue[3] * colourFactor / 255;
            }
            if (lightSource.isBlockIlluminated(x + normal[7][0], y + normal[7][1], z + normal[7][2]) && lightSource.isBlockIlluminated(x + normal[8][0], y + normal[8][1], z + normal[8][2]) && lightSource.isBlockIlluminated(x + normal[9][0], y + normal[9][1], z + normal[9][2]) && (this.field_147874_am & 0xF0) < (lightValue = lightSource.getLightValue(x + normal[9][0], y + normal[9][1], z + normal[9][2], normal[0]))[0]) {
                colourFactor = lightValue[0] - (this.field_147874_am & 0xF0);
                if ((brightnessBottomLeft1 & 0xF0) < lightValue[0]) {
                    brightnessBottomLeft1 &= 0xFF0003;
                    brightnessBottomLeft1 |= lightValue[0];
                }
                bottomLeft[0] = bottomLeft[0] + lightValue[1] * colourFactor / 255;
                bottomLeft[1] = bottomLeft[1] + lightValue[2] * colourFactor / 255;
                bottomLeft[2] = bottomLeft[2] + lightValue[3] * colourFactor / 255;
            }
            if (!lightSource.isBlockIlluminated(x + normal[10][0], y + normal[10][1], z + normal[10][2]) || !lightSource.isBlockIlluminated(x + normal[11][0], y + normal[11][1], z + normal[11][2]) || !lightSource.isBlockIlluminated(x + normal[12][0], y + normal[12][1], z + normal[12][2]) || (this.field_147876_an & 0xF0) >= (lightValue = lightSource.getLightValue(x + normal[12][0], y + normal[12][1], z + normal[12][2], normal[0]))[0]) continue;
            colourFactor = lightValue[0] - (this.field_147876_an & 0xF0);
            if ((brightnessBottomRight1 & 0xF0) < lightValue[0]) {
                brightnessBottomRight1 &= 0xFF0003;
                brightnessBottomRight1 |= lightValue[0];
            }
            bottomRight[0] = bottomRight[0] + lightValue[1] * colourFactor / 255;
            bottomRight[1] = bottomRight[1] + lightValue[2] * colourFactor / 255;
            bottomRight[2] = bottomRight[2] + lightValue[3] * colourFactor / 255;
        }
        if (lightAffected) {
            RenderBlocksExt.normalizeColour(baseColour);
            RenderBlocksExt.normalizeColour(topLeft);
            RenderBlocksExt.normalizeColour(topRight);
            RenderBlocksExt.normalizeColour(bottomLeft);
            RenderBlocksExt.normalizeColour(bottomRight);
            redF = RenderBlocksExt.mixLightColour(redF, baseColour[0]);
            greenF = RenderBlocksExt.mixLightColour(greenF, baseColour[1]);
            blueF = RenderBlocksExt.mixLightColour(blueF, baseColour[2]);
            this.field_147872_ap = RenderBlocksExt.mixLightColour(this.field_147872_ap, topLeft[0]);
            this.field_147846_at = RenderBlocksExt.mixLightColour(this.field_147846_at, topLeft[1]);
            this.field_147854_ax = RenderBlocksExt.mixLightColour(this.field_147854_ax, topLeft[2]);
            this.field_147848_as = RenderBlocksExt.mixLightColour(this.field_147848_as, topRight[0]);
            this.field_147856_aw = RenderBlocksExt.mixLightColour(this.field_147856_aw, topRight[1]);
            this.field_147833_aA = RenderBlocksExt.mixLightColour(this.field_147833_aA, topRight[2]);
            this.field_147852_aq = RenderBlocksExt.mixLightColour(this.field_147852_aq, bottomLeft[0]);
            this.field_147860_au = RenderBlocksExt.mixLightColour(this.field_147860_au, bottomLeft[1]);
            this.field_147841_ay = RenderBlocksExt.mixLightColour(this.field_147841_ay, bottomLeft[2]);
            this.field_147850_ar = RenderBlocksExt.mixLightColour(this.field_147850_ar, bottomRight[0]);
            this.field_147858_av = RenderBlocksExt.mixLightColour(this.field_147858_av, bottomRight[1]);
            this.field_147839_az = RenderBlocksExt.mixLightColour(this.field_147839_az, bottomRight[2]);
            this.field_147864_al = brightnessTopLeft1;
            this.field_147870_ao = brightnessTopRight1;
            this.field_147874_am = brightnessBottomLeft1;
            this.field_147876_an = brightnessBottomRight1;
            Tessellator.field_78398_a.func_78380_c(brightnessBase1);
            Tessellator.field_78398_a.func_78386_a(redF, greenF, blueF);
        }
    }

    static void normalizeColour(int[] colour) {
        int max = colour[0];
        if (max < colour[1]) {
            max = colour[1];
        }
        if (max < colour[2]) {
            max = colour[2];
        }
        if (max != 0) {
            colour[0] = colour[0] * 255 / max;
            colour[1] = colour[1] * 255 / max;
            colour[2] = colour[2] * 255 / max;
        } else {
            colour[0] = 255;
            colour[1] = 255;
            colour[2] = 255;
        }
    }

    static float mixLightColour(float original, int colour) {
        return original * (float)colour / 255.0f;
    }

    public void func_147765_a(IIcon icon, double x, double y, double z, float f) {
        this.transformColour(this.field_147845_a.func_147439_a((int)x, (int)y, (int)z), (int)x, (int)y, (int)z, NULL_NORMAL);
        super.func_147765_a(icon, x, y, z, f);
    }

    public void func_147768_a(Block block, double x, double y, double z, IIcon icon) {
        this.transformColour(block, (int)x, (int)y, (int)z, YNEG);
        super.func_147768_a(block, x, y, z, icon);
    }

    public void func_147806_b(Block block, double x, double y, double z, IIcon icon) {
        this.transformColour(block, (int)x, (int)y, (int)z, YPOS);
        super.func_147806_b(block, x, y, z, icon);
    }

    public void func_147761_c(Block block, double x, double y, double z, IIcon icon) {
        this.transformColour(block, (int)x, (int)y, (int)z, ZNEG);
        super.func_147761_c(block, x, y, z, icon);
    }

    public void func_147734_d(Block block, double x, double y, double z, IIcon icon) {
        this.transformColour(block, (int)x, (int)y, (int)z, ZPOS);
        super.func_147734_d(block, x, y, z, icon);
    }

    public void func_147798_e(Block block, double x, double y, double z, IIcon icon) {
        this.transformColour(block, (int)x, (int)y, (int)z, XNEG);
        super.func_147798_e(block, x, y, z, icon);
    }

    public void func_147764_f(Block block, double x, double y, double z, IIcon icon) {
        this.transformColour(block, (int)x, (int)y, (int)z, XPOS);
        super.func_147764_f(block, x, y, z, icon);
    }

    static {
        NULL_NORMAL = new int[][]{{0, 0, 0}, {1, 0, 0}, {0, 0, 1}, {1, 0, 1}, {-1, 0, 0}, {0, 0, 1}, {-1, 0, 1}, {1, 0, 0}, {0, 0, -1}, {1, 0, -1}, {-1, 0, 0}, {0, 0, -1}, {-1, 0, -1}};
        YNEG = new int[][]{{0, -1, 0}, {-1, 0, 0}, {0, 0, 1}, {-1, 0, 1}, {1, 0, 0}, {0, 0, 1}, {1, 0, 1}, {-1, 0, 0}, {0, 0, -1}, {-1, 0, -1}, {1, 0, 0}, {0, 0, -1}, {1, 0, -1}};
        YPOS = new int[][]{{0, 1, 0}, {1, 0, 0}, {0, 0, 1}, {1, 0, 1}, {-1, 0, 0}, {0, 0, 1}, {-1, 0, 1}, {1, 0, 0}, {0, 0, -1}, {1, 0, -1}, {-1, 0, 0}, {0, 0, -1}, {-1, 0, -1}};
        XNEG = new int[][]{{-1, 0, 0}, {0, 1, 0}, {0, 0, 1}, {0, 1, 1}, {0, -1, 0}, {0, 0, 1}, {0, -1, 1}, {0, 1, 0}, {0, 0, -1}, {0, 1, -1}, {0, -1, 0}, {0, 0, -1}, {0, -1, -1}};
        XPOS = new int[][]{{1, 0, 0}, {0, -1, 0}, {0, 0, 1}, {0, -1, 1}, {0, 1, 0}, {0, 0, 1}, {0, 1, 1}, {0, -1, 0}, {0, 0, -1}, {0, -1, -1}, {0, 1, 0}, {0, 0, -1}, {0, 1, -1}};
        ZNEG = new int[][]{{0, 0, -1}, {-1, 0, 0}, {0, 1, 0}, {-1, 1, 0}, {-1, 0, 0}, {0, -1, 0}, {-1, -1, 0}, {1, 0, 0}, {0, 1, 0}, {1, 1, 0}, {1, 0, 0}, {0, -1, 0}, {1, -1, 0}};
        ZPOS = new int[][]{{0, 0, 1}, {-1, 0, 0}, {0, 1, 0}, {-1, 1, 0}, {1, 0, 0}, {0, 1, 0}, {1, 1, 0}, {-1, 0, 0}, {0, -1, 0}, {-1, -1, 0}, {1, 0, 0}, {0, -1, 0}, {1, -1, 0}};
    }
}

